/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PacketProcessorBase<T extends BookieProtocol.Request>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PacketProcessorBase.class);
    T request;
    BookieRequestHandler requestHandler;
    BookieRequestProcessor requestProcessor;
    long enqueueNanos;

    PacketProcessorBase() {
    }

    protected void init(T request, BookieRequestHandler requestHandler, BookieRequestProcessor requestProcessor) {
        this.request = request;
        this.requestHandler = requestHandler;
        this.requestProcessor = requestProcessor;
        this.enqueueNanos = MathUtils.nowInNano();
    }

    protected void reset() {
        this.request = null;
        this.requestHandler = null;
        this.requestProcessor = null;
        this.enqueueNanos = -1L;
    }

    protected boolean isVersionCompatible() {
        byte version = ((BookieProtocol.Request)this.request).getProtocolVersion();
        if (version < 0 || version > 2) {
            logger.error("Invalid protocol version, expected something between 0 & 2. got " + ((BookieProtocol.Request)this.request).getProtocolVersion());
            return false;
        }
        return true;
    }

    protected void sendWriteReqResponse(int rc, Object response, OpStatsLogger statsLogger) {
        this.sendResponse(rc, response, statsLogger);
        this.requestProcessor.onAddRequestFinish();
    }

    protected void sendReadReqResponse(int rc, Object response, OpStatsLogger statsLogger, boolean throttle) {
        if (throttle) {
            this.sendResponseAndWait(rc, response, statsLogger);
        } else {
            this.sendResponse(rc, response, statsLogger);
        }
        this.requestProcessor.onReadRequestFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(int rc, Object response, OpStatsLogger statsLogger) {
        long writeNanos = MathUtils.nowInNano();
        long timeOut = this.requestProcessor.getWaitTimeoutOnBackpressureMillis();
        Channel channel = this.requestHandler.ctx().channel();
        if (timeOut >= 0L && !channel.isWritable()) {
            if (!this.requestProcessor.isBlacklisted(channel)) {
                Channel channel2 = channel;
                synchronized (channel2) {
                    if (!channel.isWritable() && !this.requestProcessor.isBlacklisted(channel)) {
                        long waitUntilNanos = writeNanos + TimeUnit.MILLISECONDS.toNanos(timeOut);
                        while (!channel.isWritable() && MathUtils.nowInNano() < waitUntilNanos) {
                            try {
                                TimeUnit.MILLISECONDS.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (!channel.isWritable()) {
                            this.requestProcessor.blacklistChannel(channel);
                            this.requestProcessor.handleNonWritableChannel(channel);
                        }
                    }
                }
            }
            if (!channel.isWritable()) {
                logger.warn("cannot write response to non-writable channel {} for request {}", (Object)channel, (Object)StringUtils.requestToString(this.request));
                this.requestProcessor.getRequestStats().getChannelWriteStats().registerFailedEvent(MathUtils.elapsedNanos((long)writeNanos), TimeUnit.NANOSECONDS);
                statsLogger.registerFailedEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
                if (response instanceof BookieProtocol.Response) {
                    ((BookieProtocol.Response)response).release();
                }
                return;
            }
            this.requestProcessor.invalidateBlacklist(channel);
        }
        if (channel.isActive()) {
            ChannelPromise promise = logger.isDebugEnabled() ? channel.newPromise().addListener(future -> {
                if (!future.isSuccess()) {
                    logger.debug("Netty channel write exception. ", future.cause());
                }
            }) : channel.voidPromise();
            channel.writeAndFlush(response, promise);
        } else {
            if (response instanceof BookieProtocol.Response) {
                ((BookieProtocol.Response)response).release();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Netty channel {} is inactive, hence bypassing netty channel writeAndFlush during sendResponse", (Object)channel);
            }
        }
        if (0 == rc) {
            statsLogger.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
        } else {
            statsLogger.registerFailedEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
        }
    }

    protected void sendResponseAndWait(int rc, Object response, OpStatsLogger statsLogger) {
        try {
            Channel channel = this.requestHandler.ctx().channel();
            ChannelFuture future = channel.writeAndFlush(response);
            if (!channel.eventLoop().inEventLoop()) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.debug("Netty channel write exception. ", (Throwable)e);
            return;
        }
        if (0 == rc) {
            statsLogger.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
        } else {
            statsLogger.registerFailedEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void run() {
        if (this.request instanceof BookieProtocol.ReadRequest) {
            this.requestProcessor.getRequestStats().getReadEntrySchedulingDelayStats().registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
        }
        if (this.request instanceof BookieProtocol.ParsedAddRequest) {
            this.requestProcessor.getRequestStats().getWriteThreadQueuedLatency().registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
        }
        if (!this.isVersionCompatible()) {
            this.sendResponse(103, ResponseBuilder.buildErrorResponse(103, this.request), this.requestProcessor.getRequestStats().getReadRequestStats());
            if (this.request instanceof BookieProtocol.ReadRequest) {
                this.requestProcessor.onReadRequestFinish();
            }
            if (this.request instanceof BookieProtocol.ParsedAddRequest) {
                ((BookieProtocol.ParsedAddRequest)this.request).release();
                ((BookieProtocol.Request)this.request).recycle();
                this.requestProcessor.onAddRequestFinish();
            }
            return;
        }
        this.processPacket();
    }

    protected abstract void processPacket();
}

