/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv.impl.options;

import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import org.apache.bookkeeper.api.kv.impl.options.DeleteOptionBuilderImpl;
import org.apache.bookkeeper.api.kv.options.DeleteOption;

class DeleteOptionImpl<K>
implements DeleteOption<K> {
    private final Recycler.Handle<DeleteOptionImpl<K>> handle;
    private boolean prevKv;
    private K endKey;

    static <K> DeleteOptionImpl<K> create(Recycler<DeleteOptionImpl<K>> recycler) {
        return (DeleteOptionImpl)recycler.get();
    }

    DeleteOptionImpl(Recycler.Handle<DeleteOptionImpl<K>> handle) {
        this.handle = handle;
    }

    void set(DeleteOptionBuilderImpl<K> builderImpl) {
        this.prevKv = builderImpl.prevKv();
        ReferenceCountUtil.release(this.endKey);
        this.endKey = ReferenceCountUtil.retain(builderImpl.endKey());
    }

    @Override
    public void close() {
        this.prevKv = false;
        ReferenceCountUtil.release(this.endKey);
        this.endKey = null;
        this.handle.recycle((Object)this);
    }

    public Recycler.Handle<DeleteOptionImpl<K>> handle() {
        return this.handle;
    }

    @Override
    public boolean prevKv() {
        return this.prevKv;
    }

    @Override
    public K endKey() {
        return this.endKey;
    }

    public String toString() {
        return "DeleteOptionImpl(prevKv=" + this.prevKv() + ", endKey=" + this.endKey() + ")";
    }
}

