/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.net.Node;

@InterfaceAudience.Private
public class BlockPlacementPolicyRackFaultTolerant
extends BlockPlacementPolicyDefault {
    @Override
    protected int[] getMaxNodesPerRack(int numOfChosen, int numOfReplicas) {
        int numOfRacks;
        int totalNumOfReplicas = numOfChosen + numOfReplicas;
        int clusterSize = this.clusterMap.getNumOfLeaves();
        if (totalNumOfReplicas > clusterSize) {
            numOfReplicas -= totalNumOfReplicas - clusterSize;
            totalNumOfReplicas = clusterSize;
        }
        if ((numOfRacks = this.clusterMap.getNumOfNonEmptyRacks()) <= 1 || totalNumOfReplicas <= 1) {
            return new int[]{numOfReplicas, totalNumOfReplicas};
        }
        if (totalNumOfReplicas < numOfRacks) {
            return new int[]{numOfReplicas, 1};
        }
        int maxNodesPerRack = (totalNumOfReplicas - 1) / numOfRacks + 1;
        return new int[]{numOfReplicas, maxNodesPerRack};
    }

    @Override
    protected Node chooseTargetInOrder(int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, boolean newBlock, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int totalReplicaExpected = results.size() + numOfReplicas;
        int numOfRacks = this.clusterMap.getNumOfNonEmptyRacks();
        try {
            if (totalReplicaExpected < numOfRacks || totalReplicaExpected % numOfRacks == 0) {
                writer = this.chooseOnce(numOfReplicas, writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                return writer;
            }
            assert (totalReplicaExpected > (maxNodesPerRack - 1) * numOfRacks);
            HashMap<String, Integer> rackCounts = new HashMap<String, Integer>();
            for (DatanodeStorageInfo dsInfo : results) {
                String rack = dsInfo.getDatanodeDescriptor().getNetworkLocation();
                Integer count = (Integer)rackCounts.get(rack);
                if (count != null) {
                    rackCounts.put(rack, count + 1);
                    continue;
                }
                rackCounts.put(rack, 1);
            }
            int excess = 0;
            Iterator<Object> iterator = rackCounts.values().iterator();
            while (iterator.hasNext()) {
                int count = (Integer)iterator.next();
                if (count <= maxNodesPerRack - 1) continue;
                excess += count - (maxNodesPerRack - 1);
            }
            numOfReplicas = Math.min(totalReplicaExpected - results.size(), (maxNodesPerRack - 1) * numOfRacks - (results.size() - excess));
            writer = this.chooseOnce(numOfReplicas, writer, new HashSet<Node>(excludedNodes), blocksize, maxNodesPerRack - 1, results, avoidStaleNodes, storageTypes);
            for (DatanodeStorageInfo resultStorage : results) {
                this.addToExcludedNodes(resultStorage.getDatanodeDescriptor(), excludedNodes);
            }
            LOG.trace("Chosen nodes: {}", results);
            LOG.trace("Excluded nodes: {}", excludedNodes);
            numOfReplicas = totalReplicaExpected - results.size();
            this.chooseOnce(numOfReplicas, writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            LOG.warn("Only able to place {} of total expected {} (maxNodesPerRack={}, numOfReplicas={}) nodes evenly across racks, falling back to evenly place on the remaining racks. This may not guarantee rack-level fault tolerance. Please check if the racks are configured properly.", new Object[]{results.size(), totalReplicaExpected, maxNodesPerRack, numOfReplicas});
            LOG.debug("Caught exception was:", (Throwable)e);
            this.chooseEvenlyFromRemainingRacks(writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes, totalReplicaExpected, e);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chooseEvenlyFromRemainingRacks(Node writer, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes, int totalReplicaExpected, BlockPlacementPolicy.NotEnoughReplicasException e) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int numResultsOflastChoose = 0;
        BlockPlacementPolicy.NotEnoughReplicasException lastException = e;
        int bestEffortMaxNodesPerRack = maxNodesPerRack;
        while (results.size() != totalReplicaExpected && numResultsOflastChoose != results.size()) {
            HashSet<Node> newExcludeNodes = new HashSet<Node>();
            for (DatanodeStorageInfo resultStorage : results) {
                this.addToExcludedNodes(resultStorage.getDatanodeDescriptor(), newExcludeNodes);
            }
            LOG.trace("Chosen nodes: {}", results);
            LOG.trace("Excluded nodes: {}", excludedNodes);
            LOG.trace("New Excluded nodes: {}", newExcludeNodes);
            int numOfReplicas = totalReplicaExpected - results.size();
            numResultsOflastChoose = results.size();
            try {
                this.chooseOnce(numOfReplicas, writer, newExcludeNodes, blocksize, ++bestEffortMaxNodesPerRack, results, avoidStaleNodes, storageTypes);
            }
            catch (BlockPlacementPolicy.NotEnoughReplicasException nere) {
                lastException = nere;
            }
            finally {
                excludedNodes.addAll(newExcludeNodes);
            }
        }
        if (numResultsOflastChoose != totalReplicaExpected) {
            LOG.debug("Best effort placement failed: expecting {} replicas, only chose {}.", (Object)totalReplicaExpected, (Object)numResultsOflastChoose);
            throw lastException;
        }
    }

    private Node chooseOnce(int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (numOfReplicas == 0) {
            return writer;
        }
        writer = this.chooseLocalStorage((Node)writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes, true).getDatanodeDescriptor();
        if (--numOfReplicas == 0) {
            return writer;
        }
        this.chooseRandom(numOfReplicas, "", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        return writer;
    }

    @Override
    public BlockPlacementStatus verifyBlockPlacement(DatanodeInfo[] locs, int numberOfReplicas) {
        if (locs == null) {
            locs = DatanodeDescriptor.EMPTY_ARRAY;
        }
        if (!this.clusterMap.hasClusterEverBeenMultiRack()) {
            return new BlockPlacementStatusDefault(1, 1, 1);
        }
        HashSet<String> racks = new HashSet<String>();
        for (DatanodeInfo dn : locs) {
            racks.add(dn.getNetworkLocation());
        }
        return new BlockPlacementStatusDefault(racks.size(), numberOfReplicas, this.clusterMap.getNumOfNonEmptyRacks());
    }

    @Override
    protected Collection<DatanodeStorageInfo> pickupReplicaSet(Collection<DatanodeStorageInfo> moreThanOne, Collection<DatanodeStorageInfo> exactlyOne, Map<String, List<DatanodeStorageInfo>> rackMap) {
        return moreThanOne.isEmpty() ? exactlyOne : moreThanOne;
    }
}

