/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;

public class AddBlockPoolException
extends RuntimeException {
    private Map<FsVolumeSpi, IOException> unhealthyDataDirs;

    public AddBlockPoolException(Map<FsVolumeSpi, IOException> unhealthyDataDirs) {
        this.unhealthyDataDirs = unhealthyDataDirs;
    }

    public AddBlockPoolException() {
        this.unhealthyDataDirs = new ConcurrentHashMap<FsVolumeSpi, IOException>();
    }

    public void mergeException(AddBlockPoolException e) {
        if (e == null) {
            return;
        }
        for (FsVolumeSpi v : e.unhealthyDataDirs.keySet()) {
            if (this.unhealthyDataDirs.containsKey(v)) continue;
            this.unhealthyDataDirs.put(v, e.unhealthyDataDirs.get(v));
        }
    }

    public boolean hasExceptions() {
        return !this.unhealthyDataDirs.isEmpty();
    }

    public Map<FsVolumeSpi, IOException> getFailingVolumes() {
        return this.unhealthyDataDirs;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.unhealthyDataDirs.toString();
    }
}

