/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top.window;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RollingWindow {
    private static final Logger LOG = LoggerFactory.getLogger(RollingWindow.class);
    Bucket[] buckets;
    final int windowLenMs;
    final int bucketSize;

    RollingWindow(int windowLenMs, int numBuckets) {
        this.buckets = new Bucket[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            this.buckets[i] = new Bucket();
        }
        this.windowLenMs = windowLenMs;
        this.bucketSize = windowLenMs / numBuckets;
        if (this.bucketSize % this.bucketSize != 0) {
            throw new IllegalArgumentException("The bucket size in the rolling window is not integer: windowLenMs= " + windowLenMs + " numBuckets= " + numBuckets);
        }
    }

    public void incAt(long time, long delta) {
        int bi = this.computeBucketIndex(time);
        Bucket bucket = this.buckets[bi];
        if (bucket.isStaleNow(time)) {
            bucket.safeReset(time);
        }
        bucket.inc(delta);
    }

    private int computeBucketIndex(long time) {
        int positionOnWindow = (int)(time % (long)this.windowLenMs);
        int bucketIndex = positionOnWindow * this.buckets.length / this.windowLenMs;
        return bucketIndex;
    }

    public long getSum(long time) {
        long sum = 0L;
        for (Bucket bucket : this.buckets) {
            boolean stale = bucket.isStaleNow(time);
            if (!stale) {
                sum += bucket.value.get();
            }
            if (!LOG.isDebugEnabled()) continue;
            long bucketTime = bucket.updateTime.get();
            String timeStr = new Date(bucketTime).toString();
            LOG.debug("Sum: + " + sum + " Bucket: updateTime: " + timeStr + " (" + bucketTime + ") isStale " + stale + " at " + time);
        }
        return sum;
    }

    private class Bucket {
        private AtomicLong value = new AtomicLong(0L);
        private AtomicLong updateTime = new AtomicLong(-1L);

        private Bucket() {
        }

        boolean isStaleNow(long time) {
            long utime = this.updateTime.get();
            return utime == -1L || time - utime >= (long)RollingWindow.this.windowLenMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void safeReset(long time) {
            Bucket bucket = this;
            synchronized (bucket) {
                if (this.isStaleNow(time)) {
                    this.value.set(0L);
                    this.updateTime.set(time);
                }
            }
        }

        void inc(long delta) {
            this.value.addAndGet(delta);
        }
    }
}

