/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesIndexAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportFieldCapabilitiesIndexAction shardAction;
    private final RemoteClusterService remoteClusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportFieldCapabilitiesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportFieldCapabilitiesIndexAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/field_caps", transportService, actionFilters, FieldCapabilitiesRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        long nowInMillis = request.nowInMillis() == null ? System.currentTimeMillis() : request.nowInMillis();
        ClusterState clusterState = this.clusterService.state();
        Map<String, OriginalIndices> remoteClusterIndices = this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices(), idx -> this.indexNameExpressionResolver.hasIndexAbstraction((String)idx, clusterState));
        OriginalIndices localIndices = remoteClusterIndices.remove("");
        String[] concreteIndices = localIndices == null ? Strings.EMPTY_ARRAY : this.indexNameExpressionResolver.concreteIndexNames(clusterState, localIndices);
        int totalNumRequest = concreteIndices.length + remoteClusterIndices.size();
        CountDown completionCounter = new CountDown(totalNumRequest);
        final List indexResponses = Collections.synchronizedList(new ArrayList());
        final Runnable onResponse = () -> {
            if (completionCounter.countDown()) {
                if (request.isMergeResults()) {
                    listener.onResponse(this.merge(indexResponses, request.includeUnmapped()));
                } else {
                    listener.onResponse(new FieldCapabilitiesResponse(indexResponses));
                }
            }
        };
        if (totalNumRequest == 0) {
            listener.onResponse(new FieldCapabilitiesResponse(new String[0], Collections.emptyMap()));
        } else {
            ActionListener<FieldCapabilitiesIndexResponse> innerListener = new ActionListener<FieldCapabilitiesIndexResponse>(){

                @Override
                public void onResponse(FieldCapabilitiesIndexResponse result) {
                    if (result.canMatch()) {
                        indexResponses.add(result);
                    }
                    onResponse.run();
                }

                @Override
                public void onFailure(Exception e) {
                    onResponse.run();
                }
            };
            for (String index : concreteIndices) {
                this.shardAction.execute(new FieldCapabilitiesIndexRequest(request.fields(), index, localIndices, request.indexFilter(), nowInMillis), innerListener);
            }
            for (Map.Entry entry : remoteClusterIndices.entrySet()) {
                String clusterAlias = (String)entry.getKey();
                OriginalIndices originalIndices = (OriginalIndices)entry.getValue();
                Client remoteClusterClient = this.remoteClusterService.getRemoteClusterClient(this.threadPool, clusterAlias);
                FieldCapabilitiesRequest remoteRequest = new FieldCapabilitiesRequest();
                remoteRequest.setMergeResults(false);
                remoteRequest.indicesOptions(originalIndices.indicesOptions());
                remoteRequest.indices(originalIndices.indices());
                remoteRequest.fields(request.fields());
                remoteRequest.indexFilter(request.indexFilter());
                remoteRequest.nowInMillis(nowInMillis);
                remoteClusterClient.fieldCaps(remoteRequest, ActionListener.wrap(response -> {
                    for (FieldCapabilitiesIndexResponse res : response.getIndexResponses()) {
                        indexResponses.add(new FieldCapabilitiesIndexResponse(RemoteClusterAware.buildRemoteIndexName(clusterAlias, res.getIndexName()), res.get(), res.canMatch()));
                    }
                    onResponse.run();
                }, failure -> onResponse.run()));
            }
        }
    }

    private FieldCapabilitiesResponse merge(List<FieldCapabilitiesIndexResponse> indexResponses, boolean includeUnmapped) {
        String[] indices = (String[])indexResponses.stream().map(FieldCapabilitiesIndexResponse::getIndexName).sorted().toArray(String[]::new);
        HashMap<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder = new HashMap<String, Map<String, FieldCapabilities.Builder>>();
        for (FieldCapabilitiesIndexResponse response : indexResponses) {
            this.innerMerge(responseMapBuilder, response.getIndexName(), response.get());
        }
        HashMap responseMap = new HashMap();
        for (Map.Entry entry : responseMapBuilder.entrySet()) {
            Map typeMapBuilder = (Map)entry.getValue();
            if (includeUnmapped) {
                this.addUnmappedFields(indices, (String)entry.getKey(), typeMapBuilder);
            }
            boolean multiTypes = typeMapBuilder.size() > 1;
            HashMap<String, FieldCapabilities> typeMap = new HashMap<String, FieldCapabilities>();
            for (Map.Entry fieldEntry : typeMapBuilder.entrySet()) {
                typeMap.put((String)fieldEntry.getKey(), ((FieldCapabilities.Builder)fieldEntry.getValue()).build(multiTypes));
            }
            responseMap.put((String)entry.getKey(), Collections.unmodifiableMap(typeMap));
        }
        return new FieldCapabilitiesResponse(indices, Collections.unmodifiableMap(responseMap));
    }

    private void addUnmappedFields(String[] indices, String field, Map<String, FieldCapabilities.Builder> typeMap) {
        HashSet unmappedIndices = new HashSet();
        Arrays.stream(indices).forEach(unmappedIndices::add);
        typeMap.values().stream().forEach(b -> b.getIndices().stream().forEach(unmappedIndices::remove));
        if (!unmappedIndices.isEmpty()) {
            FieldCapabilities.Builder unmapped = new FieldCapabilities.Builder(field, "unmapped");
            typeMap.put("unmapped", unmapped);
            for (String index : unmappedIndices) {
                unmapped.add(index, false, false, Collections.emptyMap());
            }
        }
    }

    private void innerMerge(Map<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder, String indexName, Map<String, IndexFieldCapabilities> map) {
        for (Map.Entry<String, IndexFieldCapabilities> entry : map.entrySet()) {
            String field = entry.getKey();
            IndexFieldCapabilities fieldCap = entry.getValue();
            Map typeMap = responseMapBuilder.computeIfAbsent(field, f -> new HashMap());
            FieldCapabilities.Builder builder = typeMap.computeIfAbsent(fieldCap.getType(), key -> new FieldCapabilities.Builder(field, (String)key));
            builder.add(indexName, fieldCap.isSearchable(), fieldCap.isAggregatable(), fieldCap.meta());
        }
    }
}

