/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogMessage;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.SlowLogLevel;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.search.internal.SearchContext;

public final class SearchSlowLog
implements SearchOperationListener {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private long queryWarnThreshold;
    private long queryInfoThreshold;
    private long queryDebugThreshold;
    private long queryTraceThreshold;
    private long fetchWarnThreshold;
    private long fetchInfoThreshold;
    private long fetchDebugThreshold;
    private long fetchTraceThreshold;
    private final Logger queryLogger = LogManager.getLogger((String)"index.search.slowlog.query");
    private final Logger fetchLogger = LogManager.getLogger((String)"index.search.slowlog.fetch");
    static final String INDEX_SEARCH_SLOWLOG_PREFIX = "index.search.slowlog";
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.warn", TimeValue.timeValueNanos((long)-1L), TimeValue.timeValueMillis((long)-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.info", TimeValue.timeValueNanos((long)-1L), TimeValue.timeValueMillis((long)-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.debug", TimeValue.timeValueNanos((long)-1L), TimeValue.timeValueMillis((long)-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.trace", TimeValue.timeValueNanos((long)-1L), TimeValue.timeValueMillis((long)-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.warn", TimeValue.timeValueNanos((long)-1L), TimeValue.timeValueMillis((long)-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.info", TimeValue.timeValueNanos((long)-1L), TimeValue.timeValueMillis((long)-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.debug", TimeValue.timeValueNanos((long)-1L), TimeValue.timeValueMillis((long)-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.trace", TimeValue.timeValueNanos((long)-1L), TimeValue.timeValueMillis((long)-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<SlowLogLevel> INDEX_SEARCH_SLOWLOG_LEVEL = new Setting<SlowLogLevel>("index.search.slowlog.level", SlowLogLevel.TRACE.name(), SlowLogLevel::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("pretty", "false"));
    private SlowLogLevel level;

    public SearchSlowLog(IndexSettings indexSettings) {
        Loggers.setLevel(this.fetchLogger, SlowLogLevel.TRACE.name());
        Loggers.setLevel(this.queryLogger, SlowLogLevel.TRACE.name());
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING, this::setQueryWarnThreshold);
        this.queryWarnThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING, this::setQueryInfoThreshold);
        this.queryInfoThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING, this::setQueryDebugThreshold);
        this.queryDebugThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING, this::setQueryTraceThreshold);
        this.queryTraceThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING, this::setFetchWarnThreshold);
        this.fetchWarnThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING, this::setFetchInfoThreshold);
        this.fetchInfoThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING, this::setFetchDebugThreshold);
        this.fetchDebugThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING, this::setFetchTraceThreshold);
        this.fetchTraceThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_LEVEL, this::setLevel);
        this.setLevel(indexSettings.getValue(INDEX_SEARCH_SLOWLOG_LEVEL));
    }

    private void setLevel(SlowLogLevel level) {
        this.level = level;
    }

    @Override
    public void onQueryPhase(SearchContext context, long tookInNanos) {
        if (this.queryWarnThreshold >= 0L && tookInNanos > this.queryWarnThreshold && this.level.isLevelEnabledFor(SlowLogLevel.WARN)) {
            this.queryLogger.warn((Message)new SearchSlowLogMessage(context, tookInNanos));
        } else if (this.queryInfoThreshold >= 0L && tookInNanos > this.queryInfoThreshold && this.level.isLevelEnabledFor(SlowLogLevel.INFO)) {
            this.queryLogger.info((Message)new SearchSlowLogMessage(context, tookInNanos));
        } else if (this.queryDebugThreshold >= 0L && tookInNanos > this.queryDebugThreshold && this.level.isLevelEnabledFor(SlowLogLevel.DEBUG)) {
            this.queryLogger.debug((Message)new SearchSlowLogMessage(context, tookInNanos));
        } else if (this.queryTraceThreshold >= 0L && tookInNanos > this.queryTraceThreshold && this.level.isLevelEnabledFor(SlowLogLevel.TRACE)) {
            this.queryLogger.trace((Message)new SearchSlowLogMessage(context, tookInNanos));
        }
    }

    @Override
    public void onFetchPhase(SearchContext context, long tookInNanos) {
        if (this.fetchWarnThreshold >= 0L && tookInNanos > this.fetchWarnThreshold && this.level.isLevelEnabledFor(SlowLogLevel.WARN)) {
            this.fetchLogger.warn((Message)new SearchSlowLogMessage(context, tookInNanos));
        } else if (this.fetchInfoThreshold >= 0L && tookInNanos > this.fetchInfoThreshold && this.level.isLevelEnabledFor(SlowLogLevel.INFO)) {
            this.fetchLogger.info((Message)new SearchSlowLogMessage(context, tookInNanos));
        } else if (this.fetchDebugThreshold >= 0L && tookInNanos > this.fetchDebugThreshold && this.level.isLevelEnabledFor(SlowLogLevel.DEBUG)) {
            this.fetchLogger.debug((Message)new SearchSlowLogMessage(context, tookInNanos));
        } else if (this.fetchTraceThreshold >= 0L && tookInNanos > this.fetchTraceThreshold && this.level.isLevelEnabledFor(SlowLogLevel.TRACE)) {
            this.fetchLogger.trace((Message)new SearchSlowLogMessage(context, tookInNanos));
        }
    }

    private void setQueryWarnThreshold(TimeValue warnThreshold) {
        this.queryWarnThreshold = warnThreshold.nanos();
    }

    private void setQueryInfoThreshold(TimeValue infoThreshold) {
        this.queryInfoThreshold = infoThreshold.nanos();
    }

    private void setQueryDebugThreshold(TimeValue debugThreshold) {
        this.queryDebugThreshold = debugThreshold.nanos();
    }

    private void setQueryTraceThreshold(TimeValue traceThreshold) {
        this.queryTraceThreshold = traceThreshold.nanos();
    }

    private void setFetchWarnThreshold(TimeValue warnThreshold) {
        this.fetchWarnThreshold = warnThreshold.nanos();
    }

    private void setFetchInfoThreshold(TimeValue infoThreshold) {
        this.fetchInfoThreshold = infoThreshold.nanos();
    }

    private void setFetchDebugThreshold(TimeValue debugThreshold) {
        this.fetchDebugThreshold = debugThreshold.nanos();
    }

    private void setFetchTraceThreshold(TimeValue traceThreshold) {
        this.fetchTraceThreshold = traceThreshold.nanos();
    }

    long getQueryWarnThreshold() {
        return this.queryWarnThreshold;
    }

    long getQueryInfoThreshold() {
        return this.queryInfoThreshold;
    }

    long getQueryDebugThreshold() {
        return this.queryDebugThreshold;
    }

    long getQueryTraceThreshold() {
        return this.queryTraceThreshold;
    }

    long getFetchWarnThreshold() {
        return this.fetchWarnThreshold;
    }

    long getFetchInfoThreshold() {
        return this.fetchInfoThreshold;
    }

    long getFetchDebugThreshold() {
        return this.fetchDebugThreshold;
    }

    long getFetchTraceThreshold() {
        return this.fetchTraceThreshold;
    }

    SlowLogLevel getLevel() {
        return this.level;
    }

    static final class SearchSlowLogMessage
    extends ESLogMessage {
        SearchSlowLogMessage(SearchContext context, long tookInNanos) {
            super(SearchSlowLogMessage.prepareMap(context, tookInNanos), SearchSlowLogMessage.message(context, tookInNanos), new Object[0]);
        }

        private static Map<String, Object> prepareMap(SearchContext context, long tookInNanos) {
            HashMap<String, Object> messageFields = new HashMap<String, Object>();
            messageFields.put("message", context.indexShard().shardId());
            messageFields.put("took", TimeValue.timeValueNanos((long)tookInNanos));
            messageFields.put("took_millis", TimeUnit.NANOSECONDS.toMillis(tookInNanos));
            if (context.queryResult().getTotalHits() != null) {
                messageFields.put("total_hits", context.queryResult().getTotalHits());
            } else {
                messageFields.put("total_hits", "-1");
            }
            String[] types = context.getQueryShardContext().getTypes();
            messageFields.put("types", SearchSlowLogMessage.escapeJson(SearchSlowLogMessage.asJsonArray(types != null ? Arrays.stream(types) : Stream.empty())));
            messageFields.put("stats", SearchSlowLogMessage.escapeJson(SearchSlowLogMessage.asJsonArray(context.groupStats() != null ? context.groupStats().stream() : Stream.empty())));
            messageFields.put("search_type", (Object)context.searchType());
            messageFields.put("total_shards", context.numberOfShards());
            if (context.request().source() != null) {
                String source = SearchSlowLogMessage.escapeJson(context.request().source().toString(FORMAT_PARAMS));
                messageFields.put("source", source);
            } else {
                messageFields.put("source", "{}");
            }
            messageFields.put("id", context.getTask().getHeader("X-Opaque-Id"));
            return messageFields;
        }

        private static String message(SearchContext context, long tookInNanos) {
            StringBuilder sb = new StringBuilder();
            sb.append(context.indexShard().shardId()).append(" ").append("took[").append(TimeValue.timeValueNanos((long)tookInNanos)).append("], ").append("took_millis[").append(TimeUnit.NANOSECONDS.toMillis(tookInNanos)).append("], ").append("total_hits[");
            if (context.queryResult().getTotalHits() != null) {
                sb.append(context.queryResult().getTotalHits());
            } else {
                sb.append("-1");
            }
            sb.append("], ");
            if (context.getQueryShardContext().getTypes() == null) {
                sb.append("types[], ");
            } else {
                sb.append("types[");
                Strings.arrayToDelimitedString(context.getQueryShardContext().getTypes(), ",", sb);
                sb.append("], ");
            }
            if (context.groupStats() == null) {
                sb.append("stats[], ");
            } else {
                sb.append("stats[");
                Strings.collectionToDelimitedString(context.groupStats(), ",", "", "", sb);
                sb.append("], ");
            }
            sb.append("search_type[").append((Object)context.searchType()).append("], total_shards[").append(context.numberOfShards()).append("], ");
            if (context.request().source() != null) {
                sb.append("source[").append(context.request().source().toString(FORMAT_PARAMS)).append("], ");
            } else {
                sb.append("source[], ");
            }
            if (context.getTask().getHeader("X-Opaque-Id") != null) {
                sb.append("id[").append(context.getTask().getHeader("X-Opaque-Id")).append("], ");
            } else {
                sb.append("id[], ");
            }
            return sb.toString();
        }

        private static String escapeJson(String text) {
            byte[] sourceEscaped = JsonStringEncoder.getInstance().quoteAsUTF8(text);
            return new String(sourceEscaped, UTF_8);
        }
    }
}

