/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public final class InternalAggregations
extends Aggregations
implements Writeable {
    public static final InternalAggregations EMPTY = new InternalAggregations(Collections.emptyList());
    private static final Comparator<InternalAggregation> INTERNAL_AGG_COMPARATOR = (agg1, agg2) -> {
        if (agg1.isMapped() == agg2.isMapped()) {
            return 0;
        }
        if (agg1.isMapped() && !agg2.isMapped()) {
            return -1;
        }
        return 1;
    };
    private final Supplier<PipelineAggregator.PipelineTree> pipelineTreeForBwcSerialization;

    private InternalAggregations(List<InternalAggregation> aggregations) {
        super(aggregations);
        this.pipelineTreeForBwcSerialization = null;
    }

    public InternalAggregations(List<InternalAggregation> aggregations, Supplier<PipelineAggregator.PipelineTree> pipelineTreeSource) {
        super(aggregations);
        this.pipelineTreeForBwcSerialization = pipelineTreeSource;
    }

    public static InternalAggregations from(List<InternalAggregation> aggregations) {
        if (aggregations.isEmpty()) {
            return EMPTY;
        }
        return new InternalAggregations(aggregations);
    }

    public static InternalAggregations readFrom(StreamInput in) throws IOException {
        InternalAggregations res = InternalAggregations.from(in.readList(stream -> in.readNamedWriteable(InternalAggregation.class)));
        if (in.getVersion().before(Version.V_7_8_0) && in.getVersion().onOrAfter(Version.V_6_7_0)) {
            in.readNamedWriteableList(PipelineAggregator.class);
        }
        return res;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_7_8_0)) {
            if (this.pipelineTreeForBwcSerialization == null) {
                this.mergePipelineTreeForBWCSerialization(PipelineAggregator.PipelineTree.EMPTY);
                out.writeNamedWriteableList(this.getInternalAggregations());
                if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                    out.writeNamedWriteableList(Collections.emptyList());
                }
            } else {
                PipelineAggregator.PipelineTree pipelineTree = this.pipelineTreeForBwcSerialization.get();
                this.mergePipelineTreeForBWCSerialization(pipelineTree);
                out.writeNamedWriteableList(this.getInternalAggregations());
                if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                    out.writeNamedWriteableList(pipelineTree.aggregators());
                }
            }
        } else {
            out.writeNamedWriteableList(this.getInternalAggregations());
        }
    }

    public void mergePipelineTreeForBWCSerialization(PipelineAggregator.PipelineTree pipelineTree) {
        this.getInternalAggregations().stream().forEach(agg -> agg.mergePipelineTreeForBWCSerialization(pipelineTree.subTree(agg.getName())));
    }

    public List<InternalAggregation> copyResults() {
        return new ArrayList<InternalAggregation>(this.getInternalAggregations());
    }

    @Deprecated
    public List<SiblingPipelineAggregator> getTopLevelPipelineAggregators() {
        if (this.pipelineTreeForBwcSerialization == null) {
            return Collections.emptyList();
        }
        return this.pipelineTreeForBwcSerialization.get().aggregators().stream().map(p -> (SiblingPipelineAggregator)p).collect(Collectors.toList());
    }

    @Deprecated
    Supplier<PipelineAggregator.PipelineTree> getPipelineTreeForBwcSerialization() {
        return this.pipelineTreeForBwcSerialization;
    }

    private List<InternalAggregation> getInternalAggregations() {
        return this.aggregations;
    }

    public double sortValue(AggregationPath.PathElement head, Iterator<AggregationPath.PathElement> tail) {
        InternalAggregation aggregation = (InternalAggregation)this.get(head.name);
        if (aggregation == null) {
            throw new IllegalArgumentException("Cannot find aggregation named [" + head.name + "]");
        }
        if (tail.hasNext()) {
            return aggregation.sortValue(tail.next(), tail);
        }
        return aggregation.sortValue(head.key);
    }

    public static InternalAggregations topLevelReduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context) {
        InternalAggregations reduced = InternalAggregations.reduce(aggregationsList, context, reducedAggregations -> new InternalAggregations((List<InternalAggregation>)reducedAggregations, context.pipelineTreeForBwcSerialization()));
        if (reduced == null) {
            return null;
        }
        if (context.isFinalReduce()) {
            List<InternalAggregation> reducedInternalAggs = reduced.getInternalAggregations();
            reducedInternalAggs = reducedInternalAggs.stream().map(agg -> agg.reducePipelines((InternalAggregation)agg, context, context.pipelineTreeRoot().subTree(agg.getName()))).collect(Collectors.toList());
            for (PipelineAggregator pipelineAggregator : context.pipelineTreeRoot().aggregators()) {
                SiblingPipelineAggregator sib = (SiblingPipelineAggregator)pipelineAggregator;
                InternalAggregation newAgg = sib.doReduce(InternalAggregations.from(reducedInternalAggs), context);
                reducedInternalAggs.add(newAgg);
            }
            return InternalAggregations.from(reducedInternalAggs);
        }
        return reduced;
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context, Function<List<InternalAggregation>, InternalAggregations> ctor) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        HashMap<String, List> aggByName = new HashMap<String, List>();
        for (InternalAggregations aggregations : aggregationsList) {
            for (Aggregation aggregation : aggregations.aggregations) {
                List aggs = aggByName.computeIfAbsent(aggregation.getName(), k -> new ArrayList(aggregationsList.size()));
                aggs.add((InternalAggregation)aggregation);
            }
        }
        ArrayList<InternalAggregation> reducedAggregations = new ArrayList<InternalAggregation>();
        for (Map.Entry entry : aggByName.entrySet()) {
            List aggregations = (List)entry.getValue();
            aggregations.sort(INTERNAL_AGG_COMPARATOR);
            InternalAggregation first = (InternalAggregation)aggregations.get(0);
            if (first.mustReduceOnSingleInternalAgg() || aggregations.size() > 1) {
                reducedAggregations.add(first.reduce(aggregations, context));
                continue;
            }
            reducedAggregations.add(first);
        }
        return ctor.apply(reducedAggregations);
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context) {
        return InternalAggregations.reduce(aggregationsList, context, InternalAggregations::from);
    }

    public long getSerializedSize() {
        long l;
        CountingStreamOutput out = new CountingStreamOutput();
        try {
            out.setVersion(Version.CURRENT);
            this.writeTo(out);
            l = out.size;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exc) {
                throw new RuntimeException(exc);
            }
        }
        out.close();
        return l;
    }

    private static class CountingStreamOutput
    extends StreamOutput {
        long size = 0L;

        private CountingStreamOutput() {
        }

        @Override
        public void writeByte(byte b) throws IOException {
            ++this.size;
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.size += (long)length;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void reset() throws IOException {
            this.size = 0L;
        }

        public long length() {
            return this.size;
        }
    }
}

