/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyevaluator.RangerValidityScheduleEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerValidityScheduleConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerValidityScheduleConditionEvaluator.class);
    private List<RangerValidityScheduleEvaluator> evaluators = Collections.emptyList();

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidityScheduleConditionEvaluator.init({})", (Object)this.condition);
        }
        super.init();
        if (this.condition != null && this.condition.getValues() != null && !this.condition.getValues().isEmpty()) {
            this.evaluators = new ArrayList<RangerValidityScheduleEvaluator>(this.condition.getValues().size());
            for (String scheduleStr : this.condition.getValues()) {
                try {
                    RangerValiditySchedule schedule = JsonUtils.jsonToObject(scheduleStr, RangerValiditySchedule.class);
                    if (schedule == null) continue;
                    this.evaluators.add(new RangerValidityScheduleEvaluator(schedule));
                }
                catch (Exception excp) {
                    LOG.error("RangerValidityScheduleConditionEvaluator.init({}): failed to initialize schedule {}", new Object[]{this.condition, scheduleStr, excp});
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidityScheduleConditionEvaluator.init({}): evaluator={}", (Object)this.condition, this.evaluators);
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidityScheduleConditionEvaluator.isMatched({})", (Object)request);
        }
        if (this.evaluators.isEmpty() || request.getAccessTime() == null) {
            ret = true;
        } else {
            long accessTime = request.getAccessTime().getTime();
            boolean bl = ret = this.evaluators.stream().filter(evaluator -> evaluator.isApplicable(accessTime)).findFirst().orElse(null) != null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidityScheduleConditionEvaluator.isMatched({}): condition={}, ret={}", new Object[]{request, this.condition, ret});
        }
        return ret;
    }
}

