/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;

public class RandomStream
extends TupleStream
implements Expressible {
    private String zkHost;
    private Map<String, String> props;
    private String collection;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;
    private Iterator<SolrDocument> documentIterator;
    private int x;
    private boolean outputX;

    public RandomStream() {
    }

    public RandomStream(String zkHost, String collection, Map<String, String> props) throws IOException {
        this.init(zkHost, collection, props);
    }

    public RandomStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("buckets") || namedParam.getName().equals("bucketSorts") || namedParam.getName().equals("limit")) continue;
            params.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(zkHost, collectionName, params);
    }

    void init(String zkHost, String collection, Map<String, String> props) throws IOException {
        this.zkHost = zkHost;
        this.props = props;
        this.collection = collection;
        if (props.containsKey("fl")) {
            String fl = props.get("fl");
            if (fl != null) {
                if (fl.equals("*")) {
                    this.outputX = true;
                } else {
                    String[] fields;
                    for (String f : fields = fl.split(",")) {
                        if (!f.trim().equals("x")) continue;
                        this.outputX = true;
                    }
                }
            } else {
                this.outputX = true;
            }
        } else {
            this.outputX = true;
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        for (Map.Entry<String, String> param : this.props.entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), param.getValue()));
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        if (null != this.props) {
            child.setExpression(this.props.entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(",")));
        }
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public void open() throws IOException {
        if (this.cache != null) {
            this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
        } else {
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(this.zkHost);
            this.cloudSolrClient = ((CloudSolrClient.Builder)((CloudSolrClient.Builder)new CloudSolrClient.Builder(hosts, Optional.empty()).withSocketTimeout(30000)).withConnectionTimeout(15000)).build();
        }
        ModifiableSolrParams params = this.getParams(this.props);
        params.remove("sort");
        Random rand = new Random();
        int seed = rand.nextInt();
        String sortField = "random_" + seed;
        params.add("sort", sortField + " asc");
        QueryRequest request = new QueryRequest(params, SolrRequest.METHOD.POST);
        try {
            QueryResponse response = (QueryResponse)request.process(this.cloudSolrClient, this.collection);
            SolrDocumentList docs = response.getResults();
            this.documentIterator = docs.iterator();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cache == null) {
            this.cloudSolrClient.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        if (this.documentIterator.hasNext()) {
            Tuple tuple = new Tuple();
            SolrDocument doc = this.documentIterator.next();
            if (this.outputX) {
                tuple.put("x", this.x++);
            }
            for (Map.Entry<String, Object> entry : doc.entrySet()) {
                tuple.put(entry.getKey(), entry.getValue());
            }
            return tuple;
        }
        return Tuple.EOF();
    }

    private ModifiableSolrParams getParams(Map<String, String> props) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String value = entry.getValue();
            params.add(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }
}

