/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class CountMetric
extends Metric {
    private String columnName;
    private long count;
    private boolean isAllColumns;

    public CountMetric() {
        this("*");
    }

    public CountMetric(String columnName) {
        this.init("count", columnName);
    }

    public CountMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        String columnName = factory.getValueOperand(expression, 0);
        if (1 != expression.getParameters().size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        this.init(functionName, columnName);
    }

    @Override
    public String[] getColumns() {
        if (this.isAllColumns()) {
            return new String[0];
        }
        return new String[]{this.columnName};
    }

    private void init(String functionName, String columnName) {
        this.columnName = columnName;
        this.isAllColumns = "*".equals(this.columnName);
        this.outputLong = true;
        this.setFunctionName(functionName);
        this.setIdentifier(functionName, "(", columnName, ")");
    }

    private boolean isAllColumns() {
        return this.isAllColumns;
    }

    @Override
    public void update(Tuple tuple) {
        if (this.isAllColumns() || tuple.get(this.columnName) != null) {
            ++this.count;
        }
    }

    @Override
    public Long getValue() {
        return this.count;
    }

    @Override
    public Metric newInstance() {
        return new CountMetric(this.columnName);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter(this.columnName);
    }
}

