/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.configuration.ConfigDefaultsHolder;
import io.airlift.configuration.ConfigurationBinding;
import io.airlift.configuration.ConfigurationBindingListener;
import io.airlift.configuration.ConfigurationBindingListenerHolder;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationProvider;
import io.airlift.configuration.GlobalDefaults;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;

public class ConfigBinder {
    private final InternalConfigBinder binder;

    public static ConfigBinder configBinder(Binder binder) {
        return new ConfigBinder(new GuiceConfigBinder(binder));
    }

    static ConfigBinder configBinder(ConfigurationFactory configurationFactory, Optional<Object> bindingSource) {
        return new ConfigBinder(new CallbackConfigBinder(configurationFactory, bindingSource));
    }

    private ConfigBinder(InternalConfigBinder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null");
    }

    public <T> void bindConfig(Class<T> configClass) {
        Objects.requireNonNull(configClass, "configClass is null");
        this.bindConfig(Key.get(configClass), configClass, null);
    }

    public <T> void bindConfig(Class<T> configClass, Annotation annotation) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        this.bindConfig(Key.get(configClass, (Annotation)annotation), configClass, null);
    }

    public <T> void bindConfig(Class<T> configClass, Class<? extends Annotation> annotation) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        this.bindConfig(Key.get(configClass, annotation), configClass, null);
    }

    public <T> void bindConfig(Class<T> configClass, String prefix) {
        Objects.requireNonNull(configClass, "configClass is null");
        this.bindConfig(Key.get(configClass), configClass, prefix);
    }

    public <T> void bindConfig(Class<T> configClass, Annotation annotation, String prefix) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        this.bindConfig(Key.get(configClass, (Annotation)annotation), configClass, prefix);
    }

    public <T> void bindConfig(Class<T> configClass, Class<? extends Annotation> annotation, String prefix) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        this.bindConfig(Key.get(configClass, annotation), configClass, prefix);
    }

    public <T> void bindConfig(Key<T> key, Class<T> configClass, String prefix) {
        this.binder.bind(new ConfigurationBinding<T>(key, configClass, Optional.ofNullable(prefix)));
    }

    public <T> void bindConfigDefaults(Class<T> configClass, ConfigDefaults<T> configDefaults) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(configDefaults, "configDefaults is null");
        this.bindConfigDefaults(Key.get(configClass), configDefaults);
    }

    public <T> void bindConfigDefaults(Class<T> configClass, Annotation annotation, ConfigDefaults<T> configDefaults) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        Objects.requireNonNull(configDefaults, "configDefaults is null");
        this.bindConfigDefaults(Key.get(configClass, (Annotation)annotation), configDefaults);
    }

    public <T> void bindConfigDefaults(Class<T> configClass, Class<? extends Annotation> annotation, ConfigDefaults<T> configDefaults) {
        Objects.requireNonNull(configClass, "configClass is null");
        Objects.requireNonNull(annotation, "annotation is null");
        Objects.requireNonNull(configDefaults, "configDefaults is null");
        this.bindConfigDefaults(Key.get(configClass, annotation), configDefaults);
    }

    public <T> void bindConfigDefaults(Key<T> key, ConfigDefaults<T> configDefaults) {
        this.binder.bindConfigDefaults(new ConfigDefaultsHolder<T>(key, configDefaults));
    }

    public <T> void bindConfigGlobalDefaults(Class<T> configClass, ConfigDefaults<T> configDefaults) {
        Key key = Key.get(configClass, GlobalDefaults.class);
        this.binder.bindConfigDefaults(new ConfigDefaultsHolder<T>(key, configDefaults));
    }

    public void bindConfigurationBindingListener(ConfigurationBindingListener configurationBindingListener) {
        this.binder.bindConfigurationBindingListener(configurationBindingListener);
    }

    private static final class CallbackConfigBinder
    implements InternalConfigBinder {
        private final ConfigurationFactory configurationFactory;
        private final Optional<Object> bindingSource;

        public CallbackConfigBinder(ConfigurationFactory configurationFactory, Optional<Object> bindingSource) {
            this.configurationFactory = Objects.requireNonNull(configurationFactory, "configurationFactory is null");
            this.bindingSource = Objects.requireNonNull(bindingSource, "bindingSource is null");
        }

        @Override
        public <T> void bind(ConfigurationBinding<T> configurationBinding) {
            this.configurationFactory.registerConfigurationProvider(new ConfigurationProvider<T>(configurationBinding), this.bindingSource);
        }

        @Override
        public <T> void bindConfigDefaults(ConfigDefaultsHolder<T> configDefaultsHolder) {
            this.configurationFactory.registerConfigDefaults(configDefaultsHolder);
        }

        @Override
        public void bindConfigurationBindingListener(ConfigurationBindingListener configurationBindingListener) {
            this.configurationFactory.addConfigurationBindingListener(configurationBindingListener);
        }
    }

    private static final class GuiceConfigBinder
    implements InternalConfigBinder {
        private final Binder binder;
        private Multibinder<ConfigurationBindingListenerHolder> listenerMultibinder;

        public GuiceConfigBinder(Binder binder) {
            this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass(), ConfigBinder.class});
            this.listenerMultibinder = Multibinder.newSetBinder((Binder)binder, ConfigurationBindingListenerHolder.class);
        }

        @Override
        public <T> void bind(ConfigurationBinding<T> configurationBinding) {
            Key<T> key = configurationBinding.getKey();
            this.binder.bind(key).toProvider(new ConfigurationProvider<T>(configurationBinding));
            this.createConfigDefaultsBinder(key);
        }

        @Override
        public <T> void bindConfigDefaults(ConfigDefaultsHolder<T> configDefaultsHolder) {
            this.createConfigDefaultsBinder(configDefaultsHolder.getConfigKey()).addBinding().toInstance(configDefaultsHolder);
        }

        @Override
        public void bindConfigurationBindingListener(ConfigurationBindingListener configurationBindingListener) {
            this.listenerMultibinder.addBinding().toInstance((Object)new ConfigurationBindingListenerHolder(configurationBindingListener));
        }

        private <T> Multibinder<ConfigDefaultsHolder<T>> createConfigDefaultsBinder(Key<T> key) {
            TypeLiteral<ConfigDefaultsHolder<T>> typeLiteral = GuiceConfigBinder.getTypeLiteral(key);
            if (key.getAnnotationType() == null) {
                return Multibinder.newSetBinder((Binder)this.binder, typeLiteral);
            }
            if (key.hasAttributes()) {
                return Multibinder.newSetBinder((Binder)this.binder, typeLiteral, (Annotation)key.getAnnotation());
            }
            return Multibinder.newSetBinder((Binder)this.binder, typeLiteral, (Class)key.getAnnotationType());
        }

        private static <T> TypeLiteral<ConfigDefaultsHolder<T>> getTypeLiteral(Key<T> key) {
            TypeToken typeToken = TypeToken.of((Type)key.getTypeLiteral().getType());
            return TypeLiteral.get((Type)new TypeToken<ConfigDefaultsHolder<T>>(){}.where(new TypeParameter<T>(){}, typeToken).getType());
        }
    }

    public static interface InternalConfigBinder {
        public <T> void bind(ConfigurationBinding<T> var1);

        public <T> void bindConfigDefaults(ConfigDefaultsHolder<T> var1);

        public void bindConfigurationBindingListener(ConfigurationBindingListener var1);
    }
}

