/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.presto.authorizer;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemAccessControlFactory;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.thirdparty.com.google.common.base.Throwables;
import org.apache.ranger.authorization.presto.authorizer.RangerConfig;
import org.apache.ranger.authorization.presto.authorizer.RangerSystemAccessControl;

public class RangerSystemAccessControlFactory
implements SystemAccessControlFactory {
    private static final String NAME = "ranger";

    public String getName() {
        return NAME;
    }

    public SystemAccessControl create(Map<String, String> config) {
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{binder -> {
                ConfigBinder.configBinder((Binder)binder).bindConfig(RangerConfig.class);
                binder.bind(RangerSystemAccessControl.class).in(Scopes.SINGLETON);
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (SystemAccessControl)injector.getInstance(RangerSystemAccessControl.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

