/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;

public final class InternalAutoDateHistogram
extends InternalMultiBucketAggregation<InternalAutoDateHistogram, Bucket>
implements Histogram,
HistogramFactory {
    private final List<Bucket> buckets;
    private final DocValueFormat format;
    private final BucketInfo bucketInfo;
    private final int targetBuckets;
    private final long bucketInnerInterval;

    InternalAutoDateHistogram(String name, List<Bucket> buckets, int targetBuckets, BucketInfo emptyBucketInfo, DocValueFormat formatter, Map<String, Object> metadata, long bucketInnerInterval) {
        super(name, metadata);
        this.buckets = buckets;
        this.bucketInfo = emptyBucketInfo;
        this.format = formatter;
        this.targetBuckets = targetBuckets;
        this.bucketInnerInterval = bucketInnerInterval;
    }

    public InternalAutoDateHistogram(StreamInput in) throws IOException {
        super(in);
        this.bucketInfo = new BucketInfo(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.buckets = in.readList(stream -> new Bucket(stream, this.format));
        this.targetBuckets = in.readVInt();
        this.bucketInnerInterval = 1L;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.bucketInfo.writeTo(out);
        out.writeNamedWriteable(this.format);
        out.writeList(this.buckets);
        out.writeVInt(this.targetBuckets);
    }

    public DateHistogramInterval getInterval() {
        AutoDateHistogramAggregationBuilder.RoundingInfo roundingInfo = this.bucketInfo.roundingInfos[this.bucketInfo.roundingIdx];
        String unitAbbreviation = roundingInfo.unitAbbreviation;
        return new DateHistogramInterval(Long.toString(this.bucketInnerInterval) + unitAbbreviation);
    }

    @Override
    public String getWriteableName() {
        return "auto_date_histogram";
    }

    @Override
    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    DocValueFormat getFormatter() {
        return this.format;
    }

    public int getTargetBuckets() {
        return this.targetBuckets;
    }

    public BucketInfo getBucketInfo() {
        return this.bucketInfo;
    }

    @Override
    public InternalAutoDateHistogram create(List<Bucket> buckets) {
        return new InternalAutoDateHistogram(this.name, buckets, this.targetBuckets, this.bucketInfo, this.format, this.metadata, this.bucketInnerInterval);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.key, prototype.docCount, prototype.format, aggregations);
    }

    private BucketReduceResult reduceBuckets(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        int reduceRoundingIdx = 0;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (InternalAggregation aggregation : aggregations) {
            InternalAutoDateHistogram agg = (InternalAutoDateHistogram)aggregation;
            reduceRoundingIdx = Math.max(agg.bucketInfo.roundingIdx, reduceRoundingIdx);
            if (agg.buckets.isEmpty()) continue;
            min = Math.min(min, agg.buckets.get((int)0).key);
            max = Math.max(max, agg.buckets.get((int)(agg.buckets.size() - 1)).key);
        }
        Rounding.Prepared reduceRounding = this.prepare(reduceRoundingIdx, min, max);
        PriorityQueue<IteratorAndCurrent<Bucket>> pq = new PriorityQueue<IteratorAndCurrent<Bucket>>(aggregations.size()){

            protected boolean lessThan(IteratorAndCurrent<Bucket> a, IteratorAndCurrent<Bucket> b) {
                return a.current().key < b.current().key;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            InternalAutoDateHistogram histogram = (InternalAutoDateHistogram)aggregation;
            if (histogram.buckets.isEmpty()) continue;
            pq.add(new IteratorAndCurrent<Bucket>(histogram.buckets.iterator()));
        }
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>();
        if (pq.size() > 0) {
            ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
            long key = reduceRounding.round(((Bucket)((IteratorAndCurrent)pq.top()).current()).key);
            do {
                IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
                if (reduceRounding.round(((Bucket)top.current()).key) != key) {
                    InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                    reducedBuckets.add((Bucket)reduced);
                    currentBuckets.clear();
                    key = reduceRounding.round(((Bucket)top.current()).key);
                }
                currentBuckets.add((Bucket)top.current());
                if (top.hasNext()) {
                    top.next();
                    assert (((Bucket)top.current()).key > key) : "shards must return data sorted by key";
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty()) {
                InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                reducedBuckets.add((Bucket)reduced);
            }
        }
        return this.mergeBucketsIfNeeded(new BucketReduceResult(reducedBuckets, reduceRoundingIdx, 1L, reduceRounding, min, max), reduceContext);
    }

    private BucketReduceResult mergeBucketsIfNeeded(BucketReduceResult firstPassResult, InternalAggregation.ReduceContext reduceContext) {
        int idx = firstPassResult.roundingIdx;
        AutoDateHistogramAggregationBuilder.RoundingInfo info = this.bucketInfo.roundingInfos[idx];
        List<Bucket> buckets = firstPassResult.buckets;
        Rounding.Prepared prepared = firstPassResult.preparedRounding;
        while (buckets.size() > this.targetBuckets * info.getMaximumInnerInterval() && idx < this.bucketInfo.roundingInfos.length - 1) {
            info = this.bucketInfo.roundingInfos[++idx];
            prepared = this.prepare(idx, firstPassResult.min, firstPassResult.max);
            buckets = this.mergeBuckets(buckets, prepared, reduceContext);
        }
        return new BucketReduceResult(buckets, idx, 1L, prepared, firstPassResult.min, firstPassResult.max);
    }

    private Rounding.Prepared prepare(int idx, long min, long max) {
        Rounding rounding = this.bucketInfo.roundingInfos[idx].rounding;
        return min <= max ? rounding.prepare(min, max) : rounding.prepareForUnknown();
    }

    private List<Bucket> mergeBuckets(List<Bucket> reducedBuckets, Rounding.Prepared reduceRounding, InternalAggregation.ReduceContext reduceContext) {
        ArrayList<Bucket> mergedBuckets = new ArrayList<Bucket>();
        ArrayList<Bucket> sameKeyedBuckets = new ArrayList<Bucket>();
        double key = Double.NaN;
        for (Bucket bucket : reducedBuckets) {
            long roundedBucketKey = reduceRounding.round(bucket.key);
            if (Double.isNaN(key)) {
                key = roundedBucketKey;
                sameKeyedBuckets.add(this.createBucket(key, bucket.docCount, bucket.aggregations));
                continue;
            }
            if ((double)roundedBucketKey == key) {
                sameKeyedBuckets.add(this.createBucket(key, bucket.docCount, bucket.aggregations));
                continue;
            }
            mergedBuckets.add((Bucket)this.reduceBucket(sameKeyedBuckets, reduceContext));
            sameKeyedBuckets.clear();
            key = roundedBucketKey;
            sameKeyedBuckets.add(this.createBucket(key, bucket.docCount, bucket.aggregations));
        }
        if (!sameKeyedBuckets.isEmpty()) {
            mergedBuckets.add((Bucket)this.reduceBucket(sameKeyedBuckets, reduceContext));
        }
        reducedBuckets = mergedBuckets;
        return reducedBuckets;
    }

    @Override
    protected Bucket reduceBucket(List<Bucket> buckets, InternalAggregation.ReduceContext context) {
        assert (buckets.size() > 0);
        ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
        long docCount = 0L;
        for (Bucket bucket : buckets) {
            docCount += bucket.docCount;
            aggregations.add((InternalAggregations)bucket.getAggregations());
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregations, context);
        return new Bucket(buckets.get((int)0).key, docCount, this.format, aggs);
    }

    private BucketReduceResult addEmptyBuckets(BucketReduceResult current, InternalAggregation.ReduceContext reduceContext) {
        List<Bucket> list = current.buckets;
        if (list.isEmpty()) {
            return current;
        }
        int roundingIdx = InternalAutoDateHistogram.getAppropriateRounding(list.get((int)0).key, list.get((int)(list.size() - 1)).key, current.roundingIdx, this.bucketInfo.roundingInfos, this.targetBuckets);
        Rounding.Prepared rounding = current.roundingIdx == roundingIdx ? current.preparedRounding : this.prepare(roundingIdx, current.min, current.max);
        list = this.mergeBuckets(list, rounding, reduceContext);
        Bucket lastBucket = null;
        ListIterator<Bucket> iter = list.listIterator();
        InternalAggregations reducedEmptySubAggs = InternalAggregations.reduce(org.elasticsearch.common.collect.List.of((Object)this.bucketInfo.emptySubAggregations), reduceContext);
        while (iter.hasNext()) {
            Bucket nextBucket = list.get(iter.nextIndex());
            if (lastBucket != null) {
                long key = rounding.nextRoundingValue(lastBucket.key);
                while (key < nextBucket.key) {
                    iter.add(new Bucket(key, 0L, this.format, reducedEmptySubAggs));
                    key = rounding.nextRoundingValue(key);
                }
                assert (key == nextBucket.key) : "key: " + key + ", nextBucket.key: " + nextBucket.key;
            }
            lastBucket = iter.next();
        }
        return new BucketReduceResult(list, roundingIdx, 1L, rounding, current.min, current.max);
    }

    static int getAppropriateRounding(long minKey, long maxKey, int roundingIdx, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundings, int targetBuckets) {
        if (roundingIdx == roundings.length - 1) {
            return roundingIdx;
        }
        int currentRoundingIdx = roundingIdx;
        for (int i = currentRoundingIdx + 1; i < roundings.length; ++i) {
            long dataDuration = maxKey - minKey;
            long roughEstimateRequiredBuckets = dataDuration / roundings[i].getRoughEstimateDurationMillis();
            if (roughEstimateRequiredBuckets < (long)(targetBuckets * roundings[i].getMaximumInnerInterval())) {
                currentRoundingIdx = i - 1;
                break;
            }
            if (i != roundingIdx - 1) continue;
            currentRoundingIdx = i;
            break;
        }
        int requiredBuckets = 0;
        do {
            Rounding currentRounding = roundings[currentRoundingIdx].rounding;
            long currentKey = minKey;
            requiredBuckets = 0;
            while (currentKey < maxKey) {
                ++requiredBuckets;
                currentKey = currentRounding.nextRoundingValue(currentKey);
            }
        } while (requiredBuckets > targetBuckets * roundings[++currentRoundingIdx - 1].getMaximumInnerInterval() && currentRoundingIdx < roundings.length);
        return currentRoundingIdx - 1;
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        BucketReduceResult reducedBucketsResult = this.reduceBuckets(aggregations, reduceContext);
        if (reduceContext.isFinalReduce()) {
            reducedBucketsResult = this.addEmptyBuckets(reducedBucketsResult, reduceContext);
            reducedBucketsResult = this.mergeBucketsIfNeeded(reducedBucketsResult, reduceContext);
            reducedBucketsResult = this.maybeMergeConsecutiveBuckets(reducedBucketsResult, reduceContext);
        }
        reduceContext.consumeBucketsAndMaybeBreak(reducedBucketsResult.buckets.size());
        BucketInfo bucketInfo = new BucketInfo(this.bucketInfo.roundingInfos, reducedBucketsResult.roundingIdx, this.bucketInfo.emptySubAggregations);
        return new InternalAutoDateHistogram(this.getName(), reducedBucketsResult.buckets, this.targetBuckets, bucketInfo, this.format, this.getMetadata(), reducedBucketsResult.innerInterval);
    }

    private BucketReduceResult maybeMergeConsecutiveBuckets(BucketReduceResult current, InternalAggregation.ReduceContext reduceContext) {
        List<Bucket> buckets = current.buckets;
        AutoDateHistogramAggregationBuilder.RoundingInfo roundingInfo = this.bucketInfo.roundingInfos[current.roundingIdx];
        if (buckets.size() > this.targetBuckets) {
            for (int interval : roundingInfo.innerIntervals) {
                int resultingBuckets = buckets.size() / interval;
                if (buckets.size() % interval != 0) {
                    ++resultingBuckets;
                }
                if (resultingBuckets > this.targetBuckets) continue;
                return this.mergeConsecutiveBuckets(current, interval, reduceContext);
            }
        }
        return current;
    }

    private BucketReduceResult mergeConsecutiveBuckets(BucketReduceResult current, int mergeInterval, InternalAggregation.ReduceContext reduceContext) {
        ArrayList<Bucket> mergedBuckets = new ArrayList<Bucket>();
        ArrayList<Bucket> sameKeyedBuckets = new ArrayList<Bucket>();
        double key = current.preparedRounding.round(current.buckets.get((int)0).key);
        for (int i = 0; i < current.buckets.size(); ++i) {
            Bucket bucket = current.buckets.get(i);
            if (i % mergeInterval == 0 && !sameKeyedBuckets.isEmpty()) {
                mergedBuckets.add((Bucket)this.reduceBucket(sameKeyedBuckets, reduceContext));
                sameKeyedBuckets.clear();
                key = current.preparedRounding.round(bucket.key);
            }
            sameKeyedBuckets.add(new Bucket(Math.round(key), bucket.docCount, this.format, bucket.aggregations));
        }
        if (!sameKeyedBuckets.isEmpty()) {
            mergedBuckets.add((Bucket)this.reduceBucket(sameKeyedBuckets, reduceContext));
        }
        return new BucketReduceResult(mergedBuckets, current.roundingIdx, mergeInterval, current.preparedRounding, current.min, current.max);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        builder.field("interval", this.getInterval().toString());
        return builder;
    }

    @Override
    public Number getKey(MultiBucketsAggregation.Bucket bucket) {
        return ((Bucket)bucket).key;
    }

    @Override
    public Number nextKey(Number key) {
        return this.bucketInfo.roundingInfos[this.bucketInfo.roundingIdx].rounding.nextRoundingValue(key.longValue());
    }

    @Override
    public InternalAggregation createAggregation(List<MultiBucketsAggregation.Bucket> buckets) {
        List<Bucket> buckets2 = new ArrayList(buckets.size());
        for (MultiBucketsAggregation.Bucket b : buckets) {
            buckets2.add((Bucket)b);
        }
        buckets2 = Collections.unmodifiableList(buckets2);
        return new InternalAutoDateHistogram(this.name, buckets2, this.targetBuckets, this.bucketInfo, this.format, this.getMetadata(), this.bucketInnerInterval);
    }

    @Override
    public Bucket createBucket(Number key, long docCount, InternalAggregations aggregations) {
        return new Bucket(key.longValue(), docCount, this.format, aggregations);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalAutoDateHistogram that = (InternalAutoDateHistogram)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.format, that.format) && Objects.equals(this.bucketInfo, that.bucketInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.format, this.bucketInfo);
    }

    static class BucketInfo {
        final AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;
        final int roundingIdx;
        final InternalAggregations emptySubAggregations;

        BucketInfo(AutoDateHistogramAggregationBuilder.RoundingInfo[] roundings, int roundingIdx, InternalAggregations subAggregations) {
            this.roundingInfos = roundings;
            this.roundingIdx = roundingIdx;
            this.emptySubAggregations = subAggregations;
        }

        BucketInfo(StreamInput in) throws IOException {
            int size = in.readVInt();
            this.roundingInfos = new AutoDateHistogramAggregationBuilder.RoundingInfo[size];
            for (int i = 0; i < size; ++i) {
                this.roundingInfos[i] = new AutoDateHistogramAggregationBuilder.RoundingInfo(in);
            }
            this.roundingIdx = in.readVInt();
            this.emptySubAggregations = InternalAggregations.readFrom(in);
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.roundingInfos.length);
            for (AutoDateHistogramAggregationBuilder.RoundingInfo roundingInfo : this.roundingInfos) {
                roundingInfo.writeTo(out);
            }
            out.writeVInt(this.roundingIdx);
            this.emptySubAggregations.writeTo(out);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BucketInfo that = (BucketInfo)obj;
            return Objects.deepEquals(this.roundingInfos, that.roundingInfos) && Objects.equals(this.roundingIdx, that.roundingIdx) && Objects.equals(this.emptySubAggregations, that.emptySubAggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), Arrays.hashCode(this.roundingInfos), this.roundingIdx, this.emptySubAggregations);
        }
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Histogram.Bucket,
    KeyComparable<Bucket> {
        final long key;
        final long docCount;
        final InternalAggregations aggregations;
        protected final transient DocValueFormat format;

        public Bucket(long key, long docCount, DocValueFormat format, InternalAggregations aggregations) {
            this.format = format;
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public Bucket(StreamInput in, DocValueFormat format) throws IOException {
            this.format = format;
            this.key = in.readLong();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom(in);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != Bucket.class) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return this.key == that.key && this.docCount == that.docCount && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.docCount, this.aggregations);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.key).toString();
        }

        @Override
        public Object getKey() {
            return Instant.ofEpochMilli(this.key).atZone(ZoneOffset.UTC);
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String keyAsString = this.format.format(this.key).toString();
            builder.startObject();
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), keyAsString);
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        @Override
        public int compareKey(Bucket other) {
            return Long.compare(this.key, other.key);
        }

        public DocValueFormat getFormatter() {
            return this.format;
        }
    }

    private static class BucketReduceResult {
        final List<Bucket> buckets;
        final int roundingIdx;
        final long innerInterval;
        final Rounding.Prepared preparedRounding;
        final long min;
        final long max;

        BucketReduceResult(List<Bucket> buckets, int roundingIdx, long innerInterval, Rounding.Prepared preparedRounding, long min, long max) {
            this.buckets = buckets;
            this.roundingIdx = roundingIdx;
            this.innerInterval = innerInterval;
            this.preparedRounding = preparedRounding;
            this.min = min;
            this.max = max;
        }
    }
}

