/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.sql.SqlChildrenOperations;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.List;
import java.util.Objects;
import rx.Completable;
import rx.Observable;

@LangDefinition
public abstract class SqlChildrenOperationsImpl<FluentModelT>
implements SqlChildrenOperations<FluentModelT>,
SqlChildrenOperations.SqlChildrenActionsDefinition<FluentModelT> {
    protected SqlServerManager sqlServerManager;
    protected SqlServer sqlServer;

    SqlChildrenOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServer = parent;
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public FluentModelT get(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return (FluentModelT)this.getBySqlServer(this.sqlServer, name);
    }

    @Override
    public Observable<FluentModelT> getAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer, name);
    }

    @Override
    public FluentModelT getById(String id) {
        Objects.requireNonNull(id);
        return (FluentModelT)this.getBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Observable<FluentModelT> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public void delete(String name) {
        if (this.sqlServer != null) {
            this.deleteBySqlServer(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
        }
    }

    @Override
    public Completable deleteAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.deleteBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
    }

    @Override
    public void deleteById(String id) {
        Objects.requireNonNull(id);
        this.deleteBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.deleteBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public List<FluentModelT> list() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServer(this.sqlServer);
    }

    @Override
    public Observable<FluentModelT> listAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServerAsync(this.sqlServer);
    }
}

