/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VpnConnectionInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VpnConnectionsInner {
    private VpnConnectionsService service;
    private NetworkManagementClientImpl client;

    public VpnConnectionsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VpnConnectionsService)retrofit.create(VpnConnectionsService.class);
        this.client = client;
    }

    public VpnConnectionInner get(String resourceGroupName, String gatewayName, String connectionName) {
        return (VpnConnectionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnConnectionInner> getAsync(String resourceGroupName, String gatewayName, String connectionName, ServiceCallback<VpnConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName), serviceCallback);
    }

    public Observable<VpnConnectionInner> getAsync(String resourceGroupName, String gatewayName, String connectionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName).map((Func1)new Func1<ServiceResponse<VpnConnectionInner>, VpnConnectionInner>(){

            public VpnConnectionInner call(ServiceResponse<VpnConnectionInner> response) {
                return (VpnConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnConnectionInner>> getWithServiceResponseAsync(String resourceGroupName, String gatewayName, String connectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, gatewayName, connectionName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnConnectionInner>>>(){

            public Observable<ServiceResponse<VpnConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnConnectionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnConnectionInner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnConnectionInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VpnConnectionInner createOrUpdate(String resourceGroupName, String gatewayName, String connectionName, VpnConnectionInner vpnConnectionParameters) {
        return (VpnConnectionInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName, vpnConnectionParameters).toBlocking().last()).body());
    }

    public ServiceFuture<VpnConnectionInner> createOrUpdateAsync(String resourceGroupName, String gatewayName, String connectionName, VpnConnectionInner vpnConnectionParameters, ServiceCallback<VpnConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName, vpnConnectionParameters), serviceCallback);
    }

    public Observable<VpnConnectionInner> createOrUpdateAsync(String resourceGroupName, String gatewayName, String connectionName, VpnConnectionInner vpnConnectionParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName, vpnConnectionParameters).map((Func1)new Func1<ServiceResponse<VpnConnectionInner>, VpnConnectionInner>(){

            public VpnConnectionInner call(ServiceResponse<VpnConnectionInner> response) {
                return (VpnConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnConnectionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String gatewayName, String connectionName, VpnConnectionInner vpnConnectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        if (vpnConnectionParameters == null) {
            throw new IllegalArgumentException("Parameter vpnConnectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)vpnConnectionParameters));
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, gatewayName, connectionName, "2018-06-01", vpnConnectionParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VpnConnectionInner>(){}.getType());
    }

    public VpnConnectionInner beginCreateOrUpdate(String resourceGroupName, String gatewayName, String connectionName, VpnConnectionInner vpnConnectionParameters) {
        return (VpnConnectionInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName, vpnConnectionParameters).toBlocking().single()).body());
    }

    public ServiceFuture<VpnConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String gatewayName, String connectionName, VpnConnectionInner vpnConnectionParameters, ServiceCallback<VpnConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName, vpnConnectionParameters), serviceCallback);
    }

    public Observable<VpnConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String gatewayName, String connectionName, VpnConnectionInner vpnConnectionParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName, vpnConnectionParameters).map((Func1)new Func1<ServiceResponse<VpnConnectionInner>, VpnConnectionInner>(){

            public VpnConnectionInner call(ServiceResponse<VpnConnectionInner> response) {
                return (VpnConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnConnectionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String gatewayName, String connectionName, VpnConnectionInner vpnConnectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        if (vpnConnectionParameters == null) {
            throw new IllegalArgumentException("Parameter vpnConnectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)vpnConnectionParameters));
        String apiVersion = "2018-06-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, gatewayName, connectionName, "2018-06-01", vpnConnectionParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnConnectionInner>>>(){

            public Observable<ServiceResponse<VpnConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnConnectionsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnConnectionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnConnectionInner>(){}.getType()).register(201, new TypeToken<VpnConnectionInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public void delete(String resourceGroupName, String gatewayName, String connectionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String gatewayName, String connectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String gatewayName, String connectionName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String gatewayName, String connectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, gatewayName, connectionName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String gatewayName, String connectionName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String gatewayName, String connectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String gatewayName, String connectionName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String gatewayName, String connectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, gatewayName, connectionName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnConnectionsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VpnConnectionInner> listByVpnGateway(String resourceGroupName, String gatewayName) {
        ServiceResponse response = (ServiceResponse)this.listByVpnGatewaySinglePageAsync(resourceGroupName, gatewayName).toBlocking().single();
        return new PagedList<VpnConnectionInner>((Page)response.body()){

            public Page<VpnConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnConnectionsInner.this.listByVpnGatewayNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnConnectionInner>> listByVpnGatewayAsync(String resourceGroupName, String gatewayName, ListOperationCallback<VpnConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVpnGatewaySinglePageAsync(resourceGroupName, gatewayName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnConnectionInner>>> call(String nextPageLink) {
                return VpnConnectionsInner.this.listByVpnGatewayNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnConnectionInner>> listByVpnGatewayAsync(String resourceGroupName, String gatewayName) {
        return this.listByVpnGatewayWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<Page<VpnConnectionInner>>, Page<VpnConnectionInner>>(){

            public Page<VpnConnectionInner> call(ServiceResponse<Page<VpnConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnConnectionInner>>> listByVpnGatewayWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        return this.listByVpnGatewaySinglePageAsync(resourceGroupName, gatewayName).concatMap((Func1)new Func1<ServiceResponse<Page<VpnConnectionInner>>, Observable<ServiceResponse<Page<VpnConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnConnectionInner>>> call(ServiceResponse<Page<VpnConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnConnectionsInner.this.listByVpnGatewayNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnConnectionInner>>> listByVpnGatewaySinglePageAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.listByVpnGateway(this.client.subscriptionId(), resourceGroupName, gatewayName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnConnectionsInner.this.listByVpnGatewayDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnConnectionInner>> listByVpnGatewayDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnConnectionInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VpnConnectionInner> listByVpnGatewayNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByVpnGatewayNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnConnectionInner>((Page)response.body()){

            public Page<VpnConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnConnectionsInner.this.listByVpnGatewayNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnConnectionInner>> listByVpnGatewayNextAsync(String nextPageLink, ServiceFuture<List<VpnConnectionInner>> serviceFuture, ListOperationCallback<VpnConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVpnGatewayNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnConnectionInner>>> call(String nextPageLink) {
                return VpnConnectionsInner.this.listByVpnGatewayNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnConnectionInner>> listByVpnGatewayNextAsync(String nextPageLink) {
        return this.listByVpnGatewayNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VpnConnectionInner>>, Page<VpnConnectionInner>>(){

            public Page<VpnConnectionInner> call(ServiceResponse<Page<VpnConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnConnectionInner>>> listByVpnGatewayNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByVpnGatewayNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VpnConnectionInner>>, Observable<ServiceResponse<Page<VpnConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnConnectionInner>>> call(ServiceResponse<Page<VpnConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnConnectionsInner.this.listByVpnGatewayNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnConnectionInner>>> listByVpnGatewayNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByVpnGatewayNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnConnectionsInner.this.listByVpnGatewayNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnConnectionInner>> listByVpnGatewayNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnConnectionInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface VpnConnectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnConnections get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections/{connectionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Path(value="connectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnConnections createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections/{connectionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Path(value="connectionName") String var4, @Query(value="api-version") String var5, @Body VpnConnectionInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnConnections beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections/{connectionName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Path(value="connectionName") String var4, @Query(value="api-version") String var5, @Body VpnConnectionInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnConnections delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections/{connectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Path(value="connectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnConnections beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections/{connectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Path(value="connectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnConnections listByVpnGateway"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections")
        public Observable<Response<ResponseBody>> listByVpnGateway(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnConnections listByVpnGatewayNext"})
        @GET
        public Observable<Response<ResponseBody>> listByVpnGatewayNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

