/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ratis.examples.arithmetic.AssignmentMessage;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MD5FileUtil;

public class ArithmeticStateMachine
extends BaseStateMachine {
    private final Map<String, Double> variables = new ConcurrentHashMap<String, Double>();
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    private AutoCloseableLock readLock() {
        return AutoCloseableLock.acquire(this.lock.readLock());
    }

    private AutoCloseableLock writeLock() {
        return AutoCloseableLock.acquire(this.lock.writeLock());
    }

    void reset() {
        this.variables.clear();
        this.setLastAppliedTermIndex(null);
    }

    @Override
    public void initialize(RaftServer server, RaftGroupId groupId, RaftStorage raftStorage) throws IOException {
        super.initialize(server, groupId, raftStorage);
        this.storage.init(raftStorage);
        this.loadSnapshot(this.storage.getLatestSnapshot());
    }

    @Override
    public void reinitialize() throws IOException {
        this.close();
        this.loadSnapshot(this.storage.getLatestSnapshot());
    }

    @Override
    public long takeSnapshot() {
        TermIndex last;
        HashMap<String, Double> copy;
        try (AutoCloseableLock readLock = this.readLock();){
            copy = new HashMap<String, Double>(this.variables);
            last = this.getLastAppliedTermIndex();
        }
        File snapshotFile = this.storage.getSnapshotFile(last.getTerm(), last.getIndex());
        LOG.info("Taking a snapshot to file {}", (Object)snapshotFile);
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(FileUtils.newOutputStream(snapshotFile, new OpenOption[0])));){
            out.writeObject(copy);
        }
        catch (IOException ioe) {
            LOG.warn("Failed to write snapshot file \"" + snapshotFile + "\", last applied index=" + last);
        }
        MD5Hash md5 = MD5FileUtil.computeAndSaveMd5ForFile(snapshotFile);
        FileInfo info = new FileInfo(snapshotFile.toPath(), md5);
        this.storage.updateLatestSnapshot(new SingleFileSnapshotInfo(info, last));
        return last.getIndex();
    }

    public long loadSnapshot(SingleFileSnapshotInfo snapshot) throws IOException {
        if (snapshot == null) {
            LOG.warn("The snapshot info is null.");
            return -1L;
        }
        File snapshotFile = snapshot.getFile().getPath().toFile();
        if (!snapshotFile.exists()) {
            LOG.warn("The snapshot file {} does not exist for snapshot {}", (Object)snapshotFile, (Object)snapshot);
            return -1L;
        }
        MD5Hash md5 = snapshot.getFile().getFileDigest();
        if (md5 != null) {
            MD5FileUtil.verifySavedMD5(snapshotFile, md5);
        }
        TermIndex last = SimpleStateMachineStorage.getTermIndexFromSnapshotFile(snapshotFile);
        try (AutoCloseableLock writeLock = this.writeLock();
             ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(FileUtils.newInputStream(snapshotFile, new OpenOption[0])));){
            this.reset();
            this.setLastAppliedTermIndex(last);
            this.variables.putAll((Map)JavaUtils.cast(in.readObject()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load " + snapshot, e);
        }
        return last.getIndex();
    }

    @Override
    public StateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    @Override
    public CompletableFuture<Message> query(Message request) {
        Double result;
        Expression q = Expression.Utils.bytes2Expression(request.getContent().toByteArray(), 0);
        try (AutoCloseableLock readLock = this.readLock();){
            result = q.evaluate(this.variables);
        }
        Expression r = Expression.Utils.double2Expression(result);
        LOG.debug("QUERY: {} = {}", (Object)q, (Object)r);
        return CompletableFuture.completedFuture(Expression.Utils.toMessage(r));
    }

    @Override
    public void close() {
        this.reset();
    }

    @Override
    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        Double result;
        RaftProtos.LogEntryProto entry = trx.getLogEntry();
        AssignmentMessage assignment = new AssignmentMessage(entry.getStateMachineLogEntry().getLogData());
        long index = entry.getIndex();
        try (AutoCloseableLock writeLock = this.writeLock();){
            result = assignment.evaluate(this.variables);
            this.updateLastAppliedTermIndex(entry.getTerm(), index);
        }
        Expression r = Expression.Utils.double2Expression(result);
        CompletableFuture<Message> f = CompletableFuture.completedFuture(Expression.Utils.toMessage(r));
        RaftProtos.RaftPeerRole role = trx.getServerRole();
        if (role == RaftProtos.RaftPeerRole.LEADER) {
            LOG.info("{}:{}-{}: {} = {}", role, this.getId(), index, assignment, r);
        } else {
            LOG.debug("{}:{}-{}: {} = {}", role, this.getId(), index, assignment, r);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}-{}: variables={}", this.getId(), index, this.variables);
        }
        return f;
    }
}

