/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.logging;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.logging.InnerLoggerFactory;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.Slf4jLoggerFactory;

public abstract class InternalLoggerFactory {
    public static final String LOGGER_SLF4J = "slf4j";
    public static final String LOGGER_INNER = "inner";
    public static final String DEFAULT_LOGGER = "slf4j";
    public static final String BROKER_CONTAINER_NAME = "BrokerContainer";
    public static final String CONSUMER_STATS_LOGGER_NAME = "RocketmqConsumerStats";
    public static final String COMMERCIAL_LOGGER_NAME = "RocketmqCommercial";
    public static final String ACCOUNT_LOGGER_NAME = "RocketmqAccount";
    private static String loggerType = null;
    public static final ThreadLocal<String> BROKER_IDENTITY = new ThreadLocal();
    private static ConcurrentHashMap<String, InternalLoggerFactory> loggerFactoryCache = new ConcurrentHashMap();

    public static InternalLogger getLogger(Class clazz) {
        return InternalLoggerFactory.getLogger(clazz.getName());
    }

    public static InternalLogger getLogger(String name) {
        return InternalLoggerFactory.getLoggerFactory().getLoggerInstance(name);
    }

    private static InternalLoggerFactory getLoggerFactory() {
        InternalLoggerFactory internalLoggerFactory = null;
        if (loggerType != null) {
            internalLoggerFactory = loggerFactoryCache.get(loggerType);
        }
        if (internalLoggerFactory == null) {
            internalLoggerFactory = loggerFactoryCache.get("slf4j");
        }
        if (internalLoggerFactory == null) {
            internalLoggerFactory = loggerFactoryCache.get(LOGGER_INNER);
        }
        if (internalLoggerFactory == null) {
            throw new RuntimeException("[RocketMQ] Logger init failed, please check logger");
        }
        return internalLoggerFactory;
    }

    public static void setCurrentLoggerType(String type) {
        loggerType = type;
    }

    protected void doRegister() {
        String loggerType = this.getLoggerType();
        if (loggerFactoryCache.get(loggerType) != null) {
            return;
        }
        loggerFactoryCache.put(loggerType, this);
    }

    protected abstract void shutdown();

    protected abstract InternalLogger getLoggerInstance(String var1);

    protected abstract String getLoggerType();

    static {
        try {
            new Slf4jLoggerFactory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            new InnerLoggerFactory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

