/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore;

import com.google.common.base.Stopwatch;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.View;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.QueryMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.plugin.AbstractPluginMessageStore;
import org.apache.rocketmq.store.plugin.MessageStorePluginContext;
import org.apache.rocketmq.tieredstore.TieredDispatcher;
import org.apache.rocketmq.tieredstore.TieredMessageFetcher;
import org.apache.rocketmq.tieredstore.common.BoundaryType;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.container.TieredContainerManager;
import org.apache.rocketmq.tieredstore.container.TieredMessageQueueContainer;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.metadata.TopicMetadata;
import org.apache.rocketmq.tieredstore.metrics.TieredStoreMetricsManager;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class TieredMessageStore
extends AbstractPluginMessageStore {
    protected static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    protected final TieredMessageFetcher fetcher;
    protected final TieredDispatcher dispatcher;
    protected final String brokerName;
    protected final TieredMessageStoreConfig storeConfig = new TieredMessageStoreConfig();
    protected final TieredContainerManager containerManager;
    protected final TieredMetadataStore metadataStore;

    public TieredMessageStore(MessageStorePluginContext context, MessageStore next) {
        super(context, next);
        context.registerConfiguration((Object)this.storeConfig);
        this.brokerName = this.storeConfig.getBrokerName();
        TieredStoreUtil.addSystemTopic(this.storeConfig.getBrokerClusterName());
        TieredStoreUtil.addSystemTopic(this.brokerName);
        this.metadataStore = TieredStoreUtil.getMetadataStore(this.storeConfig);
        this.fetcher = new TieredMessageFetcher(this.storeConfig);
        this.dispatcher = new TieredDispatcher(next, this.storeConfig);
        this.containerManager = TieredContainerManager.getInstance(this.storeConfig);
        next.addDispatcher((CommitLogDispatcher)this.dispatcher);
    }

    public boolean load() {
        boolean result;
        boolean loadContainer = this.containerManager.load();
        boolean loadNextStore = this.next.load();
        boolean bl = result = loadContainer && loadNextStore;
        if (result) {
            this.dispatcher.start();
        }
        return result;
    }

    public TieredMessageStoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public boolean viaTieredStorage(String topic, int queueId, long offset) {
        return this.viaTieredStorage(topic, queueId, offset, 1);
    }

    public boolean viaTieredStorage(String topic, int queueId, long offset, int batchSize) {
        TieredMessageStoreConfig.TieredStorageLevel deepStorageLevel = this.storeConfig.getTieredStorageLevel();
        if (!deepStorageLevel.isEnable()) {
            return false;
        }
        TieredMessageQueueContainer container = this.containerManager.getMQContainer(new MessageQueue(topic, this.brokerName, queueId));
        if (container == null) {
            return false;
        }
        if (offset >= container.getConsumeQueueCommitOffset()) {
            return false;
        }
        if (deepStorageLevel.check(TieredMessageStoreConfig.TieredStorageLevel.NOT_IN_DISK) && !this.next.checkInStoreByConsumeOffset(topic, queueId, offset)) {
            return true;
        }
        if (deepStorageLevel.check(TieredMessageStoreConfig.TieredStorageLevel.NOT_IN_MEM) && !this.next.checkInMemByConsumeOffset(topic, queueId, offset, batchSize)) {
            return true;
        }
        return deepStorageLevel.check(TieredMessageStoreConfig.TieredStorageLevel.FORCE);
    }

    public GetMessageResult getMessage(String group, String topic, int queueId, long offset, int maxMsgNums, MessageFilter messageFilter) {
        return this.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter).join();
    }

    public CompletableFuture<GetMessageResult> getMessageAsync(String group, String topic, int queueId, long offset, int maxMsgNums, MessageFilter messageFilter) {
        if (this.viaTieredStorage(topic, queueId, offset, maxMsgNums)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            return ((CompletableFuture)this.fetcher.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter).thenApply(result -> {
                long maxOffsetInQueue;
                long minOffsetInQueue;
                Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_message").put("topic", topic).put("group", group).build();
                TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
                if ((result.getStatus() == GetMessageStatus.OFFSET_FOUND_NULL || result.getStatus() == GetMessageStatus.OFFSET_OVERFLOW_ONE || result.getStatus() == GetMessageStatus.OFFSET_OVERFLOW_BADLY) && this.next.checkInDiskByConsumeOffset(topic, queueId, offset)) {
                    logger.debug("TieredMessageStore#getMessageAsync: not found message, try to get message from next store: topic: {}, queue: {}, queue offset: {}, tiered store result: {}, min offset: {}, max offset: {}", new Object[]{topic, queueId, offset, result.getStatus(), result.getMinOffset(), result.getMaxOffset()});
                    TieredStoreMetricsManager.fallbackTotal.add(1L, latencyAttributes);
                    return this.next.getMessage(group, topic, queueId, offset, maxMsgNums, messageFilter);
                }
                if (result.getStatus() != GetMessageStatus.FOUND && result.getStatus() != GetMessageStatus.OFFSET_OVERFLOW_ONE && result.getStatus() != GetMessageStatus.OFFSET_OVERFLOW_BADLY) {
                    logger.warn("TieredMessageStore#getMessageAsync: not found message, and message is not in next store: topic: {}, queue: {}, queue offset: {}, result: {}, min offset: {}, max offset: {}", new Object[]{topic, queueId, offset, result.getStatus(), result.getMinOffset(), result.getMaxOffset()});
                }
                if (result.getStatus() == GetMessageStatus.FOUND) {
                    Attributes messagesOutAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", topic).put("group", group).build();
                    TieredStoreMetricsManager.messagesOutTotal.add((long)result.getMessageCount(), messagesOutAttributes);
                }
                if ((minOffsetInQueue = this.next.getMinOffsetInQueue(topic, queueId)) >= 0L && minOffsetInQueue < result.getMinOffset()) {
                    result.setMinOffset(minOffsetInQueue);
                }
                if ((maxOffsetInQueue = this.next.getMaxOffsetInQueue(topic, queueId)) >= 0L && maxOffsetInQueue > result.getMaxOffset()) {
                    result.setMaxOffset(maxOffsetInQueue);
                }
                return result;
            })).exceptionally(e -> {
                logger.error("TieredMessageStore#getMessageAsync: get message from tiered store failed: ", e);
                return this.next.getMessage(group, topic, queueId, offset, maxMsgNums, messageFilter);
            });
        }
        return this.next.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter);
    }

    public long getMinOffsetInQueue(String topic, int queueId) {
        long minOffsetInNextStore = this.next.getMinOffsetInQueue(topic, queueId);
        TieredMessageQueueContainer container = this.containerManager.getMQContainer(new MessageQueue(topic, this.brokerName, queueId));
        if (container == null) {
            return minOffsetInNextStore;
        }
        long minOffsetInTieredStore = container.getConsumeQueueMinOffset();
        if (minOffsetInTieredStore < 0L) {
            return minOffsetInNextStore;
        }
        return Math.min(minOffsetInNextStore, minOffsetInTieredStore);
    }

    public long getEarliestMessageTime(String topic, int queueId) {
        return this.getEarliestMessageTimeAsync(topic, queueId).join();
    }

    public CompletableFuture<Long> getEarliestMessageTimeAsync(String topic, int queueId) {
        long nextEarliestMessageTime = this.next.getEarliestMessageTime(topic, queueId);
        long finalNextEarliestMessageTime = nextEarliestMessageTime > 0L ? nextEarliestMessageTime : Long.MAX_VALUE;
        Stopwatch stopwatch = Stopwatch.createStarted();
        return this.fetcher.getEarliestMessageTimeAsync(topic, queueId).thenApply(time -> {
            Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_earliest_message_time").put("topic", topic).build();
            TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
            if (time < 0L) {
                logger.debug("TieredMessageStore#getEarliestMessageTimeAsync: get earliest message time failed, try to get earliest message time from next store: topic: {}, queue: {}", (Object)topic, (Object)queueId);
                return finalNextEarliestMessageTime != Long.MAX_VALUE ? finalNextEarliestMessageTime : -1L;
            }
            return Math.min(finalNextEarliestMessageTime, time);
        });
    }

    public CompletableFuture<Long> getMessageStoreTimeStampAsync(String topic, int queueId, long consumeQueueOffset) {
        if (this.viaTieredStorage(topic, queueId, consumeQueueOffset)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            return this.fetcher.getMessageStoreTimeStampAsync(topic, queueId, consumeQueueOffset).thenApply(time -> {
                Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_time_by_offset").put("topic", topic).build();
                TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
                if (time == -1L) {
                    logger.debug("TieredMessageStore#getMessageStoreTimeStampAsync: get message time failed, try to get message time from next store: topic: {}, queue: {}, queue offset: {}", new Object[]{topic, queueId, consumeQueueOffset});
                    return this.next.getMessageStoreTimeStamp(topic, queueId, consumeQueueOffset);
                }
                return time;
            });
        }
        return this.next.getMessageStoreTimeStampAsync(topic, queueId, consumeQueueOffset);
    }

    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp) {
        return this.getOffsetInQueueByTime(topic, queueId, timestamp, BoundaryType.LOWER);
    }

    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp, BoundaryType boundaryType) {
        boolean isForce;
        long earliestTimeInNextStore = this.next.getEarliestMessageTime();
        if (earliestTimeInNextStore <= 0L) {
            logger.warn("TieredMessageStore#getOffsetInQueueByTimeAsync: get earliest message time in next store failed: {}", (Object)earliestTimeInNextStore);
            return this.next.getOffsetInQueueByTime(topic, queueId, timestamp);
        }
        boolean bl = isForce = this.storeConfig.getTieredStorageLevel() == TieredMessageStoreConfig.TieredStorageLevel.FORCE;
        if (timestamp < earliestTimeInNextStore || isForce) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            long offsetInTieredStore = this.fetcher.getOffsetInQueueByTime(topic, queueId, timestamp, boundaryType);
            Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_offset_by_time").put("topic", topic).build();
            TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
            if (offsetInTieredStore == -1L && !isForce) {
                return this.next.getOffsetInQueueByTime(topic, queueId, timestamp);
            }
            return offsetInTieredStore;
        }
        return this.next.getOffsetInQueueByTime(topic, queueId, timestamp);
    }

    public QueryMessageResult queryMessage(String topic, String key, int maxNum, long begin, long end) {
        return this.queryMessageAsync(topic, key, maxNum, begin, end).join();
    }

    public CompletableFuture<QueryMessageResult> queryMessageAsync(String topic, String key, int maxNum, long begin, long end) {
        long earliestTimeInNextStore = this.next.getEarliestMessageTime();
        if (earliestTimeInNextStore <= 0L) {
            logger.warn("TieredMessageStore#queryMessageAsync: get earliest message time in next store failed: {}", (Object)earliestTimeInNextStore);
        }
        boolean isForce = this.storeConfig.getTieredStorageLevel() == TieredMessageStoreConfig.TieredStorageLevel.FORCE;
        QueryMessageResult result = end < earliestTimeInNextStore || isForce ? new QueryMessageResult() : this.next.queryMessage(topic, key, maxNum, begin, end);
        int resultSize = result.getMessageBufferList().size();
        if (resultSize < maxNum && begin < earliestTimeInNextStore || isForce) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                return this.fetcher.queryMessageAsync(topic, key, maxNum - resultSize, begin, isForce ? end : earliestTimeInNextStore).thenApply(tieredStoreResult -> {
                    Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "query_message").put("topic", topic).build();
                    TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
                    for (SelectMappedBufferResult msg : tieredStoreResult.getMessageMapedList()) {
                        result.addMessage(msg);
                    }
                    return result;
                });
            }
            catch (Exception e) {
                logger.error("TieredMessageStore#queryMessageAsync: query message in tiered store failed", (Throwable)e);
                return CompletableFuture.completedFuture(result);
            }
        }
        return CompletableFuture.completedFuture(result);
    }

    public List<Pair<InstrumentSelector, View>> getMetricsView() {
        List res = super.getMetricsView();
        res.addAll(TieredStoreMetricsManager.getMetricsView());
        return res;
    }

    public void initMetrics(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        super.initMetrics(meter, attributesBuilderSupplier);
        TieredStoreMetricsManager.init(meter, attributesBuilderSupplier, this.storeConfig, this.fetcher, this.next);
    }

    public void shutdown() {
        this.next.shutdown();
        this.dispatcher.shutdown();
        TieredContainerManager.getInstance(this.storeConfig).shutdown();
        TieredStoreExecutor.shutdown();
    }

    public void destroy() {
        this.next.destroy();
        TieredContainerManager.getInstance(this.storeConfig).destroy();
        try {
            this.metadataStore.destroy();
        }
        catch (Exception e) {
            logger.error("TieredMessageStore#destroy: destroy metadata store failed", (Throwable)e);
        }
    }

    public int cleanUnusedTopic(Set<String> retainTopics) {
        try {
            this.metadataStore.iterateTopic(topicMetadata -> {
                String topic = topicMetadata.getTopic();
                if (retainTopics.contains(topic) || TopicValidator.isSystemTopic((String)topic) || MixAll.isLmq((String)topic)) {
                    return;
                }
                logger.info("TieredMessageStore#cleanUnusedTopic: start deleting topic {}", (Object)topic);
                try {
                    this.destroyContainer((TopicMetadata)topicMetadata);
                }
                catch (Exception e) {
                    logger.error("TieredMessageStore#cleanUnusedTopic: delete topic {} failed", (Object)topic, (Object)e);
                }
            });
        }
        catch (Exception e) {
            logger.error("TieredMessageStore#cleanUnusedTopic: iterate topic metadata failed", (Throwable)e);
        }
        return this.next.cleanUnusedTopic(retainTopics);
    }

    public int deleteTopics(Set<String> deleteTopics) {
        for (String topic : deleteTopics) {
            logger.info("TieredMessageStore#deleteTopics: start deleting topic {}", (Object)topic);
            try {
                TopicMetadata topicMetadata = this.metadataStore.getTopic(topic);
                if (topicMetadata != null) {
                    this.destroyContainer(topicMetadata);
                    continue;
                }
                logger.error("TieredMessageStore#deleteTopics: delete topic {} failed, can not obtain metadata", (Object)topic);
            }
            catch (Exception e) {
                logger.error("TieredMessageStore#deleteTopics: delete topic {} failed", (Object)topic, (Object)e);
            }
        }
        return this.next.deleteTopics(deleteTopics);
    }

    public void destroyContainer(TopicMetadata topicMetadata) {
        String topic = topicMetadata.getTopic();
        this.metadataStore.iterateQueue(topic, queueMetadata -> {
            MessageQueue mq = queueMetadata.getQueue();
            TieredMessageQueueContainer container = this.containerManager.getMQContainer(mq);
            if (container != null) {
                this.containerManager.destroyContainer(mq);
                try {
                    this.metadataStore.deleteQueue(mq);
                    this.metadataStore.deleteFileSegment(mq);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                logger.info("TieredMessageStore#destroyContainer: destroy container success: topic: {}, queueId: {}", (Object)mq.getTopic(), (Object)mq.getQueueId());
            }
        });
        this.metadataStore.deleteTopic(topicMetadata.getTopic());
    }
}

