/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.FilterExpression;
import apache.rocketmq.v2.FilterType;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.Settings;
import apache.rocketmq.v2.Subscription;
import apache.rocketmq.v2.SubscriptionEntry;
import com.google.common.base.MoreObjects;
import com.google.protobuf.util.Durations;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.FilterExpressionType;
import org.apache.rocketmq.client.java.impl.ClientType;
import org.apache.rocketmq.client.java.impl.Settings;
import org.apache.rocketmq.client.java.impl.UserAgent;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSubscriptionSettings
extends Settings {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSubscriptionSettings.class);
    private final org.apache.rocketmq.client.java.message.protocol.Resource group;
    private final Duration longPollingTimeout;
    private final Map<String, FilterExpression> subscriptionExpressions;

    public SimpleSubscriptionSettings(ClientId clientId, Endpoints endpoints, org.apache.rocketmq.client.java.message.protocol.Resource group, Duration requestTimeout, Duration longPollingTimeout, Map<String, FilterExpression> subscriptionExpression) {
        super(clientId, ClientType.SIMPLE_CONSUMER, endpoints, requestTimeout);
        this.group = group;
        this.subscriptionExpressions = subscriptionExpression;
        this.longPollingTimeout = longPollingTimeout;
    }

    @Override
    public apache.rocketmq.v2.Settings toProtobuf() {
        ArrayList<SubscriptionEntry> subscriptionEntries = new ArrayList<SubscriptionEntry>();
        for (Map.Entry<String, FilterExpression> entry : this.subscriptionExpressions.entrySet()) {
            FilterExpression filterExpression = entry.getValue();
            Resource topic = Resource.newBuilder().setName(entry.getKey()).build();
            FilterExpression.Builder expressionBuilder = apache.rocketmq.v2.FilterExpression.newBuilder().setExpression(filterExpression.getExpression());
            FilterExpressionType type = filterExpression.getFilterExpressionType();
            switch (type) {
                case TAG: {
                    expressionBuilder.setType(FilterType.TAG);
                    break;
                }
                case SQL92: {
                    expressionBuilder.setType(FilterType.SQL);
                    break;
                }
                default: {
                    LOGGER.warn("[Bug] Unrecognized filter type for simple consumer, type={}", (Object)type);
                }
            }
            SubscriptionEntry subscriptionEntry = SubscriptionEntry.newBuilder().setTopic(topic).setExpression(expressionBuilder.build()).build();
            subscriptionEntries.add(subscriptionEntry);
        }
        Subscription subscription = Subscription.newBuilder().setGroup(this.group.toProtobuf()).setLongPollingTimeout(Durations.fromNanos((long)this.longPollingTimeout.toNanos())).addAllSubscriptions(subscriptionEntries).build();
        return apache.rocketmq.v2.Settings.newBuilder().setAccessPoint(this.accessPoint.toProtobuf()).setClientType(this.clientType.toProtobuf()).setRequestTimeout(Durations.fromNanos((long)this.requestTimeout.toNanos())).setSubscription(subscription).setUserAgent(UserAgent.INSTANCE.toProtoBuf()).build();
    }

    @Override
    public void sync(apache.rocketmq.v2.Settings settings) {
        Settings.PubSubCase pubSubCase = settings.getPubSubCase();
        if (!Settings.PubSubCase.SUBSCRIPTION.equals((Object)pubSubCase)) {
            LOGGER.error("[Bug] Issued settings not match with the client type, clientId={}, pubSubCase={}, clientType={}", new Object[]{this.clientId, pubSubCase, this.clientType});
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("clientType", (Object)this.clientType).add("accessPoint", (Object)this.accessPoint).add("retryPolicy", (Object)this.retryPolicy).add("requestTimeout", (Object)this.requestTimeout).add("group", (Object)this.group).add("longPollingTimeout", (Object)this.longPollingTimeout).add("subscriptionExpressions", this.subscriptionExpressions).toString();
    }
}

