/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.apis;

import java.time.Duration;
import java.util.Optional;
import org.apache.rocketmq.client.apis.ClientConfigurationBuilder;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;

public class ClientConfiguration {
    private final String endpoints;
    private final SessionCredentialsProvider sessionCredentialsProvider;
    private final Duration requestTimeout;
    private final boolean sslEnabled;

    ClientConfiguration(String endpoints, SessionCredentialsProvider sessionCredentialsProvider, Duration requestTimeout, boolean sslEnabled) {
        this.endpoints = endpoints;
        this.sessionCredentialsProvider = sessionCredentialsProvider;
        this.requestTimeout = requestTimeout;
        this.sslEnabled = sslEnabled;
    }

    public static ClientConfigurationBuilder newBuilder() {
        return new ClientConfigurationBuilder();
    }

    public String getEndpoints() {
        return this.endpoints;
    }

    public Optional<SessionCredentialsProvider> getCredentialsProvider() {
        return Optional.ofNullable(this.sessionCredentialsProvider);
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }
}

