/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.weblogger.webservices.adminprotocol.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.Entry;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.LocaleString;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.Service;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class WeblogEntry
extends Entry {
    private String handle;
    private String name;
    private String description;
    private Locale locale;
    private TimeZone timezone;
    private Date dateCreated;
    private String creatingUser;
    private String emailAddress;
    private String appEntriesUrl;
    private String appResourcesUrl;
    private Boolean enabled;

    public WeblogEntry(Element e, String urlPrefix) {
        this.populate(e, urlPrefix);
    }

    public WeblogEntry(InputStream stream, String urlPrefix) throws JDOMException, IOException {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(stream);
        Element e = d.detachRootElement();
        this.populate(e, urlPrefix);
    }

    private void populate(Element e, String urlPrefix) {
        Element enabledElement;
        Element appResourcesUrlElement;
        Element appEntriesUrlElement;
        Element createdElement;
        Element emailElement;
        Element creatorElement;
        Element tzElement;
        Element localeElement;
        Element descElement;
        Element handleElement = e.getChild("handle", Service.NAMESPACE);
        if (handleElement != null) {
            this.setHandle(handleElement.getText());
        }
        String href = urlPrefix + "/" + "weblogs" + "/" + this.getHandle();
        this.setHref(href);
        Element nameElement = e.getChild("name", Service.NAMESPACE);
        if (nameElement != null) {
            this.setName(nameElement.getText());
        }
        if ((descElement = e.getChild("description", Service.NAMESPACE)) != null) {
            this.setDescription(descElement.getText());
        }
        if ((localeElement = e.getChild("locale", Service.NAMESPACE)) != null) {
            this.setLocale(localeElement.getText());
        }
        if ((tzElement = e.getChild("timezone", Service.NAMESPACE)) != null) {
            this.setTimezone(tzElement.getText());
        }
        if ((creatorElement = e.getChild("creating-user", Service.NAMESPACE)) != null) {
            this.setCreatingUser(creatorElement.getText());
        }
        if ((emailElement = e.getChild("email-address", Service.NAMESPACE)) != null) {
            this.setEmailAddress(emailElement.getText());
        }
        if ((createdElement = e.getChild("date-created", Service.NAMESPACE)) != null) {
            this.setDateCreated(new Date(Long.valueOf(createdElement.getText())));
        }
        if ((appEntriesUrlElement = e.getChild("app-entries-url", Service.NAMESPACE)) != null) {
            this.setAppEntriesUrl(appEntriesUrlElement.getText());
        }
        if ((appResourcesUrlElement = e.getChild("app-resources-url", Service.NAMESPACE)) != null) {
            this.setAppResourcesUrl(appResourcesUrlElement.getText());
        }
        if ((enabledElement = e.getChild("enabled", Service.NAMESPACE)) != null) {
            this.setEnabled(Boolean.valueOf(enabledElement.getText()));
        }
    }

    public WeblogEntry(String handle, String urlPrefix) {
        String href = urlPrefix + "/" + "weblogs" + "/" + handle;
        this.setHref(href);
        this.setHandle(handle);
    }

    public String getType() {
        return "weblog";
    }

    public Document toDocument() {
        String email;
        String creator;
        TimeZone tz;
        Locale locale;
        String desc;
        String name;
        Element weblog = new Element("weblog", Service.NAMESPACE);
        Document doc = new Document(weblog);
        weblog.setAttribute("href", this.getHref());
        String handle = this.getHandle();
        if (handle != null && handle.length() > 0) {
            Element handleElement = new Element("handle", Service.NAMESPACE);
            Text handleText = new Text(handle);
            handleElement.addContent((Content)handleText);
            weblog.addContent((Content)handleElement);
        }
        if ((name = this.getName()) != null) {
            Element nameElement = new Element("name", Service.NAMESPACE);
            Text nameText = new Text(name);
            nameElement.addContent((Content)nameText);
            weblog.addContent((Content)nameElement);
        }
        if ((desc = this.getDescription()) != null) {
            Element descElement = new Element("description", Service.NAMESPACE);
            Text descText = new Text(desc);
            descElement.addContent((Content)descText);
            weblog.addContent((Content)descElement);
        }
        if ((locale = this.getLocale()) != null) {
            Element localeElement = new Element("locale", Service.NAMESPACE);
            Text localeText = new Text(locale.toString());
            localeElement.addContent((Content)localeText);
            weblog.addContent((Content)localeElement);
        }
        if ((tz = this.getTimezone()) != null) {
            Element tzElement = new Element("timezone", Service.NAMESPACE);
            Text tzText = new Text(tz.getID());
            tzElement.addContent((Content)tzText);
            weblog.addContent((Content)tzElement);
        }
        if ((creator = this.getCreatingUser()) != null) {
            Element creatorElement = new Element("creating-user", Service.NAMESPACE);
            Text creatorText = new Text(creator);
            creatorElement.addContent((Content)creatorText);
            weblog.addContent((Content)creatorElement);
        }
        if ((email = this.getEmailAddress()) != null) {
            Element emailElement = new Element("email-address", Service.NAMESPACE);
            Text emailText = new Text(email);
            emailElement.addContent((Content)emailText);
            weblog.addContent((Content)emailElement);
        }
        Element dateCreatedElement = new Element("date-created", Service.NAMESPACE);
        Date datedCreated = this.getDateCreated();
        if (this.dateCreated != null) {
            Text createdText = new Text(String.valueOf(this.dateCreated.getTime()));
            dateCreatedElement.addContent((Content)createdText);
            weblog.addContent((Content)dateCreatedElement);
        }
        Element appEntriesUrlElement = new Element("app-entries-url", Service.NAMESPACE);
        String appEntriesUrl = this.getAppEntriesUrl();
        if (appEntriesUrl != null) {
            Text appEntriesUrlText = new Text(appEntriesUrl);
            appEntriesUrlElement.addContent((Content)appEntriesUrlText);
            weblog.addContent((Content)appEntriesUrlElement);
        }
        Element appResourcesUrlElement = new Element("app-resources-url", Service.NAMESPACE);
        String appResourcesUrl = this.getAppResourcesUrl();
        if (appResourcesUrl != null) {
            Text appResourcesUrlText = new Text(appResourcesUrl);
            appResourcesUrlElement.addContent((Content)appResourcesUrlText);
            weblog.addContent((Content)appResourcesUrlElement);
        }
        Element enabledElement = new Element("enabled", Service.NAMESPACE);
        Boolean enabled = this.getEnabled();
        if (enabled != null) {
            Text enabledText = new Text(this.getEnabled().toString());
            enabledElement.addContent((Content)enabledText);
            weblog.addContent((Content)enabledElement);
        }
        return doc;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        WeblogEntry other = (WeblogEntry)o;
        if (!WeblogEntry.areEqual(this.getEmailAddress(), other.getEmailAddress())) {
            return false;
        }
        if (!WeblogEntry.areEqual(this.getHandle(), other.getHandle())) {
            return false;
        }
        if (!WeblogEntry.areEqual(this.getLocale(), other.getLocale())) {
            return false;
        }
        if (!WeblogEntry.areEqual(this.getName(), other.getName())) {
            return false;
        }
        if (!WeblogEntry.areEqual(this.getDescription(), other.getDescription())) {
            return false;
        }
        if (!WeblogEntry.areEqual(this.getTimezone(), other.getTimezone())) {
            return false;
        }
        if (!WeblogEntry.areEqual(this.getEnabled(), other.getEnabled())) {
            return false;
        }
        return super.equals(o);
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocale(String localeString) {
        this.locale = new LocaleString(localeString).getLocale();
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public void setTimezone(String timezoneString) {
        this.timezone = TimeZone.getTimeZone(timezoneString);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getCreatingUser() {
        return this.creatingUser;
    }

    public void setCreatingUser(String creatingUser) {
        this.creatingUser = creatingUser;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getAppEntriesUrl() {
        return this.appEntriesUrl;
    }

    public void setAppEntriesUrl(String appEntriesUrl) {
        this.appEntriesUrl = appEntriesUrl;
    }

    public String getAppResourcesUrl() {
        return this.appResourcesUrl;
    }

    public void setAppResourcesUrl(String appResourcesUrl) {
        this.appResourcesUrl = appResourcesUrl;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    static interface Tags {
        public static final String WEBLOG = "weblog";
        public static final String HANDLE = "handle";
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String LOCALE = "locale";
        public static final String TIMEZONE = "timezone";
        public static final String DATE_CREATED = "date-created";
        public static final String CREATING_USER = "creating-user";
        public static final String EMAIL_ADDRESS = "email-address";
        public static final String APP_ENTRIES_URL = "app-entries-url";
        public static final String APP_RESOURCES_URL = "app-resources-url";
        public static final String ENABLED = "enabled";
    }
}

