/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.royale.abc.ABCConstants;
import org.apache.royale.abc.ABCReader;
import org.apache.royale.abc.semantics.ClassInfo;
import org.apache.royale.abc.semantics.InstanceInfo;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.Metadata;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.abc.semantics.PooledValue;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.abc.visitors.IClassVisitor;
import org.apache.royale.abc.visitors.IMetadataVisitor;
import org.apache.royale.abc.visitors.IMethodBodyVisitor;
import org.apache.royale.abc.visitors.IMethodVisitor;
import org.apache.royale.abc.visitors.IScriptVisitor;
import org.apache.royale.abc.visitors.ITraitVisitor;
import org.apache.royale.abc.visitors.ITraitsVisitor;
import org.apache.royale.abc.visitors.NilVisitors;

public class ABCParser {
    public boolean verbose = false;
    public PrintWriter output;
    byte[] abc;
    private Name[] names;
    private String[] strings;
    private Namespace[] namespaces;
    private Nsset[] namespace_sets;
    private int[] ints;
    private long[] uints;
    private double[] doubles;
    private Metadata[] metadata;
    private MethodInfo[] methodInfos;
    private IMethodVisitor[] methodVisitors;
    private ClassInfo[] classInfos;
    private InstanceInfo[] instanceInfos;
    Map<ClassInfo, Integer> classInfoToTraits = new HashMap<ClassInfo, Integer>();
    Map<InstanceInfo, Integer> instanceInfoToTraits = new HashMap<InstanceInfo, Integer>();

    public ABCParser(byte[] abc) {
        this.abc = abc;
    }

    public ABCParser(InputStream input) throws IOException {
        ByteArrayOutputStream bufferedABC = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = input.read(buffer);
        while (n != -1) {
            bufferedABC.write(buffer, 0, n);
            n = input.read(buffer);
        }
        this.abc = bufferedABC.toByteArray();
    }

    public void parseABC(IABCVisitor vabc) {
        int i;
        int i2;
        int i3;
        int i4;
        ABCReader p = new ABCReader(0, this.abc);
        int minor = p.readU16();
        int major = p.readU16();
        vabc.visit(major, minor);
        if (this.verbose) {
            this.output.println("parsing int pool");
        }
        int pool_size = p.readU30();
        this.ints = new int[pool_size];
        for (i4 = 1; i4 < pool_size; ++i4) {
            this.ints[i4] = p.readU30();
            vabc.visitPooledInt(this.ints[i4]);
        }
        if (this.verbose) {
            this.output.println("parsing uint pool");
        }
        pool_size = p.readU30();
        this.uints = new long[pool_size];
        for (i4 = 1; i4 < pool_size; ++i4) {
            this.uints[i4] = 0xFFFFFFFFL & (long)p.readU30();
            vabc.visitPooledUInt(this.uints[i4]);
        }
        if (this.verbose) {
            this.output.println("parsing float pool");
        }
        pool_size = p.readU30();
        this.doubles = new double[pool_size];
        for (i4 = 1; i4 < pool_size; ++i4) {
            this.doubles[i4] = p.readDouble();
            vabc.visitPooledDouble(this.doubles[i4]);
        }
        if (this.verbose) {
            this.output.println("parsing string pool");
        }
        pool_size = p.readU30();
        this.strings = new String[pool_size];
        for (i4 = 1; i4 < pool_size; ++i4) {
            int len = p.readU30();
            try {
                this.strings[i4] = new String(this.abc, p.pos, len, "UTF-8");
            }
            catch (UnsupportedEncodingException badEncoding) {
                throw new IllegalStateException(badEncoding);
            }
            vabc.visitPooledString(this.strings[i4]);
            p.pos += len;
        }
        if (this.verbose) {
            this.output.println("parsing namespace pool");
        }
        pool_size = p.readU30();
        this.namespaces = new Namespace[pool_size];
        for (i4 = 1; i4 < pool_size; ++i4) {
            int ns_kind = p.readU8();
            int name_idx = p.readU30();
            String ns_name = this.readPool(this.strings, name_idx, "string");
            this.namespaces[i4] = new Namespace(ns_kind, ns_name);
            vabc.visitPooledNamespace(this.namespaces[i4]);
        }
        if (this.verbose) {
            this.output.println("parsing namespace_set pool");
        }
        pool_size = p.readU30();
        this.namespace_sets = new Nsset[pool_size];
        for (i4 = 1; i4 < pool_size; ++i4) {
            int nsset_size = p.readU30();
            Vector<Namespace> nsset_contents = new Vector<Namespace>(nsset_size);
            int m = nsset_size;
            for (int j = 0; j < m; ++j) {
                nsset_contents.add(this.readPool(this.namespaces, p.readU30(), "namespace"));
            }
            this.namespace_sets[i4] = new Nsset(nsset_contents);
            vabc.visitPooledNsSet(this.namespace_sets[i4]);
        }
        pool_size = p.readU30();
        if (this.verbose) {
            this.output.println("parsing name pool");
        }
        this.names = new Name[pool_size];
        ArrayList<NameAndPos> forward_ref_names = null;
        for (int i5 = 1; i5 < pool_size; ++i5) {
            Name name;
            int name_pos = p.pos;
            this.names[i5] = name = this.readName(p);
            if (name.isTypeName() && this.usesForwardReference(name)) {
                if (forward_ref_names == null) {
                    forward_ref_names = new ArrayList<NameAndPos>();
                }
                forward_ref_names.add(new NameAndPos(i5, name_pos));
                continue;
            }
            vabc.visitPooledName(name);
        }
        if (forward_ref_names != null) {
            int orig_pos = p.pos;
            for (NameAndPos nap : forward_ref_names) {
                p.pos = nap.pos;
                Name newName = this.readName(p);
                this.names[nap.nameIndex].initTypeName(newName.getTypeNameBase(), newName.getTypeNameParameter());
                vabc.visitPooledName(this.names[nap.nameIndex]);
            }
            p.pos = orig_pos;
        }
        if (this.verbose) {
            this.output.println("parsing method pool");
        }
        int n_methods = p.readU30();
        this.methodInfos = new MethodInfo[n_methods];
        this.methodVisitors = new IMethodVisitor[n_methods];
        int n = n_methods;
        for (i3 = 0; i3 < n; ++i3) {
            this.methodInfos[i3] = this.readMethodInfo(p);
            this.methodVisitors[i3] = vabc.visitMethod(this.methodInfos[i3]);
            if (this.methodVisitors[i3] == null) continue;
            this.methodVisitors[i3].visit();
        }
        if (this.verbose) {
            this.output.println("parsing metadata pool");
        }
        pool_size = p.readU30();
        this.metadata = new Metadata[pool_size];
        for (i3 = 0; i3 < pool_size; ++i3) {
            this.metadata[i3] = this.readMetadata(p);
            vabc.visitPooledMetadata(this.metadata[i3]);
        }
        if (this.verbose) {
            this.output.println("parsing instances pool");
        }
        int n_instances = p.readU30();
        this.instanceInfos = new InstanceInfo[n_instances];
        this.classInfos = new ClassInfo[n_instances];
        int n2 = n_instances;
        for (i2 = 0; i2 < n2; ++i2) {
            this.instanceInfos[i2] = this.readInstanceInfo(p);
        }
        n2 = n_instances;
        for (i2 = 0; i2 < n2; ++i2) {
            this.classInfos[i2] = this.readClassInfo(p);
        }
        n2 = n_instances;
        for (i2 = 0; i2 < n2; ++i2) {
            IClassVisitor cv = vabc.visitClass(this.instanceInfos[i2], this.classInfos[i2]);
            if (cv == null) continue;
            ITraitsVisitor tv = cv.visitClassTraits();
            this.readTraits(p, tv, this.classInfoToTraits.get(this.classInfos[i2]));
            tv.visitEnd();
            tv = cv.visitInstanceTraits();
            this.readTraits(p, tv, this.instanceInfoToTraits.get(this.instanceInfos[i2]));
            tv.visitEnd();
            cv.visitEnd();
        }
        if (this.verbose) {
            this.output.println("parsing scripts pool");
        }
        int n_scripts = p.readU30();
        for (int i6 = 0; i6 < n_scripts; ++i6) {
            IScriptVisitor sv = vabc.visitScript();
            if (sv != null) {
                this.readScript(p, sv);
                continue;
            }
            p.readU30();
            this.readTraits(p, NilVisitors.NIL_TRAITS_VISITOR);
        }
        if (this.verbose) {
            this.output.println("parsing method bodies pool");
        }
        int n_method_bodies = p.readU30();
        for (i = 0; i < n_method_bodies; ++i) {
            this.readBody(vabc, p);
        }
        for (i = 0; i < n_methods; ++i) {
            if (this.methodVisitors[i] == null) continue;
            this.methodVisitors[i].visitEnd();
        }
        vabc.visitEnd();
    }

    private boolean usesForwardReference(Name name) {
        Name nameBase = name.getTypeNameBase();
        Name nameParam = name.getTypeNameParameter();
        if (nameBase == null || nameParam == null) {
            return true;
        }
        if (nameBase.isTypeName() && this.usesForwardReference(nameBase)) {
            return true;
        }
        return nameParam.isTypeName() && this.usesForwardReference(nameParam);
    }

    Metadata readMetadata(ABCReader p) {
        String metadata_name = this.readPool(this.strings, p.readU30(), "string");
        int value_count = p.readU30();
        String[] keys = new String[value_count];
        for (int i = 0; i < value_count; ++i) {
            int key_index = p.readU30();
            keys[i] = this.readPool(this.strings, key_index, "string");
        }
        String[] values = new String[value_count];
        for (int i = 0; i < value_count; ++i) {
            int value_index = p.readU30();
            values[i] = this.readPool(this.strings, value_index, "string");
        }
        Metadata metadata = new Metadata(metadata_name, keys, values);
        return metadata;
    }

    MethodInfo readMethodInfo(ABCReader p) {
        MethodInfo m = new MethodInfo();
        int param_count = p.readU30();
        int return_type_index = p.readU30();
        Name return_type = this.readPool(this.names, return_type_index, "name");
        m.setReturnType(return_type);
        Vector<Name> param_types = new Vector<Name>(param_count);
        for (int j = 0; j < param_count; ++j) {
            int param_index = p.readU30();
            Name param_type = this.readPool(this.names, param_index, "name");
            param_types.add(param_type);
        }
        m.setParamTypes(param_types);
        String methodName = this.readPool(this.strings, p.readU30(), "string");
        m.setMethodName(methodName);
        m.setFlags((byte)p.readU8());
        if (m.hasOptional()) {
            int optional_count = p.readU30();
            assert (optional_count > 0);
            for (int j = 0; j < optional_count; ++j) {
                m.addDefaultValue(this.readArgDefault(p));
            }
        }
        if (m.hasParamNames()) {
            for (int j = 0; j < param_count; ++j) {
                int param_name_index = p.readU30();
                String param_name = this.readPoolWithDefault(this.strings, param_name_index, "");
                m.getParamNames().add(param_name);
            }
        }
        return m;
    }

    Name readName(ABCReader p) {
        int kind = p.readU8();
        switch (kind) {
            default: {
                throw new RuntimeException(String.format("Unknown name kind 0x%x", kind));
            }
            case 29: {
                int index = p.readU30();
                int count = p.readU30();
                assert (count == 1);
                int typeparm = p.readU30();
                Name mn = this.readPool(this.names, index, "name");
                Name type_param = this.readPool(this.names, typeparm, "name");
                return new Name(mn, type_param);
            }
            case 7: 
            case 13: {
                int ns_idx = p.readU30();
                Nsset nss = ns_idx != 0 ? new Nsset(this.readPool(this.namespaces, ns_idx, "namespace")) : null;
                return new Name(kind, nss, this.readPool(this.strings, p.readU30(), "string"));
            }
            case 9: 
            case 14: {
                int local_ix = p.readU30();
                int nss_ix = p.readU30();
                return new Name(kind, this.readPool(this.namespace_sets, nss_ix, "namespace_set"), this.readPool(this.strings, local_ix, "string"));
            }
            case 15: 
            case 16: {
                return new Name(kind, null, this.readPool(this.strings, p.readU30(), "string"));
            }
            case 27: 
            case 28: {
                return new Name(kind, this.readPool(this.namespace_sets, p.readU30(), "namespace_set"), null);
            }
            case 17: 
            case 18: 
        }
        return new Name(kind, null, null);
    }

    void readTraits(ABCReader p, ITraitsVisitor traits_visitor) {
        assert (traits_visitor != null) : "Instead of passing null, pass NilVisitors.NIL_TRAITS_VISITOR";
        traits_visitor.visit();
        int n_traits = p.readU30();
        for (int i = 0; i < n_traits; ++i) {
            ITraitVisitor trait_visitor;
            Name trait_name = this.readPool(this.names, p.readU30(), "name");
            int tag = p.readU8();
            int kind = tag & 0xF;
            boolean is_method_getter_setter = false;
            switch (kind) {
                case 0: 
                case 6: {
                    int slot_id = p.readU30();
                    Name slot_type = this.readPool(this.names, p.readU30(), "name");
                    Object slot_value = this.readSlotDefault(p);
                    trait_visitor = traits_visitor.visitSlotTrait(kind, trait_name, slot_id, slot_type, slot_value);
                    break;
                }
                case 4: {
                    trait_visitor = traits_visitor.visitClassTrait(kind, trait_name, p.readU30(), this.readPool(this.classInfos, p.readU30(), "classInfo"));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    is_method_getter_setter = true;
                }
                case 5: {
                    trait_visitor = traits_visitor.visitMethodTrait(kind, trait_name, p.readU30(), this.readPool(this.methodInfos, p.readU30(), "methodInfo"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("illegal trait kind 0x%h at offset %d", kind, p.pos));
                }
            }
            if (trait_visitor == null) {
                trait_visitor = NilVisitors.NIL_TRAIT_VISITOR;
            }
            trait_visitor.visitStart();
            if (is_method_getter_setter) {
                trait_visitor.visitAttribute("final", this.functionIsFinal(tag));
                trait_visitor.visitAttribute("override", this.functionIsOverride(tag));
            }
            if (this.traitHasMetadata(tag)) {
                int n_entries = p.readU30();
                IMetadataVisitor mv = trait_visitor.visitMetadata(n_entries);
                for (int j = 0; j < n_entries; ++j) {
                    Metadata md = this.readPool(this.metadata, p.readU30(), "metadata");
                    if (mv == null) continue;
                    mv.visit(md);
                }
            }
            trait_visitor.visitEnd();
        }
        traits_visitor.visitEnd();
    }

    private boolean traitHasMetadata(int kind) {
        return (kind >> 4 & 4) != 0;
    }

    private boolean functionIsFinal(int kind) {
        return (kind >> 4 & 1) != 0;
    }

    private boolean functionIsOverride(int kind) {
        return (kind >> 4 & 2) != 0;
    }

    void readTraits(ABCReader p, ITraitsVisitor tv, Integer pos) {
        int saved_pos = p.pos;
        p.pos = pos;
        this.readTraits(p, tv);
        p.pos = saved_pos;
    }

    Object readSlotDefault(ABCReader p) {
        int i = p.readU30();
        if (i != 0) {
            int kind = p.readU8();
            return this.defaultValue(kind, i);
        }
        return ABCConstants.UNDEFINED_VALUE;
    }

    private PooledValue readArgDefault(ABCReader p) {
        int i = p.readU30();
        int kind = p.readU8();
        Object v = this.defaultValue(kind, i);
        PooledValue result = new PooledValue(kind, v);
        return result;
    }

    Object defaultValue(int kind, int i) {
        if (i == 0) {
            return ABCConstants.NULL_VALUE;
        }
        switch (kind) {
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return Boolean.TRUE;
            }
            case 12: {
                return ABCConstants.NULL_VALUE;
            }
            case 1: {
                return this.readPool(this.strings, i, "string");
            }
            case 3: {
                return this.readIntPool(i);
            }
            case 4: {
                return this.readUintPool(i);
            }
            case 6: {
                return this.readDoublePool(i);
            }
            case 8: {
                return this.readPool(this.namespaces, i, "namespace");
            }
            case 5: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                return this.readPool(this.namespaces, i, "namespace");
            }
        }
        assert (false) : "Unknown value kind " + Integer.toString(i);
        return null;
    }

    void readScript(ABCReader p, IScriptVisitor sv) {
        sv.visit();
        sv.visitInit(this.readPool(this.methodInfos, p.readU30(), "methodInfo"));
        ITraitsVisitor scriptTraitsVisitor = sv.visitTraits();
        this.readTraits(p, scriptTraitsVisitor);
        scriptTraitsVisitor.visitEnd();
        sv.visitEnd();
    }

    ClassInfo readClassInfo(ABCReader p) {
        ClassInfo cinfo = new ClassInfo();
        cinfo.cInit = this.readPool(this.methodInfos, p.readU30(), "methodInfo");
        this.classInfoToTraits.put(cinfo, p.pos);
        this.readTraits(p, NilVisitors.NIL_TRAITS_VISITOR);
        return cinfo;
    }

    InstanceInfo readInstanceInfo(ABCReader p) {
        InstanceInfo iinfo = new InstanceInfo();
        iinfo.name = this.readPool(this.names, p.readU30(), "name");
        iinfo.superName = this.readPool(this.names, p.readU30(), "name");
        iinfo.flags = p.readU8();
        if (iinfo.hasProtectedNs()) {
            iinfo.protectedNs = this.readPool(this.namespaces, p.readU30(), "namespace");
        }
        iinfo.interfaceNames = new Name[p.readU30()];
        int n = iinfo.interfaceNames.length;
        for (int j = 0; j < n; ++j) {
            iinfo.interfaceNames[j] = this.readPool(this.names, p.readU30(), "name");
        }
        iinfo.iInit = this.readPool(this.methodInfos, p.readU30(), "methodInfo");
        this.instanceInfoToTraits.put(iinfo, p.pos);
        this.readTraits(p, NilVisitors.NIL_TRAITS_VISITOR);
        return iinfo;
    }

    void readBody(IABCVisitor vabc, ABCReader p) {
        MethodBodyInfo mb = new MethodBodyInfo();
        int method_id = p.readU30();
        mb.max_stack = p.readU30();
        mb.max_local = p.readU30();
        mb.initial_scope = p.readU30();
        mb.max_scope = p.readU30();
        mb.code_len = p.readU30();
        mb.setMethodInfo(this.readPool(this.methodInfos, method_id, "methodInfo"));
        IMethodBodyVisitor mv = null;
        ITraitsVisitor tv = NilVisitors.NIL_TRAITS_VISITOR;
        if (this.readPool(this.methodVisitors, method_id, "methodVisitor") != null) {
            mv = this.readPool(this.methodVisitors, method_id, "methodVisitor").visitBody(mb);
        }
        if (mv != null) {
            mv.visit();
            this.readCode(mb, mv, p);
            tv = mv.visitTraits();
            mv.visitEnd();
            this.readPool(this.methodVisitors, method_id, "methodVisitor").visitEnd();
            this.methodVisitors[method_id] = null;
        } else {
            p.pos += mb.code_len;
            this.skipExceptions(p);
        }
        this.readTraits(p, tv);
        tv.visitEnd();
    }

    void readCode(MethodBodyInfo mb, IMethodBodyVisitor m, ABCReader p) {
        int end_pos = p.pos + mb.code_len;
        Map<Integer, Label> labels_by_pos = this.readExceptions(p, m, end_pos);
        while (p.pos < end_pos) {
            Label insn_label;
            int insn_pos = p.pos;
            int op = p.readU8();
            switch (op) {
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 35: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 48: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 71: 
                case 72: 
                case 80: 
                case 81: 
                case 82: 
                case 87: 
                case 100: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 122: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 135: 
                case 137: 
                case 144: 
                case 145: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 179: 
                case 180: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 243: {
                    m.visitInstruction(op);
                    break;
                }
                case 50: {
                    m.visitInstruction(op, new Object[]{p.readU30(), p.readU30()});
                    break;
                }
                case 68: {
                    m.visitInstruction(op, new Object[]{this.readPool(this.methodInfos, p.readU30(), "methodInfo"), p.readU30()});
                    break;
                }
                case 4: 
                case 5: 
                case 89: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 102: 
                case 104: 
                case 106: 
                case 128: 
                case 134: 
                case 178: {
                    m.visitInstruction(op, this.readPool(this.names, p.readU30(), "name"));
                    break;
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 78: 
                case 79: {
                    m.visitInstruction(op, new Object[]{this.readPool(this.names, p.readU30(), "name"), p.readU30()});
                    break;
                }
                case 65: 
                case 66: 
                case 73: 
                case 85: 
                case 86: {
                    m.visitInstruction(op, p.readU30());
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    int jump_target = p.readS24() + p.pos;
                    if (jump_target < insn_pos) assert (labels_by_pos.containsKey(jump_target)) : "Unmapped backwards branch target " + jump_target + ", insn_pos " + insn_pos + ": " + labels_by_pos;
                    m.visitInstruction(op, this.addLabel(jump_target, labels_by_pos));
                    break;
                }
                case 27: {
                    int default_case = p.readS24() + insn_pos;
                    Label default_label = this.addLabel(default_case, labels_by_pos);
                    int case_count = p.readU30() + 1;
                    Object[] switch_labels = new Label[case_count + 1];
                    switch_labels[case_count] = default_label;
                    for (int i = 0; i < case_count; ++i) {
                        int current_case = p.readS24() + insn_pos;
                        switch_labels[i] = this.addLabel(current_case, labels_by_pos);
                    }
                    m.visitInstruction(op, switch_labels);
                    break;
                }
                case 9: {
                    this.addLabel(insn_pos, labels_by_pos);
                    m.visitInstruction(op);
                    break;
                }
                case 8: 
                case 37: 
                case 83: 
                case 90: 
                case 98: 
                case 99: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 146: 
                case 148: 
                case 194: 
                case 195: 
                case 240: 
                case 242: {
                    m.visitInstruction(op, p.readU30());
                    break;
                }
                case 88: {
                    m.visitInstruction(op, this.readPool(this.classInfos, p.readU30(), "classInfo"));
                    break;
                }
                case 36: 
                case 101: {
                    m.visitInstruction(op, p.readU8());
                    break;
                }
                case 6: 
                case 44: 
                case 241: {
                    m.visitInstruction(op, this.readPool(this.strings, p.readU30(), "string"));
                    break;
                }
                case 49: {
                    m.visitInstruction(op, this.readPool(this.namespaces, p.readU30(), "namespace"));
                    break;
                }
                case 45: {
                    m.visitInstruction(op, (Object)this.readIntPool(p.readU30()));
                    break;
                }
                case 46: {
                    m.visitInstruction(op, this.readUintPool(p.readU30()));
                    break;
                }
                case 47: {
                    m.visitInstruction(op, this.readDoublePool(p.readU30()));
                    break;
                }
                case 64: {
                    m.visitInstruction(op, this.readPool(this.methodInfos, p.readU30(), "methodInfo"));
                    break;
                }
                case 239: {
                    m.visitInstruction(op, new Object[]{p.readU8(), this.readPool(this.strings, p.readU30(), "string"), p.readU8(), p.readU30()});
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown ABC bytecode 0x%x", op));
                }
            }
            if ((insn_label = labels_by_pos.get(insn_pos)) == null) continue;
            m.labelCurrent(insn_label);
        }
        this.skipExceptions(p);
    }

    private Map<Integer, Label> readExceptions(ABCReader p, IMethodBodyVisitor mbv, int end_pos) {
        HashMap<Integer, Label> result = new HashMap<Integer, Label>();
        int start_pos = p.pos;
        p.pos = end_pos;
        int n_exceptions = p.readU30();
        for (int i = 0; i < n_exceptions; ++i) {
            int from_pos = p.readU30() + start_pos;
            int to_pos = p.readU30() + start_pos;
            int catch_pos = p.readU30() + start_pos;
            if (!result.containsKey(from_pos)) {
                result.put(from_pos, new Label("try/from", Label.LabelKind.ANY_INSTRUCTION));
            }
            if (!result.containsKey(to_pos)) {
                result.put(to_pos, new Label("try/to", Label.LabelKind.ANY_INSTRUCTION));
            }
            if (!result.containsKey(catch_pos)) {
                result.put(catch_pos, new Label("catch"));
            }
            Name catch_type = this.readPool(this.names, p.readU30(), "name");
            int catch_idx = p.readU30();
            Name catch_var = this.readPool(this.names, catch_idx, "name");
            if (mbv == null) continue;
            mbv.visitException((Label)result.get(from_pos), (Label)result.get(to_pos), (Label)result.get(catch_pos), catch_type, catch_var);
        }
        p.pos = start_pos;
        return result;
    }

    private void skipExceptions(ABCReader p) {
        int n_exceptions = p.readU30();
        for (int i = 0; i < n_exceptions * 5; ++i) {
            p.readU30();
        }
    }

    private Label addLabel(int key, Map<Integer, Label> labels) {
        if (!labels.containsKey(key)) {
            labels.put(key, new Label());
        }
        return labels.get(key);
    }

    private <T> T readPool(T[] pool, int idx, String poolName) {
        if (idx < 0 || idx >= pool.length) {
            throw new IllegalStateException(String.format("%d is not a valid %s pool index.", idx, poolName));
        }
        return pool[idx];
    }

    private <T> T readPoolWithDefault(T[] pool, int idx, T defaultValue) {
        if (idx < 0) {
            throw new IllegalStateException(String.format("%d is not a valid pool index", idx));
        }
        if (idx >= pool.length) {
            return defaultValue;
        }
        return pool[idx];
    }

    private int readIntPool(int idx) {
        if (idx < 0 || idx >= this.ints.length) {
            throw new IllegalStateException(String.format("%d is not a valid int pool index.", idx));
        }
        return this.ints[idx];
    }

    private long readUintPool(int idx) {
        if (idx < 0 || idx >= this.uints.length) {
            throw new IllegalStateException(String.format("%d is not a valid uint pool index.", idx));
        }
        return this.uints[idx];
    }

    private double readDoublePool(int idx) {
        if (idx < 0 || idx >= this.doubles.length) {
            throw new IllegalStateException(String.format("%d is not a valid double pool index.", idx));
        }
        return this.doubles[idx];
    }

    private static class NameAndPos {
        public final int nameIndex;
        public final int pos;

        public NameAndPos(int nameIndex, int pos) {
            this.nameIndex = nameIndex;
            this.pos = pos;
        }
    }
}

