/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class PolymerPassStaticUtils {
    private static final String VIRTUAL_FILE = "<PolymerPassStaticUtils.java>";

    PolymerPassStaticUtils() {
    }

    @VisibleForTesting
    public static boolean isPolymerCall(Node call) {
        if (call == null || !call.isCall()) {
            return false;
        }
        Node name = call.getFirstChild();
        return name.matchesQualifiedName("Polymer") || "Polymer".equals(name.getOriginalQualifiedName()) || name.isGetProp() && name.getLastChild().getString().equals("Polymer");
    }

    @VisibleForTesting
    public static boolean isPolymerClass(Node cls) {
        if (cls == null || !cls.isClass()) {
            return false;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(cls);
        if (info != null && info.isPolymer()) {
            return true;
        }
        Node heritage = cls.getSecondChild();
        return !heritage.isEmpty() && (heritage.matchesQualifiedName("Polymer.Element") || heritage.matchesQualifiedName("PolymerElement") || "PolymerElement".equals(heritage.getOriginalQualifiedName()) || heritage.isGetProp() && heritage.getLastChild().getString().equals("PolymerElement"));
    }

    static void switchDollarSignPropsToBrackets(Node def, final AbstractCompiler compiler) {
        Preconditions.checkState(def.isObjectLit() || def.isClassMembers());
        for (Node keyNode : def.children()) {
            Node value = keyNode.getFirstChild();
            if (value == null || !value.isFunction()) continue;
            NodeUtil.visitPostOrder(value.getLastChild(), new NodeUtil.Visitor(){

                @Override
                public void visit(Node n) {
                    if (n.isString() && n.getString().equals("$") && n.getParent().isGetProp() && n.getGrandparent().isGetProp()) {
                        Node dollarChildProp = n.getGrandparent();
                        dollarChildProp.setToken(Token.GETELEM);
                        compiler.reportChangeToEnclosingScope(dollarChildProp);
                    }
                }
            });
        }
    }

    static void quoteListenerAndHostAttributeKeys(Node objLit, AbstractCompiler compiler) {
        Preconditions.checkState(objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            if (keyNode.isComputedProp() || !keyNode.getString().equals("listeners") && !keyNode.getString().equals("hostAttributes")) continue;
            for (Node keyToQuote : keyNode.getFirstChild().children()) {
                if (keyToQuote.isQuotedString()) continue;
                keyToQuote.setQuotedString();
                compiler.reportChangeToEnclosingScope(keyToQuote);
            }
        }
    }

    static ImmutableList<PolymerPass.MemberDefinition> extractProperties(Node descriptor, PolymerClassDefinition.DefinitionType defType, AbstractCompiler compiler, @Nullable Node constructor) {
        Node properties = descriptor;
        if (defType == PolymerClassDefinition.DefinitionType.ObjectLiteral) {
            properties = NodeUtil.getFirstPropMatchingKey(descriptor, "properties");
        }
        if (properties == null) {
            return ImmutableList.of();
        }
        HashMap<String, JSDocInfo> constructorPropertyJsDoc = new HashMap<String, JSDocInfo>();
        if (constructor != null) {
            PolymerPassStaticUtils.collectConstructorPropertyJsDoc(constructor, constructorPropertyJsDoc);
        }
        ImmutableList.Builder members = ImmutableList.builder();
        for (Node keyNode : properties.children()) {
            JSDocInfo bestJsDoc;
            JSDocInfo constructorJsDoc = (JSDocInfo)constructorPropertyJsDoc.get(keyNode.getString());
            JSDocInfo propertiesConfigJsDoc = NodeUtil.getBestJSDocInfo(keyNode);
            if (constructorJsDoc != null) {
                bestJsDoc = constructorJsDoc;
                if (propertiesConfigJsDoc != null) {
                    compiler.report(JSError.make(keyNode, PolymerPassErrors.POLYMER_MISPLACED_PROPERTY_JSDOC, new String[0]));
                }
            } else {
                bestJsDoc = propertiesConfigJsDoc;
            }
            members.add(new PolymerPass.MemberDefinition(bestJsDoc, keyNode, keyNode.getFirstChild()));
        }
        return members.build();
    }

    private static void collectConstructorPropertyJsDoc(Node node, Map<String, JSDocInfo> map) {
        Preconditions.checkNotNull(node);
        for (Node child : node.children()) {
            if (child.isGetProp() && child.getFirstChild().isThis() && child.getSecondChild().isString()) {
                map.put(child.getSecondChild().getString(), NodeUtil.getBestJSDocInfo(child));
                continue;
            }
            PolymerPassStaticUtils.collectConstructorPropertyJsDoc(child, map);
        }
    }

    static JSTypeExpression getTypeFromProperty(PolymerPass.MemberDefinition property, AbstractCompiler compiler) {
        Node typeNode;
        String typeString;
        if (property.info != null && property.info.hasType()) {
            return property.info.getType();
        }
        if (property.value.isObjectLit()) {
            Node typeValue = NodeUtil.getFirstPropMatchingKey(property.value, "type");
            if (typeValue == null || !typeValue.isName()) {
                compiler.report(JSError.make(property.name, PolymerPassErrors.POLYMER_INVALID_PROPERTY, new String[0]));
                return null;
            }
            typeString = typeValue.getString();
        } else {
            typeString = property.value.isName() ? property.value.getString() : "";
        }
        switch (typeString) {
            case "Boolean": 
            case "String": 
            case "Number": {
                typeNode = IR.string(typeString.toLowerCase());
                break;
            }
            case "Array": 
            case "Function": 
            case "Object": 
            case "Date": {
                typeNode = new Node(Token.BANG, IR.string(typeString));
                break;
            }
            default: {
                compiler.report(JSError.make(property.name, PolymerPassErrors.POLYMER_INVALID_PROPERTY, new String[0]));
                return null;
            }
        }
        return new JSTypeExpression(typeNode, VIRTUAL_FILE);
    }

    public static String getPolymerElementType(PolymerClassDefinition cls) {
        String nativeElementName = cls.nativeBaseElement == null ? "" : CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, cls.nativeBaseElement);
        return SimpleFormat.format("Polymer%sElement", nativeElementName);
    }
}

