/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

public final class CheckInterfaces
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    public static final DiagnosticType NON_DECLARATION_STATEMENT_IN_RECORD = DiagnosticType.disabled("JSC_NON_DECLARATION_STATEMENT_IN_RECORD", "@record functions should not contain statements other than field declarations");
    public static final DiagnosticType INTERFACE_FUNCTION_NOT_EMPTY = DiagnosticType.disabled("JSC_INTERFACE_FUNCTION_NOT_EMPTY", "interface functions must have an empty body");
    public static final DiagnosticType INTERFACE_SHOULD_NOT_TAKE_ARGS = DiagnosticType.disabled("JSC_INTERFACE_SHOULD_NOT_TAKE_ARGS", "Interface functions should not take any arguments");
    private final AbstractCompiler compiler;

    public CheckInterfaces(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    private boolean isInterface(Node n) {
        if (!n.isFunction()) {
            return false;
        }
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
        return jsDoc != null && jsDoc.isInterface();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Node block;
        if (!this.isInterface(n)) {
            return;
        }
        Node args = n.getSecondChild();
        if (args.hasChildren()) {
            t.report(args.getFirstChild(), INTERFACE_SHOULD_NOT_TAKE_ARGS, new String[0]);
        }
        if ((block = n.getLastChild()).hasChildren()) {
            if (NodeUtil.getBestJSDocInfo(n).usesImplicitMatch()) {
                for (Node stmt : block.children()) {
                    if (stmt.isExprResult() && stmt.getFirstChild().isGetProp() && stmt.getFirstFirstChild().isThis() && stmt.getFirstChild().getJSDocInfo() != null) continue;
                    t.report(stmt, NON_DECLARATION_STATEMENT_IN_RECORD, new String[0]);
                    return;
                }
            } else {
                t.report(block.getFirstChild(), INTERFACE_FUNCTION_NOT_EMPTY, new String[0]);
            }
        }
    }
}

