/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import java.util.EnumMap;
import java.util.Map;

public enum Keywords {
    BREAK("break", TokenType.BREAK),
    CASE("case", TokenType.CASE),
    CATCH("catch", TokenType.CATCH),
    CONTINUE("continue", TokenType.CONTINUE),
    DEBUGGER("debugger", TokenType.DEBUGGER),
    DEFAULT("default", TokenType.DEFAULT),
    DELETE("delete", TokenType.DELETE),
    DO("do", TokenType.DO),
    ELSE("else", TokenType.ELSE),
    FINALLY("finally", TokenType.FINALLY),
    FOR("for", TokenType.FOR),
    FUNCTION("function", TokenType.FUNCTION),
    IF("if", TokenType.IF),
    IN("in", TokenType.IN),
    INSTANCEOF("instanceof", TokenType.INSTANCEOF),
    NEW("new", TokenType.NEW),
    RETURN("return", TokenType.RETURN),
    SWITCH("switch", TokenType.SWITCH),
    THIS("this", TokenType.THIS),
    THROW("throw", TokenType.THROW),
    TRY("try", TokenType.TRY),
    TYPEOF("typeof", TokenType.TYPEOF),
    VAR("var", TokenType.VAR),
    VOID("void", TokenType.VOID),
    WHILE("while", TokenType.WHILE),
    WITH("with", TokenType.WITH),
    CLASS("class", TokenType.CLASS),
    CONST("const", TokenType.CONST),
    ENUM("enum", TokenType.ENUM),
    EXPORT("export", TokenType.EXPORT),
    EXTENDS("extends", TokenType.EXTENDS),
    IMPORT("import", TokenType.IMPORT),
    SUPER("super", TokenType.SUPER),
    IMPLEMENTS("implements", TokenType.IMPLEMENTS),
    INTERFACE("interface", TokenType.INTERFACE),
    LET("let", TokenType.LET),
    PACKAGE("package", TokenType.PACKAGE),
    PRIVATE("private", TokenType.PRIVATE),
    PROTECTED("protected", TokenType.PROTECTED),
    PUBLIC("public", TokenType.PUBLIC),
    STATIC("static", TokenType.STATIC),
    YIELD("yield", TokenType.YIELD),
    NULL("null", TokenType.NULL),
    TRUE("true", TokenType.TRUE),
    FALSE("false", TokenType.FALSE),
    DECLARE("declare", TokenType.DECLARE),
    TYPE("type", TokenType.TYPE),
    MODULE("module", TokenType.MODULE),
    NAMESPACE("namespace", TokenType.NAMESPACE);

    private static final Map<String, Keywords> KEYWORDS_BY_NAME;
    private static final Map<TokenType, Keywords> KEYWORDS_BY_TYPE;
    public final String value;
    public final TokenType type;
    private final boolean isTypeScriptSpecificKeyword;

    private Keywords(String value, TokenType type) {
        this.value = value;
        this.type = type;
        this.isTypeScriptSpecificKeyword = Keywords.isTypeScriptSpecificKeyword(type);
    }

    public String toString() {
        return this.value;
    }

    public static boolean isKeyword(String value, boolean includeTypeScriptKeywords) {
        return Keywords.get(value, includeTypeScriptKeywords) != null;
    }

    public static boolean isKeyword(TokenType token) {
        return Keywords.get(token) != null;
    }

    public static boolean isTypeScriptSpecificKeyword(TokenType type) {
        switch (type) {
            case DECLARE: 
            case TYPE: 
            case MODULE: 
            case NAMESPACE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStrictKeyword(TokenType token) {
        switch (token) {
            case IMPLEMENTS: 
            case INTERFACE: 
            case LET: 
            case PACKAGE: 
            case PRIVATE: 
            case PROTECTED: 
            case PUBLIC: 
            case STATIC: 
            case YIELD: {
                return true;
            }
        }
        return false;
    }

    public static TokenType getTokenType(String value) {
        return Keywords.KEYWORDS_BY_NAME.get((Object)value).type;
    }

    public static Keywords get(String value, boolean includeTypeScriptKeywords) {
        Keywords k = KEYWORDS_BY_NAME.get(value);
        return k != null && (includeTypeScriptKeywords || !k.isTypeScriptSpecificKeyword) ? k : null;
    }

    public static Keywords get(TokenType token) {
        return KEYWORDS_BY_TYPE.get((Object)token);
    }

    static {
        ImmutableMap.Builder<String, Keywords> keywordsByName = ImmutableMap.builder();
        EnumMap<TokenType, Keywords> keywordsByType = new EnumMap<TokenType, Keywords>(TokenType.class);
        for (Keywords kw : Keywords.values()) {
            keywordsByName.put(kw.value, kw);
            keywordsByType.put(kw.type, kw);
        }
        KEYWORDS_BY_NAME = keywordsByName.build();
        KEYWORDS_BY_TYPE = Maps.immutableEnumMap(keywordsByType);
    }
}

