/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import antlr.Token;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAsNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseAndAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseAndNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseLeftShiftAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseLeftShiftNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseOrAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseOrNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseRightShiftAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseRightShiftNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseUnsignedRightShiftAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseUnsignedRightShiftNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseXorAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorBitwiseXorNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorCommaNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorDivisionAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorDivisionNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorEqualNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorGreaterThanEqualsNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorGreaterThanNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorInNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorInstanceOfNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorIsNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLessThanEqualsNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLessThanNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalAndAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalAndNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalOrAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalOrNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorMinusAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorMinusNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorModuloAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorModuloNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorMultiplicationAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorMultiplicationNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNotEqualNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorPlusAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorPlusNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorStrictEqualNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorStrictNotEqualNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.OperatorNodeBase;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;

public abstract class BinaryOperatorNodeBase
extends OperatorNodeBase
implements IBinaryOperatorNode {
    protected ExpressionNodeBase leftOperandNode;
    protected ExpressionNodeBase rightOperandNode;

    public static BinaryOperatorNodeBase create(IASToken operatorToken, ExpressionNodeBase leftOperand, ExpressionNodeBase rightOperand) {
        switch (operatorToken.getType()) {
            case 53: {
                return new BinaryOperatorAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 108: {
                return new BinaryOperatorPlusNode(operatorToken, leftOperand, rightOperand);
            }
            case 77: {
                return new BinaryOperatorPlusAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 107: {
                return new BinaryOperatorMinusNode(operatorToken, leftOperand, rightOperand);
            }
            case 78: {
                return new BinaryOperatorMinusAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 111: {
                return new BinaryOperatorMultiplicationNode(operatorToken, leftOperand, rightOperand);
            }
            case 79: {
                return new BinaryOperatorMultiplicationAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 109: {
                return new BinaryOperatorDivisionNode(operatorToken, leftOperand, rightOperand);
            }
            case 80: {
                return new BinaryOperatorDivisionAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 110: {
                return new BinaryOperatorModuloNode(operatorToken, leftOperand, rightOperand);
            }
            case 81: {
                return new BinaryOperatorModuloAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 94: {
                return new BinaryOperatorEqualNode(operatorToken, leftOperand, rightOperand);
            }
            case 95: {
                return new BinaryOperatorNotEqualNode(operatorToken, leftOperand, rightOperand);
            }
            case 96: {
                return new BinaryOperatorStrictEqualNode(operatorToken, leftOperand, rightOperand);
            }
            case 97: {
                return new BinaryOperatorStrictNotEqualNode(operatorToken, leftOperand, rightOperand);
            }
            case 99: {
                return new BinaryOperatorLessThanNode(operatorToken, leftOperand, rightOperand);
            }
            case 100: {
                return new BinaryOperatorLessThanEqualsNode(operatorToken, leftOperand, rightOperand);
            }
            case 74: {
                return new BinaryOperatorGreaterThanNode(operatorToken, leftOperand, rightOperand);
            }
            case 98: {
                return new BinaryOperatorGreaterThanEqualsNode(operatorToken, leftOperand, rightOperand);
            }
            case 90: {
                return new BinaryOperatorLogicalAndNode(operatorToken, leftOperand, rightOperand);
            }
            case 75: {
                return new BinaryOperatorLogicalAndAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 89: {
                return new BinaryOperatorLogicalOrNode(operatorToken, leftOperand, rightOperand);
            }
            case 76: {
                return new BinaryOperatorLogicalOrAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 93: {
                return new BinaryOperatorBitwiseAndNode(operatorToken, leftOperand, rightOperand);
            }
            case 82: {
                return new BinaryOperatorBitwiseAndAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 91: {
                return new BinaryOperatorBitwiseOrNode(operatorToken, leftOperand, rightOperand);
            }
            case 83: {
                return new BinaryOperatorBitwiseOrAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 92: {
                return new BinaryOperatorBitwiseXorNode(operatorToken, leftOperand, rightOperand);
            }
            case 84: {
                return new BinaryOperatorBitwiseXorAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 104: {
                return new BinaryOperatorBitwiseLeftShiftNode(operatorToken, leftOperand, rightOperand);
            }
            case 85: {
                return new BinaryOperatorBitwiseLeftShiftAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 105: {
                return new BinaryOperatorBitwiseRightShiftNode(operatorToken, leftOperand, rightOperand);
            }
            case 86: {
                return new BinaryOperatorBitwiseRightShiftAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 106: {
                return new BinaryOperatorBitwiseUnsignedRightShiftNode(operatorToken, leftOperand, rightOperand);
            }
            case 87: {
                return new BinaryOperatorBitwiseUnsignedRightShiftAssignmentNode(operatorToken, leftOperand, rightOperand);
            }
            case 103: {
                return new BinaryOperatorAsNode(operatorToken, leftOperand, rightOperand);
            }
            case 42: {
                return new BinaryOperatorCommaNode(operatorToken, leftOperand, rightOperand);
            }
            case 59: {
                return new BinaryOperatorInNode(operatorToken, leftOperand, rightOperand);
            }
            case 101: {
                return new BinaryOperatorInstanceOfNode(operatorToken, leftOperand, rightOperand);
            }
            case 102: {
                return new BinaryOperatorIsNode(operatorToken, leftOperand, rightOperand);
            }
        }
        assert (false) : "Token '" + operatorToken.getText() + "' unexpected in BinaryOperatorNodeBase.create()";
        return null;
    }

    public BinaryOperatorNodeBase(IASToken op, ExpressionNodeBase left, ExpressionNodeBase right) {
        super(op);
        this.leftOperandNode = left == null ? IdentifierNode.createEmptyIdentifierNodeAfterToken((Token)((Object)op)) : left;
        this.rightOperandNode = right == null ? IdentifierNode.createEmptyIdentifierNodeAfterToken((Token)((Object)op)) : right;
        this.span(this.leftOperandNode, this.rightOperandNode);
    }

    protected BinaryOperatorNodeBase(BinaryOperatorNodeBase other) {
        super(other);
        this.leftOperandNode = other.leftOperandNode != null ? other.leftOperandNode.copy() : null;
        this.rightOperandNode = other.rightOperandNode != null ? other.rightOperandNode.copy() : null;
    }

    @Override
    public int getChildCount() {
        int count = 0;
        if (this.leftOperandNode != null) {
            ++count;
        }
        if (this.rightOperandNode != null) {
            ++count;
        }
        return count;
    }

    @Override
    public IASNode getChild(int i) {
        if (i == 0) {
            return this.leftOperandNode != null ? this.leftOperandNode : this.rightOperandNode;
        }
        if (i == 1) {
            return this.rightOperandNode;
        }
        return null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.leftOperandNode != null) {
            this.leftOperandNode.setParent(this);
        }
        if (this.rightOperandNode != null) {
            this.rightOperandNode.setParent(this);
        }
    }

    @Override
    protected void fillInOffsets() {
        if (this.rightOperandNode == null && this.leftOperandNode == null && this.operatorStart != -1) {
            this.span(this.operatorStart, this.operatorStart + 1, -1, -1, -1, -1);
        } else {
            super.fillInOffsets();
        }
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }

    @Override
    public IOperatorNode.ExpressionType getExpressionType() {
        return IOperatorNode.ExpressionType.BINARY;
    }

    @Override
    public IExpressionNode getLeftOperandNode() {
        return this.leftOperandNode;
    }

    @Override
    public IExpressionNode getRightOperandNode() {
        return this.rightOperandNode;
    }

    public void setLeftOperandNode(ExpressionNodeBase leftOperandNode) {
        this.leftOperandNode = leftOperandNode;
    }

    public void setRightOperandNode(ExpressionNodeBase rightOperandNode) {
        this.rightOperandNode = rightOperandNode;
    }

    public boolean isOperatingOnArray() {
        boolean onArray;
        if (this.leftOperandNode instanceof IDynamicAccessNode || this.rightOperandNode instanceof IDynamicAccessNode) {
            return true;
        }
        if (this.leftOperandNode instanceof IBinaryOperatorNode && (onArray = ((BinaryOperatorNodeBase)this.leftOperandNode).isOperatingOnArray())) {
            return true;
        }
        if (this.rightOperandNode instanceof IBinaryOperatorNode) {
            return ((BinaryOperatorNodeBase)this.rightOperandNode).isOperatingOnArray();
        }
        return false;
    }

    protected ITypeDefinition resolveAssignmentType(ICompilerProject project) {
        return this.getLeftOperandNode().resolveType(project);
    }

    protected ITypeDefinition resolveLogicalType(ICompilerProject project) {
        ITypeDefinition leftType = this.getLeftOperandNode().resolveType(project);
        ITypeDefinition rightType = this.getRightOperandNode().resolveType(project);
        if (leftType != null && leftType.equals(rightType)) {
            return leftType;
        }
        ITypeDefinition commonType = SemanticUtils.resolveCommonType(leftType, rightType, project);
        if (commonType != null) {
            return commonType;
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }
}

