/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.reference;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.internal.codegen.typedefs.DummyNode;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.AbstractCompilerPass;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.BaseReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.FieldReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.MethodReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.NullConstructorReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;
import org.apache.royale.compiler.internal.codegen.typedefs.utils.DebugLogUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.utils.JSTypeUtils;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnresolvedClassReferenceProblem;
import org.apache.royale.compiler.tree.as.IASNode;

public class ClassReference
extends BaseReference {
    private boolean isFinal;
    private boolean isDynamic;
    private boolean callableInstances;
    private String moduleName;
    private int enumConstantCounter = 0;
    private Set<String> imports = new HashSet<String>();
    private MethodReference constructor;
    private Map<String, FieldReference> instanceFields = new HashMap<String, FieldReference>();
    private Map<String, FieldReference> staticFields = new HashMap<String, FieldReference>();
    private Map<String, MethodReference> instanceMethods = new HashMap<String, MethodReference>();
    private Map<String, MethodReference> staticMethods = new HashMap<String, MethodReference>();
    private Node nameNode;
    private Node functionNode;
    private Node paramListNode;
    private boolean isNamespace;
    private static List<String> definedPackages = new ArrayList<String>();

    public final int getEnumConstant() {
        return this.enumConstantCounter;
    }

    public final void nextEnumConstant() {
        ++this.enumConstantCounter;
    }

    public void setIsNamespace(boolean isNamespace) {
        this.isNamespace = isNamespace;
    }

    public boolean isNamespace() {
        return this.isNamespace;
    }

    public MethodReference getConstructor() {
        return this.constructor;
    }

    public ArrayList<FieldReference> getAllFields() {
        ArrayList<FieldReference> allMethods = new ArrayList<FieldReference>();
        if (!this.isInterface()) {
            allMethods.addAll(this.staticFields.values());
        }
        allMethods.addAll(this.instanceFields.values());
        Collections.sort(allMethods);
        return allMethods;
    }

    public ArrayList<MethodReference> getAllMethods() {
        ArrayList<MethodReference> allMethods = new ArrayList<MethodReference>();
        if (!this.isInterface()) {
            allMethods.addAll(this.staticMethods.values());
        }
        allMethods.addAll(this.instanceMethods.values());
        Collections.sort(allMethods);
        return allMethods;
    }

    public FieldReference getStaticField(String name) {
        return this.staticFields.get(name);
    }

    public FieldReference getInstanceField(String name) {
        return this.instanceFields.get(name);
    }

    public MethodReference getStaticMethod(String name) {
        return this.staticMethods.get(name);
    }

    public MethodReference getInstanceMethod(String name) {
        return this.instanceMethods.get(name);
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public boolean hasCallableInstances() {
        return this.callableInstances;
    }

    public void setCallableInstances(boolean callableInstances) {
        this.callableInstances = callableInstances;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public final boolean isInterface() {
        return this.getComment().isInterface();
    }

    public ClassReference(ReferenceModel model, Node node, String qualifiedName) {
        super(model, node, qualifiedName, node.getJSDocInfo());
        this.indent = "";
        this.nameNode = null;
        this.functionNode = null;
        this.paramListNode = null;
        if (this.comment.hasEnumParameterType()) {
            String overrideStringType = JSTypeUtils.toEnumTypeString(this);
            Node objLit = null;
            if (node.isVar()) {
                objLit = node.getFirstChild().getFirstChild();
            } else if (node.isAssign()) {
                objLit = node.getLastChild();
            }
            if (objLit != null) {
                for (Node stringKey : objLit.children()) {
                    if (!stringKey.isStringKey()) continue;
                    Node valueNode = stringKey.getFirstChild();
                    JSDocInfoBuilder b = new JSDocInfoBuilder(true);
                    JSDocInfo fieldComment = b.build();
                    String fieldName = stringKey.getString();
                    FieldReference field = this.addField(stringKey, fieldName, fieldComment, true);
                    field.setConst(true);
                    field.setOverrideStringType(overrideStringType);
                    field.setConstantValueNode(valueNode);
                }
            }
        } else if (this.comment.getTypedefType() != null) {
            ObjectType typeDefObjectType;
            JSTypeExpression typeDefType = this.comment.getTypedefType();
            JSType typeDefJSType = model.evaluate(typeDefType);
            if (typeDefJSType != null && (typeDefObjectType = typeDefJSType.toObjectType()) != null) {
                Map properties = typeDefObjectType.getPropertyTypeMap();
                for (Map.Entry property : properties.entrySet()) {
                    JSDocInfoBuilder b = new JSDocInfoBuilder(true);
                    b.recordBlockDescription("Generated doc for missing field JSDoc.");
                    JSDocInfo fieldComment = b.build();
                    this.addField(node, (String)property.getKey(), fieldComment, false);
                }
            }
        } else if (this.comment.isConstant()) {
            this.constructor = new NullConstructorReference(model, this, node, this.getBaseName(), this.comment);
        } else if (node.isFunction()) {
            this.nameNode = node.getChildAtIndex(0);
            this.functionNode = node;
            this.paramListNode = this.functionNode.getChildAtIndex(1);
        } else if (node.isVar()) {
            this.nameNode = node.getChildAtIndex(0);
            this.functionNode = this.nameNode.getChildAtIndex(0);
            try {
                this.paramListNode = this.functionNode.getChildAtIndex(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (node.isAssign() && node.getChildAtIndex(1).isFunction()) {
            this.nameNode = node.getFirstChild();
            this.functionNode = node.getLastChild();
            this.paramListNode = this.functionNode.getChildAtIndex(1);
        }
        if (this.functionNode != null) {
            this.constructor = new MethodReference(model, this, this.functionNode, this.getBaseName(), this.comment, false);
        }
        this.moduleName = model.getConfiguration().isNamedModule(this);
    }

    @Override
    public void emit(StringBuilder sb) {
        this.enumConstantCounter = 0;
        String packageName = this.getPackageName();
        if (this.outputJS) {
            sb.append("/** @fileoverview Auto-generated Externs files\n * @externs\n */\n");
            if (!packageName.isEmpty() && !definedPackages.contains(packageName)) {
                definedPackages.add(packageName);
                String[] pieces = packageName.split("\\.");
                Object chain = "";
                for (String piece : pieces) {
                    sb.append("\n");
                    sb.append("\n");
                    sb.append("/**\n * @const\n * @suppress {duplicate|const} */\n");
                    if (((String)chain).isEmpty()) {
                        sb.append("var " + piece + " = {};\n\n\n");
                    } else {
                        sb.append((String)chain + "." + piece + " = {}\n\n\n");
                    }
                    chain = (String)chain + "." + piece;
                }
            }
        } else {
            sb.append("package ");
            if (!packageName.equals("")) {
                sb.append(packageName).append(" ");
            }
            sb.append("{\n");
            sb.append("\n");
            this.emitImports(sb);
        }
        if (this.moduleName != null) {
            sb.append("[JSModule");
            if (packageName.length() > 0 || !this.getBaseName().equals(this.moduleName)) {
                sb.append("(");
                sb.append("name=\"");
                sb.append(this.moduleName);
                sb.append("\"");
                sb.append(")");
            }
            sb.append("]");
            sb.append("\n");
        }
        if (this.callableInstances) {
            sb.append(this.indent);
            sb.append("[RoyaleCallableInstances]\n");
        }
        this.emitComment(sb);
        boolean isInterface = this.isInterface();
        if (isInterface) {
            this.emitInterface(sb);
        } else {
            this.emitClass(sb);
        }
        if (!this.outputJS) {
            sb.append("{\n");
            sb.append("\n");
        }
        if (!isInterface) {
            this.emitConstructor(sb);
            sb.append("\n");
        }
        this.emitFields(sb);
        this.emitMethods(sb);
        if (!this.outputJS) {
            sb.append("}\n");
            sb.append("}\n");
        }
    }

    public boolean hasSuperField(String fieldName) {
        List<ClassReference> list = this.getSuperClasses();
        for (ClassReference reference : list) {
            if (!reference.hasInstanceField(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSuperMethod(String methodName) {
        List<ClassReference> list = this.getSuperClasses();
        for (ClassReference reference : list) {
            if (!reference.hasInstanceMethod(methodName)) continue;
            return true;
        }
        return false;
    }

    public MethodReference getSuperMethod(String methodName) {
        List<ClassReference> list = this.getSuperClasses();
        for (ClassReference reference : list) {
            if (!reference.hasInstanceMethod(methodName)) continue;
            return reference.getInstanceMethod(methodName);
        }
        list = this.getAllImplInterfaces();
        for (ClassReference reference : list) {
            if (!reference.hasInstanceMethod(methodName)) continue;
            return reference.getInstanceMethod(methodName);
        }
        return null;
    }

    public List<ClassReference> getSuperClasses() {
        ArrayList<ClassReference> result = new ArrayList<ClassReference>();
        if (this.isInterface()) {
            return this.getExtendedInterfaces();
        }
        for (ClassReference superClass = this.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
            result.add(superClass);
        }
        return result;
    }

    public List<ClassReference> getAllImplInterfaces() {
        ArrayList<ClassReference> result = new ArrayList<ClassReference>();
        for (JSTypeExpression jsTypeExpression : this.getComment().getImplementedInterfaces()) {
            String interfaceName = this.getModel().evaluate(jsTypeExpression).getDisplayName();
            ClassReference classReference = this.getModel().getClassReference(interfaceName);
            if (classReference == null) continue;
            result.add(classReference);
        }
        Collections.sort(result);
        return result;
    }

    public List<ClassReference> getImplementedInterfaces() {
        ArrayList<ClassReference> result = new ArrayList<ClassReference>();
        for (JSTypeExpression jsTypeExpression : this.getComment().getImplementedInterfaces()) {
            String interfaceName = this.getModel().evaluate(jsTypeExpression).getDisplayName();
            ClassReference reference = this.getModel().getClassReference(interfaceName);
            if (reference == null) continue;
            result.add(reference);
        }
        Collections.sort(result);
        return result;
    }

    public List<ClassReference> getExtendedInterfaces() {
        ArrayList<ClassReference> result = new ArrayList<ClassReference>();
        for (JSTypeExpression jsTypeExpression : this.getComment().getExtendedInterfaces()) {
            String interfaceName = this.getModel().evaluate(jsTypeExpression).getDisplayName();
            ClassReference reference = this.getModel().getClassReference(interfaceName);
            if (reference == null) continue;
            result.add(reference);
        }
        Collections.sort(result);
        return result;
    }

    public List<ClassReference> getInterfaces() {
        ArrayList<ClassReference> result = new ArrayList<ClassReference>();
        List implementedInterfaces = this.getComment().getImplementedInterfaces();
        for (JSTypeExpression jsTypeExpression : implementedInterfaces) {
            JSType jsType = this.getModel().evaluate(jsTypeExpression);
            if (jsType.isTemplatizedType()) {
                jsType = ((TemplatizedType)jsType).getReferencedType();
            }
            String interfaceName = jsType.getDisplayName();
            ClassReference interfaceReference = this.getModel().getClassReference(interfaceName);
            if (interfaceReference != null) {
                result.add(interfaceReference);
                continue;
            }
            DummyNode node = new DummyNode();
            String externName = AbstractCompilerPass.getSourceFileName(this.getNode().getStaticSourceFile().getName(), this.getModel());
            node.setSourcePath(externName);
            node.setLine(this.getNode().getLineno());
            UnresolvedClassReferenceProblem problem = new UnresolvedClassReferenceProblem((IASNode)node, interfaceName);
            this.getModel().problems.add((ICompilerProblem)problem);
        }
        Collections.sort(result);
        return result;
    }

    public List<ClassReference> getSuperInterfaces() {
        ArrayList<ClassReference> result = new ArrayList<ClassReference>();
        result.addAll(this.getInterfaces());
        for (ClassReference superClass = this.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
            result.addAll(superClass.getInterfaces());
        }
        Collections.sort(result);
        return result;
    }

    public boolean hasInstanceField(String fieldName) {
        return this.instanceFields.containsKey(fieldName);
    }

    public boolean hasStaticField(String fieldName) {
        return this.staticFields.containsKey(fieldName);
    }

    public boolean hasInstanceMethod(String fieldName) {
        return this.instanceMethods.containsKey(fieldName);
    }

    public boolean hasStaticMethod(String fieldName) {
        return this.staticMethods.containsKey(fieldName);
    }

    public FieldReference addField(Node node, String fieldName, JSDocInfo comment, boolean isStatic) {
        if (isStatic ? this.hasStaticField(fieldName) : this.hasInstanceField(fieldName)) {
            return null;
        }
        if (comment == null) {
            DebugLogUtils.err("Field comment null for; " + node.getQualifiedName());
            JSDocInfoBuilder b = new JSDocInfoBuilder(true);
            b.recordBlockDescription("Generated doc for missing field JSDoc.");
            comment = b.build();
        }
        FieldReference field = new FieldReference(this.getModel(), this, node, fieldName, comment, isStatic);
        if (isStatic) {
            this.staticFields.put(fieldName, field);
        } else {
            this.instanceFields.put(fieldName, field);
        }
        return field;
    }

    public MethodReference addMethod(Node node, String functionName, JSDocInfo comment, boolean isStatic) {
        if (comment == null) {
            DebugLogUtils.err("Method comment null for; " + node.getQualifiedName());
            JSDocInfoBuilder b = new JSDocInfoBuilder(true);
            b.recordBlockDescription("Generated doc for missing method JSDoc.");
            comment = b.build();
        }
        MethodReference method = new MethodReference(this.getModel(), this, node, functionName, comment, isStatic);
        if (isStatic) {
            this.staticMethods.put(functionName, method);
        } else if (!(this.getQualifiedName().equals("Object") && functionName.equals("toString") || this.getQualifiedName().equals("Object") && functionName.equals("toJSON"))) {
            this.instanceMethods.put(functionName, method);
        }
        return method;
    }

    public boolean isMethodOverrideFromInterface(MethodReference reference) {
        boolean isMethodOverrideFromInterface = false;
        if (!this.hasImplementations()) {
            List implementedInterfaces = this.getComment().getImplementedInterfaces();
            for (JSTypeExpression jsTypeExpression : implementedInterfaces) {
                String interfaceName = this.getModel().evaluate(jsTypeExpression).getDisplayName();
                ClassReference classReference = this.getModel().getClassReference(interfaceName);
                if (!classReference.hasSuperMethod(reference.getQualifiedName())) continue;
                isMethodOverrideFromInterface = true;
                break;
            }
        }
        return isMethodOverrideFromInterface;
    }

    public MethodReference getMethodOverrideFromInterface(MethodReference reference) {
        List<ClassReference> superClasses = this.getSuperClasses();
        superClasses.add(0, this);
        Collections.reverse(superClasses);
        for (ClassReference classReference : superClasses) {
            List<ClassReference> interfaces = classReference.getImplementedInterfaces();
            for (ClassReference interfaceReference : interfaces) {
                MethodReference method = interfaceReference.getInstanceMethod(reference.getBaseName());
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    public ClassReference getSuperClass() {
        if (this.getBaseName().equals("Object")) {
            return null;
        }
        JSTypeExpression baseType = this.getComment().getBaseType();
        if (baseType != null) {
            JSType jsType = this.getModel().evaluate(baseType);
            if (jsType != null) {
                return this.getModel().getClassReference(jsType.getDisplayName());
            }
        } else {
            return this.getModel().getObjectReference();
        }
        return null;
    }

    public boolean hasSuperFieldConflict(FieldReference reference) {
        return false;
    }

    public boolean isPropertyInterfaceImplementation(String fieldName) {
        List<ClassReference> superInterfaces = this.getSuperInterfaces();
        for (ClassReference interfaceRef : superInterfaces) {
            if (interfaceRef == null) {
                System.err.println("isPropertyInterfaceImplementation() null");
                continue;
            }
            if (!interfaceRef.hasInstanceField(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalMethodConflict(String functionName) {
        return this.instanceMethods.containsKey(functionName) || this.staticMethods.containsKey(functionName);
    }

    public void addImport(ClassReference reference) {
        if (reference != null) {
            this.imports.add(reference.getQualifiedName());
        }
    }

    public boolean hasImport(String qualifiedName) {
        return this.imports.contains(qualifiedName);
    }

    private boolean hasImplementations() {
        return this.getComment().getImplementedInterfaceCount() > 0;
    }

    private void emitImports(StringBuilder sb) {
        if (this.imports.size() > 0) {
            for (String anImport : this.imports) {
                sb.append("import ").append(anImport).append(";\n");
            }
            sb.append("\n");
        }
    }

    @Override
    protected void emitCommentBody(StringBuilder sb) {
        super.emitCommentBody(sb);
        super.emitParams(sb);
        if (this.isInterface()) {
            sb.append(" * @interface\n");
        } else {
            sb.append(" * @constructor\n");
        }
        if (this.getComment().hasBaseType()) {
            sb.append(" * @");
            this.emitSuperClass(sb);
            sb.append("\n");
        }
        if (!this.isInterface()) {
            if (!this.outputJS) {
                sb.append(" * @");
            }
            this.emitImplements(sb);
            sb.append("\n");
            List implementedInterfaces = this.getComment().getImplementedInterfaces();
            int len = implementedInterfaces.size();
            if (len != 0) {
                for (int i = 0; i < len; ++i) {
                    int c2;
                    int c;
                    String value = this.getModel().evaluate((JSTypeExpression)implementedInterfaces.get(i)).getDisplayName();
                    if (!value.equals("IArrayLike")) continue;
                    String comment = this.getComment().getOriginalCommentString();
                    int c1 = comment.indexOf(60, c = comment.indexOf("IArrayLike"));
                    if (c1 != c + 10 || (c2 = comment.indexOf(62, c1)) == -1) break;
                    String type = comment.substring(c1 + 1, c2);
                    int insert = sb.toString().indexOf("\n");
                    sb.insert(insert + 1, "\n[ArrayElementType(\"" + JSTypeUtils.transformType(type) + "\")]\n");
                    break;
                }
            }
        }
    }

    private void emitClass(StringBuilder sb) {
        if (this.outputJS) {
            return;
        }
        sb.append("public ");
        if (this.isDynamic) {
            sb.append("dynamic ");
        }
        if (this.isFinal) {
            sb.append("final ");
        }
        sb.append("class ");
        sb.append(this.getBaseName()).append(" ");
        if (this.getComment().hasBaseType()) {
            this.emitSuperClass(sb);
            sb.append(" ");
        }
        if (!this.isInterface()) {
            this.emitImplements(sb);
        }
    }

    private void emitInterface(StringBuilder sb) {
        sb.append("public interface ");
        sb.append(this.getBaseName()).append(" ");
        List extendedInterfaces = this.getComment().getExtendedInterfaces();
        int len = extendedInterfaces.size();
        if (len > 0) {
            sb.append("extends ");
            for (JSTypeExpression jsTypeExpression : extendedInterfaces) {
                String value = this.getModel().evaluate(jsTypeExpression).toString();
                sb.append(value);
                if (--len <= 0) continue;
                sb.append(", ");
            }
            sb.append(" ");
        }
    }

    private void emitSuperClass(StringBuilder sb) {
        if (this.outputJS) {
            sb.append("extends ");
            String value = JSTypeUtils.toClassTypeString(this);
            sb.append(value);
            sb.append("\n");
        } else {
            sb.append("extends ");
            String value = JSTypeUtils.toClassTypeString(this);
            sb.append(value);
        }
    }

    private void emitImplements(StringBuilder sb) {
        List implementedInterfaces = this.getComment().getImplementedInterfaces();
        if (implementedInterfaces.size() == 0) {
            return;
        }
        if (this.outputJS) {
            sb.append(" * @implements ");
        } else {
            sb.append("implements ");
        }
        int len = implementedInterfaces.size();
        for (int i = 0; i < len; ++i) {
            String value = this.getModel().evaluate((JSTypeExpression)implementedInterfaces.get(i)).getDisplayName();
            sb.append(value);
            if (this.outputJS) {
                if (i < len - 1) {
                    sb.append("\n * @implements ");
                    continue;
                }
                sb.append("\n");
                continue;
            }
            if (i >= len - 1) continue;
            sb.append(", ");
        }
        sb.append(" ");
    }

    private void emitConstructor(StringBuilder sb) {
        if (this.constructor != null) {
            this.constructor.emit(sb);
        }
    }

    private void emitFields(StringBuilder sb) {
        for (FieldReference field : this.getAllFields()) {
            field.emit(sb);
            sb.append("\n");
            this.nextEnumConstant();
        }
    }

    private void emitMethods(StringBuilder sb) {
        for (MethodReference method : this.getAllMethods()) {
            method.emit(sb);
            sb.append("\n");
        }
    }

    public File getFile(File asSourceRoot) {
        File jsRoot = this.getModel().getConfiguration().getJsRoot();
        if (jsRoot == null) {
            String packagePath = this.toPackagePath();
            return new File(asSourceRoot, packagePath + File.separator + this.getBaseName() + ".as");
        }
        return new File(jsRoot, this.getBaseName() + ".js");
    }

    private String toPackagePath() {
        String packageName = this.getPackageName();
        String[] cname = packageName.split("\\.");
        Object sdirPath = "";
        if (cname.length > 0) {
            for (String aCname : cname) {
                sdirPath = (String)sdirPath + aCname + File.separator;
            }
            return sdirPath;
        }
        return "";
    }
}

