/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

class ListenerCollection<EventType> {
    private final HashMap<EventType, List<Consumer<?>>> listeners = new HashMap();

    ListenerCollection() {
    }

    <T> void notify(EventType eventType, T param) {
        List<Consumer<?>> list = this.listeners.get(eventType);
        if (list == null) {
            return;
        }
        for (Consumer<?> listener : new ArrayList(list)) {
            listener.accept(param);
        }
    }

    void add(EventType type, Consumer<?> listener) {
        List<Consumer<?>> list = this.listeners.get(type);
        if (list == null) {
            list = new ArrayList();
            this.listeners.put(type, list);
        }
        list.add(listener);
    }

    void remove(EventType type, Consumer<?> listener) {
        List<Consumer<Consumer<?>>> list = this.listeners.get(type);
        if (list == null) {
            return;
        }
        list.removeAll(Collections.singleton(listener));
        if (list.isEmpty()) {
            this.listeners.remove(type);
        }
    }

    boolean hasListeners(EventType type) {
        return this.listeners.containsKey(type);
    }
}

