/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.utils;

import java.util.List;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.tree.as.XMLLiteralNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IScopedNode;

public class JSXUtil {
    public static boolean hasJSXMetadata(IFunctionNode node) {
        for (IMetaInfo metaInfo : node.getMetaInfos()) {
            if (!metaInfo.getTagName().equals("JSX")) continue;
            return true;
        }
        return false;
    }

    public static void findQualifiedNamesInXMLLiteral(XMLLiteralNode node, ICompilerProject project, List<String> qualifiedNames) {
        int childCount = node.getContentsNode().getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ILiteralNode literalChild;
            IASNode child = node.getContentsNode().getChild(i);
            if (!(child instanceof ILiteralNode) || (literalChild = (ILiteralNode)child).getLiteralType() != ILiteralNode.LiteralType.XML) continue;
            JSXUtil.findQualifiedNamesInXMLLiteralChild(literalChild, project, qualifiedNames);
        }
    }

    private static void findQualifiedNamesInXMLLiteralChild(ILiteralNode node, ICompilerProject project, List<String> qualifiedNames) {
        int index;
        String value = node.getValue();
        while ((index = value.indexOf("<")) != -1) {
            String qualifiedElementName;
            String elementName;
            value = value.substring(index + 1);
            index = value.indexOf(">");
            int nextWhitespaceIndex = -1;
            int count = value.length();
            for (int i = 0; i < count; ++i) {
                char charAt = value.charAt(i);
                if (charAt != ' ' && charAt != '\t' && charAt != '\r' && charAt != '\n') continue;
                nextWhitespaceIndex = i;
                break;
            }
            if (nextWhitespaceIndex == -1) {
                nextWhitespaceIndex = value.length();
            }
            if (index == -1 || index > nextWhitespaceIndex) {
                index = nextWhitespaceIndex;
            }
            if ((elementName = value.substring(0, index)).endsWith("/")) {
                elementName = elementName.substring(0, elementName.length() - 1);
            }
            if (!elementName.startsWith("/") && (qualifiedElementName = JSXUtil.getQualifiedTypeForElementName(elementName, node, project)) != null) {
                qualifiedNames.add(qualifiedElementName);
            }
            value = value.substring(index + 1);
        }
    }

    public static String getQualifiedTypeForElementName(String elementName, IASNode node, ICompilerProject project) {
        ASScope asScope;
        IDefinition definition;
        String firstChar = elementName.substring(0, 1);
        boolean isHTMLTag = firstChar.toLowerCase().equals(firstChar);
        if (isHTMLTag) {
            return null;
        }
        IScopedNode scopedNode = node.getContainingScope();
        IASScope scope = scopedNode.getScope();
        if (scope instanceof ASScope && (definition = (asScope = (ASScope)scope).findProperty(project, elementName, DependencyType.EXPRESSION)) != null) {
            return definition.getQualifiedName();
        }
        return elementName;
    }
}

