/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.utils;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerMapFetcher;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.RoyaleClosurePassConfig;
import com.google.javascript.jscomp.RoyaleDiagnosticGroups;
import com.google.javascript.jscomp.ShowByPathWarningsGuard;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.WarningsGuard;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class JSClosureCompilerWrapper {
    private Compiler compiler_;
    private CompilerOptions options_;
    private List<SourceFile> jsExternsFiles_;
    private List<SourceFile> jsSourceFiles_;
    private String variableMapOutputPath;
    private String propertyMapOutputPath;
    private String variableMapInputPath;
    private String propertyMapInputPath;
    private Set<String> propertyNamesToKeep;
    private Set<String> extraSymbolNamesToExport;
    private boolean skipTypeInference;
    private boolean sourceMap = false;
    private boolean verbose = false;
    private boolean preventRenameMxmlSymbolReferences = true;
    public String targetFilePath;

    public JSClosureCompilerWrapper(List<String> args) throws IOException {
        Compiler.setLoggingLevel((Level)Level.INFO);
        this.compiler_ = new Compiler();
        this.jsSourceFiles_ = new ArrayList<SourceFile>();
        this.jsExternsFiles_ = new ArrayList<SourceFile>();
        this.filterOptions(args);
        ArrayList<String> splitArgs = new ArrayList<String>();
        for (String s : args) {
            if (s.contains(" ")) {
                String[] parts = s.split(" ");
                Collections.addAll(splitArgs, parts);
                continue;
            }
            splitArgs.add(s);
        }
        String[] stringArgs = new String[splitArgs.size()];
        splitArgs.toArray(stringArgs);
        this.options_ = new CompilerOptionsParser(stringArgs).getOptions();
        this.initOptions(args);
        this.initExterns();
    }

    public void addJSExternsFile(String fileName) {
        this.addJSExternsFile(SourceFile.fromFile((String)fileName));
    }

    public void addJSExternsFile(SourceFile file) {
        this.jsExternsFiles_.add(file);
    }

    public void addJSSourceFile(String fileName) {
        this.addJSSourceFile(SourceFile.fromFile((String)fileName));
    }

    public void addJSSourceFile(SourceFile file) {
        this.jsSourceFiles_.add(file);
    }

    public void setSourceMap(boolean enabled) {
        this.sourceMap = enabled;
    }

    public void setVerbose(boolean enabled) {
        this.verbose = enabled;
    }

    public void setPreventRenameMxmlSymbolReferences(boolean enabled) {
        this.preventRenameMxmlSymbolReferences = enabled;
    }

    public void setPropertyNamesToKeep(Set<String> propertyNames) {
        this.propertyNamesToKeep = propertyNames;
    }

    public void setExtraSymbolNamesToExport(Set<String> names) {
        this.extraSymbolNamesToExport = names;
    }

    public boolean compile() {
        VariableMap map;
        File outputFile;
        VariableMap map2;
        File inputFile;
        if (this.verbose) {
            System.out.println("list of source files");
            for (SourceFile file : this.jsSourceFiles_) {
                System.out.println(file.getName());
            }
            System.out.println("end of list of source files");
        }
        File outputFolder = new File(this.targetFilePath).getParentFile();
        if (this.variableMapInputPath != null) {
            inputFile = new File(outputFolder, this.variableMapInputPath);
            try {
                map2 = VariableMap.load((String)inputFile.getAbsolutePath());
                CompilerMapFetcher.setVariableMap(this.options_, map2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.propertyMapInputPath != null) {
            inputFile = new File(outputFolder, this.propertyMapInputPath);
            try {
                map2 = VariableMap.load((String)inputFile.getAbsolutePath());
                CompilerMapFetcher.setPropertyMap(this.options_, map2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.compiler_.setPassConfig((PassConfig)new RoyaleClosurePassConfig(this.options_, this.jsSourceFiles_.get(this.jsSourceFiles_.size() - 1).getName(), this.variableMapInputPath == null ? null : new File(outputFolder, this.variableMapInputPath), this.propertyNamesToKeep, this.extraSymbolNamesToExport, this.preventRenameMxmlSymbolReferences));
        Result result = this.compiler_.compile(this.jsExternsFiles_, this.jsSourceFiles_, this.options_);
        try {
            FileWriter targetFile = new FileWriter(this.targetFilePath);
            targetFile.write(this.compiler_.toSource());
            targetFile.close();
            if (this.sourceMap) {
                FileWriter sourceMapFile = new FileWriter(this.options_.sourceMapOutputPath);
                this.compiler_.getSourceMap().appendTo((Appendable)sourceMapFile, "");
                sourceMapFile.close();
            }
        }
        catch (IOException error) {
            System.out.println(error);
        }
        if (this.variableMapOutputPath != null) {
            outputFile = new File(outputFolder, this.variableMapOutputPath);
            map = CompilerMapFetcher.getVariableMap(this.compiler_);
            if (map != null) {
                try {
                    map.save(outputFile.getAbsolutePath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.propertyMapOutputPath != null) {
            outputFile = new File(outputFolder, this.propertyMapOutputPath);
            map = CompilerMapFetcher.getPropertyMap(this.compiler_);
            if (map != null) {
                try {
                    map.save(outputFile.getAbsolutePath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result.success;
    }

    private void initExterns() {
        try {
            List defaultExterns = CommandLineRunner.getDefaultExterns();
            for (SourceFile defaultExtern : defaultExterns) {
                this.addJSExternsFile(defaultExtern);
            }
        }
        catch (IOException error) {
            System.out.println(error);
        }
    }

    private void filterOptions(List<String> args) {
        String SKIP_TYPE_INFERENCE = "--skip_type_inference";
        String PROPERTY_MAP = "--property_map_output_file ";
        String VARIABLE_MAP = "--variable_map_output_file ";
        String PROPERTY_INPUT_MAP = "--property_map_input_file ";
        String VARIABLE_INPUT_MAP = "--variable_map_input_file ";
        String EXTERNS = "--externs ";
        String propEntry = null;
        String varEntry = null;
        String skipEntry = null;
        String propInputEntry = null;
        String varInputEntry = null;
        ArrayList<String> removeArgs = new ArrayList<String>();
        for (String s : args) {
            if (s.startsWith("--property_map_output_file ")) {
                propEntry = s;
                this.propertyMapOutputPath = s.substring("--property_map_output_file ".length());
            }
            if (s.startsWith("--property_map_input_file ")) {
                propInputEntry = s;
                this.propertyMapInputPath = s.substring("--property_map_input_file ".length());
            }
            if (s.startsWith("--variable_map_output_file ")) {
                varEntry = s;
                this.variableMapOutputPath = s.substring("--variable_map_output_file ".length());
            }
            if (s.startsWith("--variable_map_input_file ")) {
                varInputEntry = s;
                this.variableMapInputPath = s.substring("--variable_map_input_file ".length());
            }
            if (s.equals("--skip_type_inference")) {
                skipEntry = s;
                this.skipTypeInference = true;
            }
            if (!s.startsWith("--externs ")) continue;
            String fileName = s.substring("--externs ".length());
            this.addJSExternsFile(fileName);
            removeArgs.add(s);
        }
        if (varEntry != null) {
            args.remove(varEntry);
        }
        if (propEntry != null) {
            args.remove(propEntry);
        }
        if (varInputEntry != null) {
            args.remove(varInputEntry);
        }
        if (propInputEntry != null) {
            args.remove(propInputEntry);
        }
        if (skipEntry != null) {
            args.remove(skipEntry);
        }
        for (String s : removeArgs) {
            args.remove(s);
        }
    }

    private void initOptions(List<String> args) {
        String JS_FLAG = "--js ";
        String PROPERTY_MAP = "--property_map_output_file ";
        String VARIABLE_MAP = "--variable_map_output_file ";
        String propEntry = null;
        String varEntry = null;
        boolean hasCompilationLevel = false;
        boolean hasWarningLevel = false;
        for (String s : args) {
            if (s.startsWith("--js ")) {
                this.addJSSourceFile(s.substring("--js ".length()));
            }
            if (s.startsWith("--compilation_level ") || s.startsWith("-O ")) {
                hasCompilationLevel = true;
            }
            if (s.startsWith("--warning_level ") || s.startsWith("-W ")) {
                hasWarningLevel = true;
            }
            if (s.startsWith("--property_map_output_file ")) {
                propEntry = s;
                this.propertyMapOutputPath = s.substring("--property_map_output_file ".length());
            }
            if (!s.startsWith("--variable_map_output_file ")) continue;
            varEntry = s;
            this.variableMapOutputPath = s.substring("--variable_map_output_file ".length());
        }
        if (varEntry != null) {
            args.remove(varEntry);
        }
        if (propEntry != null) {
            args.remove(propEntry);
        }
        if (!hasCompilationLevel) {
            CompilationLevel.ADVANCED_OPTIMIZATIONS.setOptionsForCompilationLevel(this.options_);
        }
        if (!hasWarningLevel) {
            WarningLevel.VERBOSE.setOptionsForWarningLevel(this.options_);
        }
        String[] asdocTags = new String[]{"productversion", "playerversion", "langversion", "copy", "span", "para", "throw", "tiptext", "asparam", "asreturn", "asreturns", "asprivate", "royaleignoreimport", "royaleignorecoercion", "royaleemitcoercion", "royalesuppresscompleximplicitcoercion", "royalesuppressresolveuncertain", "royalesuppressvectorindexcheck", "royalesuppressexport", "royalesuppressclosure", "royalenoimplicitstringconversion", "royaledebug"};
        this.options_.setExtraAnnotationNames(Arrays.asList(asdocTags));
    }

    public void setOptions(String sourceMapPath, boolean useStrictPublishing, boolean manageDependencies, String projectName) {
        if (useStrictPublishing) {
            this.options_.setDefineToBooleanLiteral("goog.DEBUG", false);
            this.options_.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT);
            this.options_.setPreferSingleQuotes(true);
            this.options_.setFoldConstants(true);
            this.options_.setDeadAssignmentElimination(true);
            this.options_.setInlineConstantVars(true);
            this.options_.setInlineFunctions(true);
            this.options_.setInlineLocalVariables(true);
            this.options_.setCrossChunkCodeMotion(true);
            this.options_.setCoalesceVariableNames(true);
            this.options_.setCrossChunkMethodMotion(true);
            this.options_.setInlineProperties(false);
            this.options_.setInlineVariables(true);
            this.options_.setSmartNameRemoval(true);
            this.options_.setRemoveDeadCode(true);
            this.options_.setExtractPrototypeMemberDeclarations(true);
            this.options_.setRemoveUnusedPrototypeProperties(true);
            this.options_.setRemoveUnusedPrototypePropertiesInExterns(false);
            this.options_.setRemoveUnusedClassProperties(true);
            this.options_.setRemoveUnusedVariables(CompilerOptions.Reach.ALL);
            this.options_.setCollapseVariableDeclarations(true);
            this.options_.setCollapseAnonymousFunctions(true);
            this.options_.setAliasAllStrings(true);
            this.options_.setConvertToDottedProperties(true);
            this.options_.setRewriteFunctionExpressions(true);
            this.options_.setOptimizeCalls(true);
            this.options_.setOptimizeArgumentsArray(true);
            this.options_.setGenerateExports(true);
            this.options_.setExportLocalPropertyDefinitions(true);
            this.options_.addWarningsGuard((WarningsGuard)new ShowByPathWarningsGuard(new String[]{"goog/", "externs/svg.js"}, ShowByPathWarningsGuard.ShowType.EXCLUDE));
            ArrayList<String> entryPoints = new ArrayList<String>();
            if (manageDependencies) {
                entryPoints.add(projectName);
            }
            this.options_.setDependencyOptions(DependencyOptions.fromFlags((DependencyOptions.DependencyMode)(manageDependencies ? DependencyOptions.DependencyMode.PRUNE_LEGACY : DependencyOptions.DependencyMode.NONE), entryPoints, new ArrayList(), null, (boolean)manageDependencies, (boolean)false));
            this.options_.setWarningLevel(DiagnosticGroups.ACCESS_CONTROLS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CONST, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CONSTANT_PROPERTY, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.STRICT_MODULE_DEP_CHECK, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.VISIBILITY, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DEPRECATED, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.AMBIGUOUS_FUNCTION_DECL, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_EVENTFUL_OBJECT_DISPOSAL, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_PROVIDE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_REGEXP, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_TYPES, this.skipTypeInference ? CheckLevel.OFF : CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_USELESS_CODE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DUPLICATE_MESSAGE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DUPLICATE_VARS, this.skipTypeInference ? CheckLevel.OFF : CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.ES3, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.EXTERNS_VALIDATION, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.GLOBAL_THIS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.FILEOVERVIEW_JSDOC, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.INTERNET_EXPLORER_CHECKS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.INVALID_CASTS, this.skipTypeInference ? CheckLevel.OFF : CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.LINT_CHECKS, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.MISPLACED_TYPE_ANNOTATION, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_PROPERTIES, this.skipTypeInference ? CheckLevel.OFF : CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_PROVIDE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_REQUIRE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_RETURN, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.NEW_CHECK_TYPES, this.skipTypeInference ? CheckLevel.OFF : CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.REPORT_UNKNOWN_TYPES, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.SUSPICIOUS_CODE, this.skipTypeInference ? CheckLevel.OFF : CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.TWEAKS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.TYPE_INVALIDATION, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNDEFINED_NAMES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNDEFINED_VARIABLES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNKNOWN_DEFINES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.USE_OF_GOOG_BASE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.VIOLATED_MODULE_DEP, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DEPRECATED_ANNOTATIONS, CheckLevel.OFF);
            this.options_.setWarningLevel(RoyaleDiagnosticGroups.ROYALE_NOT_A_CONSTRUCTOR, CheckLevel.OFF);
            this.options_.setWarningLevel(RoyaleDiagnosticGroups.ROYALE_SUPER_CALL_TO_DIFFERENT_NAME, CheckLevel.OFF);
            this.options_.setWarningLevel(RoyaleDiagnosticGroups.ROYALE_UNKNOWN_JSDOC_TYPE_NAME, CheckLevel.OFF);
        }
        this.options_.sourceMapFormat = SourceMap.Format.V3;
        this.options_.sourceMapOutputPath = sourceMapPath + ".map";
        if (this.skipTypeInference) {
            this.options_.setCheckTypes(false);
            this.options_.setInferTypes(false);
            this.options_.setNewTypeInference(false);
        }
    }

    private static class CompilerOptionsParser
    extends CommandLineRunner {
        public CompilerOptionsParser(String[] args) {
            super(args);
        }

        public CompilerOptions getOptions() throws IOException {
            CompilerOptions options = this.createOptions();
            this.setRunOptions(options);
            return options;
        }
    }
}

