/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.spark.execution;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.core.starter.exception.TaskExecuteException;
import org.apache.seatunnel.core.starter.spark.execution.AbstractPluginExecuteProcessor;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSparkTransformPluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.spark.BaseSparkTransform;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class TransformExecuteProcessor
extends AbstractPluginExecuteProcessor<BaseSparkTransform> {
    private static final String PLUGIN_TYPE = "transform";

    protected TransformExecuteProcessor(SparkEnvironment sparkEnvironment, JobContext jobContext, List<? extends Config> pluginConfigs) {
        super(sparkEnvironment, jobContext, pluginConfigs);
    }

    @Override
    protected List<BaseSparkTransform> initializePlugins(List<? extends Config> pluginConfigs) {
        SeaTunnelSparkTransformPluginDiscovery transformPluginDiscovery = new SeaTunnelSparkTransformPluginDiscovery();
        ArrayList<URL> pluginJars = new ArrayList<URL>();
        List<BaseSparkTransform> transforms = pluginConfigs.stream().map(transformConfig -> {
            PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", PLUGIN_TYPE, transformConfig.getString("plugin_name"));
            pluginJars.addAll(transformPluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier)));
            BaseSparkTransform pluginInstance = (BaseSparkTransform)transformPluginDiscovery.createPluginInstance(pluginIdentifier);
            pluginInstance.setConfig((Config)transformConfig);
            pluginInstance.prepare(this.sparkEnvironment);
            return pluginInstance;
        }).distinct().collect(Collectors.toList());
        this.sparkEnvironment.registerPlugin(pluginJars);
        return transforms;
    }

    @Override
    public List<Dataset<Row>> execute(List<Dataset<Row>> upstreamDataStreams) throws TaskExecuteException {
        if (this.plugins.isEmpty()) {
            return upstreamDataStreams;
        }
        Dataset<Row> input2 = upstreamDataStreams.get(0);
        ArrayList<Dataset<Row>> result2 = new ArrayList<Dataset<Row>>();
        for (int i = 0; i < this.plugins.size(); ++i) {
            BaseSparkTransform transform2 = (BaseSparkTransform)this.plugins.get(i);
            Config pluginConfig = (Config)this.pluginConfigs.get(i);
            Dataset<Row> stream = this.fromSourceTable(pluginConfig, this.sparkEnvironment).orElse(input2);
            input2 = transform2.process(stream, this.sparkEnvironment);
            this.registerInputTempView(pluginConfig, input2);
            result2.add(input2);
        }
        return result2;
    }
}

