/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.topic.TopicOverloadPolicy;
import java.util.concurrent.Executor;

public class ClientReliableTopicConfig
implements NamedConfig {
    public static final int DEFAULT_READ_BATCH_SIZE = 10;
    public static final TopicOverloadPolicy DEFAULT_TOPIC_OVERLOAD_POLICY = TopicOverloadPolicy.BLOCK;
    private Executor executor;
    private int readBatchSize = 10;
    private String name;
    private TopicOverloadPolicy topicOverloadPolicy = DEFAULT_TOPIC_OVERLOAD_POLICY;

    public ClientReliableTopicConfig() {
    }

    public ClientReliableTopicConfig(String name) {
        this.name = Preconditions.checkNotNull(name, "name");
    }

    public ClientReliableTopicConfig(ClientReliableTopicConfig reliableTopicConfig) {
        this.executor = reliableTopicConfig.executor;
        this.readBatchSize = reliableTopicConfig.readBatchSize;
        this.name = reliableTopicConfig.name;
        this.topicOverloadPolicy = reliableTopicConfig.topicOverloadPolicy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ClientReliableTopicConfig setName(String name) {
        this.name = name;
        return this;
    }

    public TopicOverloadPolicy getTopicOverloadPolicy() {
        return this.topicOverloadPolicy;
    }

    public ClientReliableTopicConfig setTopicOverloadPolicy(TopicOverloadPolicy topicOverloadPolicy) {
        this.topicOverloadPolicy = Preconditions.checkNotNull(topicOverloadPolicy, "topicOverloadPolicy can't be null");
        return this;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ClientReliableTopicConfig setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public int getReadBatchSize() {
        return this.readBatchSize;
    }

    public ClientReliableTopicConfig setReadBatchSize(int readBatchSize) {
        this.readBatchSize = Preconditions.checkPositive("readBatchSize", readBatchSize);
        return this;
    }

    public String toString() {
        return "ClientReliableTopicConfig{name='" + this.name + '\'' + ", topicOverloadPolicy=" + (Object)((Object)this.topicOverloadPolicy) + ", executor=" + this.executor + ", readBatchSize=" + this.readBatchSize + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientReliableTopicConfig that = (ClientReliableTopicConfig)o;
        if (this.readBatchSize != that.readBatchSize) {
            return false;
        }
        if (this.executor != null ? !this.executor.equals(that.executor) : that.executor != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.topicOverloadPolicy == that.topicOverloadPolicy;
    }

    public int hashCode() {
        int result2 = this.executor != null ? this.executor.hashCode() : 0;
        result2 = 31 * result2 + this.readBatchSize;
        result2 = 31 * result2 + (this.name != null ? this.name.hashCode() : 0);
        result2 = 31 * result2 + (this.topicOverloadPolicy != null ? this.topicOverloadPolicy.hashCode() : 0);
        return result2;
    }
}

