/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.DataCollection;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.operations.AbstractMultiMapOperation;
import com.hazelcast.multimap.impl.operations.PutAllBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Collection;

public class PutAllOperation
extends AbstractMultiMapOperation
implements MutatingOperation,
BackupAwareOperation {
    private MapEntries mapEntries;

    public PutAllOperation() {
    }

    public PutAllOperation(String name, MapEntries mapEntries) {
        super(name);
        this.mapEntries = mapEntries;
    }

    @Override
    public final void run() {
        int size2 = this.mapEntries != null ? this.mapEntries.size() : 0;
        for (int currentIndex = 0; currentIndex < size2; ++currentIndex) {
            Data dataKey = this.mapEntries.getKey(currentIndex);
            Data value = this.mapEntries.getValue(currentIndex);
            this.put(dataKey, value);
        }
    }

    protected void put(Data dataKey, Data dataValue) {
        MultiMapContainer container = this.getOrCreateContainer();
        Collection<Data> c = ((DataCollection)this.toObject(dataValue)).getCollection();
        Collection<MultiMapRecord> coll = container.getOrCreateMultiMapValue(dataKey).getCollection(false);
        for (Data o : c) {
            MultiMapRecord record = new MultiMapRecord(container.nextId(), this.isBinary() ? o : this.toObject(o));
            if (!coll.add(record)) continue;
            this.getOrCreateContainer().update();
            this.publishEvent(EntryEventType.ADDED, dataKey, o, null);
            this.response = true;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mapEntries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapEntries = (MapEntries)in.readObject();
    }

    @Override
    public int getClassId() {
        return 53;
    }

    @Override
    public Operation getBackupOperation() {
        return new PutAllBackupOperation(this.name, this.mapEntries);
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }
}

