/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.seatunnel.jvm;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.core.starter.seatunnel.jvm.JvmOptionsParserException;

public class JavaVersion {
    public static final List<Integer> CURRENT = JavaVersion.parse(System.getProperty("java.specification.version"));

    static List<Integer> parse(String value) {
        String[] components;
        if (!value.matches("^0*[0-9]+(\\.[0-9]+)*$")) {
            throw new JvmOptionsParserException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, String.format("JAVA version [%s] of the system is incorrect", value));
        }
        ArrayList<Integer> version = new ArrayList<Integer>();
        for (String component : components = value.split("\\.")) {
            version.add(Integer.valueOf(component));
        }
        return version;
    }

    public static int majorVersion(List<Integer> javaVersion) {
        Objects.requireNonNull(javaVersion);
        if (javaVersion.get(0) > 1) {
            return javaVersion.get(0);
        }
        return javaVersion.get(1);
    }
}

