/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.compact.AbstractGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.CompactInternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactWriter;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SerializingGenericRecordCloner
implements GenericRecordBuilder {
    private final Schema schema;
    private final CompactInternalGenericRecord genericRecord;
    private final DefaultCompactWriter cw;
    private final CompactStreamSerializer serializer;
    private final Map<String, Writer> fields = new HashMap<String, Writer>();
    private final Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc;

    public SerializingGenericRecordCloner(CompactStreamSerializer serializer, Schema schema, CompactInternalGenericRecord record, Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc, Supplier<BufferObjectDataOutput> bufferObjectDataOutputSupplier) {
        this.serializer = serializer;
        this.schema = schema;
        this.genericRecord = record;
        this.cw = new DefaultCompactWriter(serializer, bufferObjectDataOutputSupplier.get(), schema, false);
        this.bufferObjectDataInputFunc = bufferObjectDataInputFunc;
    }

    @Override
    @Nonnull
    public GenericRecord build() {
        try {
            for (FieldDescriptor field2 : this.schema.getFields()) {
                String fieldName = field2.getFieldName();
                Writer writer = this.fields.get(fieldName);
                if (writer != null) {
                    writer.write();
                    continue;
                }
                FieldKind fieldKind = field2.getKind();
                FieldOperations.fieldOperations(fieldKind).writeFieldFromRecordToWriter(this.cw, this.genericRecord, fieldName);
            }
            this.cw.end();
            byte[] bytes = this.cw.toByteArray();
            Class associatedClass = this.genericRecord.getAssociatedClass();
            BufferObjectDataInput dataInput = this.bufferObjectDataInputFunc.apply(bytes);
            return new DefaultCompactReader(this.serializer, dataInput, this.schema, associatedClass, false);
        }
        catch (IOException e) {
            throw new HazelcastSerializationException(e);
        }
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt32(@Nonnull String fieldName, int value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.INT32);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeInt32(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt64(@Nonnull String fieldName, long value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.INT64);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeInt64(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String fieldName, String value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.STRING);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeString(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String fieldName, boolean value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.BOOLEAN);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeBoolean(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt8(@Nonnull String fieldName, byte value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.INT8);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeInt8(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String fieldName, char value) {
        throw new UnsupportedOperationException("Compact format does not support writing a char field");
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat64(@Nonnull String fieldName, double value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.FLOAT64);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeFloat64(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat32(@Nonnull String fieldName, float value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.FLOAT32);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeFloat32(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt16(@Nonnull String fieldName, short value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.INT16);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeInt16(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableBoolean(@Nonnull String fieldName, @Nullable Boolean value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.NULLABLE_BOOLEAN);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeNullableBoolean(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt8(@Nonnull String fieldName, @Nullable Byte value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.NULLABLE_INT8);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeNullableInt8(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableFloat64(@Nonnull String fieldName, @Nullable Double value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.NULLABLE_FLOAT64);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeNullableFloat64(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableFloat32(@Nonnull String fieldName, @Nullable Float value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.NULLABLE_FLOAT32);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeNullableFloat32(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt32(@Nonnull String fieldName, @Nullable Integer value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.NULLABLE_INT32);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeNullableInt32(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt64(@Nonnull String fieldName, @Nullable Long value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.NULLABLE_INT64);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeNullableInt64(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt16(@Nonnull String fieldName, @Nullable Short value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.NULLABLE_INT16);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeNullableInt16(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.DECIMAL);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeDecimal(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String fieldName, @Nullable LocalTime value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.TIME);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeTime(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String fieldName, @Nullable LocalDate value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.DATE);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeDate(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.TIMESTAMP);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeTimestamp(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.TIMESTAMP_WITH_TIMEZONE);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeTimestampWithTimezone(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.COMPACT);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeGenericRecord(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_COMPACT);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfGenericRecord(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt8(@Nonnull String fieldName, @Nullable byte[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_INT8);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfInt8(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfBoolean(@Nonnull String fieldName, @Nullable boolean[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_BOOLEAN);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfBoolean(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfChar(@Nonnull String fieldName, @Nullable char[] value) {
        throw new UnsupportedOperationException("Compact format does not support writing an array of chars field");
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt32(@Nonnull String fieldName, @Nullable int[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_INT32);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfInt32(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt64(@Nonnull String fieldName, @Nullable long[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_INT64);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfInt64(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfFloat64(@Nonnull String fieldName, @Nullable double[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_FLOAT64);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfFloat64(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfFloat32(@Nonnull String fieldName, @Nullable float[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_FLOAT32);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfFloat32(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt16(@Nonnull String fieldName, @Nullable short[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_INT16);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfInt16(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableBoolean(@Nonnull String fieldName, @Nullable Boolean[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfNullableBoolean(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt8(@Nonnull String fieldName, @Nullable Byte[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_NULLABLE_INT8);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfNullableInt8(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat64(@Nonnull String fieldName, @Nullable Double[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT64);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfNullableFloat64(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat32(@Nonnull String fieldName, @Nullable Float[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT32);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfNullableFloat32(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt32(@Nonnull String fieldName, @Nullable Integer[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_NULLABLE_INT32);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfNullableInt32(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt64(@Nonnull String fieldName, @Nullable Long[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_NULLABLE_INT64);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfNullableInt64(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt16(@Nonnull String fieldName, @Nullable Short[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_NULLABLE_INT16);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfNullableInt16(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfString(@Nonnull String fieldName, @Nullable String[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_STRING);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfString(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfDecimal(@Nonnull String fieldName, @Nullable BigDecimal[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_DECIMAL);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfDecimal(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTime(@Nonnull String fieldName, @Nullable LocalTime[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_TIME);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfTime(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfDate(@Nonnull String fieldName, @Nullable LocalDate[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_DATE);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfDate(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_TIMESTAMP);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfTimestamp(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime[] value) {
        AbstractGenericRecordBuilder.checkTypeWithSchema(this.schema, fieldName, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE);
        if (this.fields.putIfAbsent(fieldName, () -> this.cw.writeArrayOfTimestampWithTimezone(fieldName, value)) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        return this;
    }

    static interface Writer {
        public void write() throws IOException;
    }
}

