/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.config;

import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.JetConfig;
import javax.annotation.Nonnull;

public final class DelegatingInstanceConfig
extends InstanceConfig {
    private final JetConfig jetConfig;

    public DelegatingInstanceConfig(JetConfig jetConfig) {
        this.jetConfig = jetConfig;
    }

    @Override
    @Nonnull
    public InstanceConfig setCooperativeThreadCount(int size2) {
        super.setCooperativeThreadCount(size2);
        this.jetConfig.setCooperativeThreadCount(size2);
        return this;
    }

    @Override
    public int getCooperativeThreadCount() {
        return this.jetConfig.getCooperativeThreadCount();
    }

    @Override
    @Nonnull
    public InstanceConfig setFlowControlPeriodMs(int flowControlPeriodMs) {
        super.setFlowControlPeriodMs(flowControlPeriodMs);
        this.jetConfig.setFlowControlPeriodMs(flowControlPeriodMs);
        return this;
    }

    @Override
    public int getFlowControlPeriodMs() {
        return this.jetConfig.getFlowControlPeriodMs();
    }

    @Override
    @Nonnull
    public InstanceConfig setBackupCount(int newBackupCount) {
        super.setBackupCount(newBackupCount);
        this.jetConfig.setBackupCount(newBackupCount);
        return this;
    }

    @Override
    public int getBackupCount() {
        return this.jetConfig.getBackupCount();
    }

    @Override
    public InstanceConfig setScaleUpDelayMillis(long millis) {
        super.setScaleUpDelayMillis(millis);
        this.jetConfig.setScaleUpDelayMillis(millis);
        return this;
    }

    @Override
    public long getScaleUpDelayMillis() {
        return this.jetConfig.getScaleUpDelayMillis();
    }

    @Override
    public InstanceConfig setLosslessRestartEnabled(boolean enabled) {
        super.setLosslessRestartEnabled(enabled);
        this.jetConfig.setLosslessRestartEnabled(enabled);
        return this;
    }

    @Override
    public boolean isLosslessRestartEnabled() {
        return this.jetConfig.isLosslessRestartEnabled();
    }

    @Override
    public InstanceConfig setMaxProcessorAccumulatedRecords(long maxProcessorAccumulatedRecords) {
        super.setMaxProcessorAccumulatedRecords(maxProcessorAccumulatedRecords);
        this.jetConfig.setMaxProcessorAccumulatedRecords(maxProcessorAccumulatedRecords);
        return this;
    }

    @Override
    public long getMaxProcessorAccumulatedRecords() {
        return this.jetConfig.getMaxProcessorAccumulatedRecords();
    }

    public void set(InstanceConfig instanceConfig) {
        this.setMaxProcessorAccumulatedRecords(instanceConfig.getMaxProcessorAccumulatedRecords());
        this.setLosslessRestartEnabled(instanceConfig.isLosslessRestartEnabled());
        this.setScaleUpDelayMillis(instanceConfig.getScaleUpDelayMillis());
        this.setBackupCount(instanceConfig.getBackupCount());
        this.setFlowControlPeriodMs(instanceConfig.getFlowControlPeriodMs());
        this.setCooperativeThreadCount(instanceConfig.getCooperativeThreadCount());
    }
}

