/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.checkpoint;

public enum CheckpointType {
    CHECKPOINT_TYPE(true, "checkpoint"),
    SAVEPOINT_TYPE(false, "savepoint"),
    COMPLETED_POINT_TYPE(true, "completed-point");

    private final boolean auto;
    private final String name;

    public static CheckpointType fromName(String name) {
        for (CheckpointType type : CheckpointType.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown checkpoint type: " + name);
    }

    private CheckpointType(boolean auto, String name) {
        this.auto = auto;
        this.name = name;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public String getName() {
        return this.name;
    }
}

