/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.util.graph.BronKerboschCliqueFinder;
import com.hazelcast.internal.util.graph.Graph;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class PartialDisconnectionHandler {
    private final long detectionIntervalMs;
    private final long algorithmTimeoutNanos;
    private Map<MemberImpl, Set<MemberImpl>> disconnections = new HashMap<MemberImpl, Set<MemberImpl>>();
    private long lastUpdated;

    PartialDisconnectionHandler(HazelcastProperties properties) {
        int partialDisconnectionResolutionHeartbeatCount = properties.getInteger(ClusterProperty.PARTIAL_MEMBER_DISCONNECTION_RESOLUTION_HEARTBEAT_COUNT);
        if (partialDisconnectionResolutionHeartbeatCount > 0) {
            long heartbeatIntervalSecs = properties.getInteger(ClusterProperty.HEARTBEAT_INTERVAL_SECONDS);
            long detectionIntervalSecs = (long)partialDisconnectionResolutionHeartbeatCount * heartbeatIntervalSecs;
            long heartbeatTimeoutSecs = properties.getInteger(ClusterProperty.MAX_NO_HEARTBEAT_SECONDS);
            if (heartbeatTimeoutSecs < detectionIntervalSecs) {
                detectionIntervalSecs = heartbeatTimeoutSecs;
            }
            this.detectionIntervalMs = TimeUnit.SECONDS.toMillis(detectionIntervalSecs);
        } else {
            this.detectionIntervalMs = Long.MAX_VALUE;
        }
        long algorithmTimeoutSecs = properties.getLong(ClusterProperty.PARTIAL_MEMBER_DISCONNECTION_RESOLUTION_ALGORITHM_TIMEOUT_SECONDS);
        this.algorithmTimeoutNanos = algorithmTimeoutSecs >= 1L ? TimeUnit.SECONDS.toNanos(algorithmTimeoutSecs) : Long.MAX_VALUE;
    }

    boolean update(MemberImpl member, long timestamp, Collection<MemberImpl> disconnectedMembers) {
        if (timestamp < this.lastUpdated) {
            return false;
        }
        Set<MemberImpl> currentDisconnectedMembers = this.disconnections.get(member);
        if (currentDisconnectedMembers == null) {
            if (disconnectedMembers.isEmpty()) {
                return false;
            }
            currentDisconnectedMembers = new HashSet<MemberImpl>();
            this.disconnections.put(member, currentDisconnectedMembers);
        }
        boolean updated2 = false;
        for (MemberImpl disconnectedMember : disconnectedMembers) {
            if (!currentDisconnectedMembers.add(disconnectedMember) || this.disconnections.getOrDefault(disconnectedMember, Collections.emptySet()).contains(member)) continue;
            this.lastUpdated = timestamp;
            updated2 = true;
        }
        if (currentDisconnectedMembers.retainAll(disconnectedMembers)) {
            this.lastUpdated = timestamp;
            updated2 = true;
        }
        if (currentDisconnectedMembers.isEmpty()) {
            this.disconnections.remove(member);
        }
        return updated2;
    }

    boolean shouldResolvePartialDisconnections(long timestamp) {
        return !this.disconnections.isEmpty() && timestamp - this.lastUpdated >= this.detectionIntervalMs;
    }

    Collection<MemberImpl> resolve(Map<MemberImpl, Set<MemberImpl>> disconnections) throws TimeoutException {
        HashSet<MemberImpl> members = new HashSet<MemberImpl>();
        disconnections.forEach((k, v) -> {
            members.add((MemberImpl)k);
            members.addAll((Collection<MemberImpl>)v);
        });
        Graph<MemberImpl> connectivityGraph = this.buildConnectionGraph(members, disconnections);
        BronKerboschCliqueFinder<MemberImpl> cliqueFinder = this.createCliqueFinder(connectivityGraph);
        Collection<Set<MemberImpl>> maxCliques = cliqueFinder.computeMaxCliques();
        if (cliqueFinder.isTimeLimitReached()) {
            throw new TimeoutException("Partial disconnection resolution algorithm timed out! disconnectivity map: " + disconnections);
        }
        if (maxCliques.isEmpty()) {
            throw new IllegalStateException("Partial disconnection resolution algorithm returned no result! disconnectivity map: " + disconnections);
        }
        HashSet<MemberImpl> membersToRemove = new HashSet<MemberImpl>(members);
        membersToRemove.removeAll((Collection)maxCliques.iterator().next());
        return membersToRemove;
    }

    private Graph<MemberImpl> buildConnectionGraph(Set<MemberImpl> members, Map<MemberImpl, Set<MemberImpl>> disconnections) {
        Graph<MemberImpl> graph = new Graph<MemberImpl>();
        members.forEach(graph::add);
        for (MemberImpl member1 : members) {
            for (MemberImpl member2 : members) {
                if (this.isDisconnected(disconnections, member1, member2)) continue;
                graph.connect(member1, member2);
            }
        }
        return graph;
    }

    private boolean isDisconnected(Map<MemberImpl, Set<MemberImpl>> disconnections, MemberImpl member1, MemberImpl member2) {
        return disconnections.getOrDefault(member1, Collections.emptySet()).contains(member2) || disconnections.getOrDefault(member2, Collections.emptySet()).contains(member1);
    }

    private BronKerboschCliqueFinder<MemberImpl> createCliqueFinder(Graph<MemberImpl> graph) {
        return new BronKerboschCliqueFinder<MemberImpl>(graph, this.algorithmTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    void removeMember(MemberImpl member) {
        this.disconnections.remove(member);
        this.disconnections.values().forEach(members -> members.remove(member));
    }

    Map<MemberImpl, Set<MemberImpl>> reset() {
        Map<MemberImpl, Set<MemberImpl>> disconnections = this.disconnections;
        this.disconnections = new HashMap<MemberImpl, Set<MemberImpl>>();
        return disconnections;
    }

    Map<MemberImpl, Set<MemberImpl>> getDisconnections() {
        return this.disconnections;
    }
}

