/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public final class IterableUtil {
    private IterableUtil() {
    }

    public static <T> T getFirst(Iterable<T> iterable, T defaultValue) {
        Iterator<T> iterator2 = iterable.iterator();
        return iterator2.hasNext() ? iterator2.next() : defaultValue;
    }

    public static <T, R> Iterable<R> map(Iterable<T> iterable, Function<T, R> mapper) {
        return () -> IterableUtil.map(iterable.iterator(), mapper);
    }

    public static <T, R> Iterator<R> map(final Iterator<T> iterator2, final Function<T, R> mapper) {
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    public static <T> Iterable<T> filter(Iterable<T> iterable, final Predicate<T> filter2) {
        final Iterator<T> givenIterator = iterable.iterator();
        Iterator filteringIterator = new Iterator<T>(){
            private T next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (givenIterator.hasNext()) {
                    Object temp = givenIterator.next();
                    if (!filter2.test(temp)) continue;
                    this.next = temp;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object nextLocal = this.next;
                this.next = null;
                return nextLocal;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return () -> filteringIterator;
    }

    public static int size(Iterable iterable) {
        Preconditions.checkNotNull(iterable, "iterable cannot be null");
        int size2 = 0;
        Iterator iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            ++size2;
        }
        return size2;
    }

    public static <T, R> Iterator<R> limit(final Iterator<R> iterator2, final int limit) {
        return new Iterator<R>(){
            private int iterated;

            @Override
            public boolean hasNext() {
                return this.iterated < limit && iterator2.hasNext();
            }

            @Override
            public R next() {
                ++this.iterated;
                return iterator2.next();
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    public static <T> Iterable<T> nullToEmpty(Iterable<T> iterable) {
        return iterable == null ? Collections.emptyList() : iterable;
    }

    public static <T> Iterator<T> asReadOnlyIterator(final Iterator<T> iterator2) {
        if (iterator2 instanceof UnmodifiableIterator) {
            return iterator2;
        }
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public T next() {
                return iterator2.next();
            }
        };
    }
}

