/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.job;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDagGenerator;
import org.apache.seatunnel.engine.core.parse.MultipleTableJobConfigParser;

public abstract class AbstractJobEnvironment {
    protected static ILogger LOGGER = null;
    protected final boolean isStartWithSavePoint;
    protected final List<Action> actions = new ArrayList<Action>();
    protected final Set<URL> jarUrls = new HashSet<URL>();
    protected final JobConfig jobConfig;
    protected final IdGenerator idGenerator;
    protected final List<URL> commonPluginJars = new ArrayList<URL>();

    public AbstractJobEnvironment(JobConfig jobConfig, boolean isStartWithSavePoint) {
        LOGGER = Logger.getLogger(this.getClass().getName());
        this.jobConfig = jobConfig;
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.idGenerator = new IdGenerator();
        this.commonPluginJars.addAll(this.searchPluginJars());
        this.commonPluginJars.addAll(new ArrayList(Common.getThirdPartyJars(jobConfig.getEnvOptions().getOrDefault(EnvCommonOptions.JARS.key(), "").toString()).stream().map(Path::toUri).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new SeaTunnelEngineException("the uri of jar illegal:" + uri, e);
            }
        }).collect(Collectors.toList())));
        LOGGER.info("add common jar in plugins :" + this.commonPluginJars);
    }

    protected Set<URL> searchPluginJars() {
        try {
            if (Files.exists(Common.pluginRootDir(), new LinkOption[0])) {
                return new HashSet<URL>(FileUtils.searchJarFiles(Common.pluginRootDir()));
            }
        }
        catch (IOException | SeaTunnelEngineException e) {
            LOGGER.warning(String.format("Can't search plugin jars in %s.", Common.pluginRootDir()), e);
        }
        return Collections.emptySet();
    }

    protected abstract MultipleTableJobConfigParser getJobConfigParser();

    protected LogicalDagGenerator getLogicalDagGenerator() {
        return new LogicalDagGenerator(this.actions, this.jobConfig, this.idGenerator);
    }

    protected LogicalDag getLogicalDag() {
        ImmutablePair<List<Action>, Set<URL>> immutablePair = this.getJobConfigParser().parse();
        this.actions.addAll((Collection<Action>)immutablePair.getLeft());
        this.jarUrls.addAll((Collection<URL>)immutablePair.getRight());
        return this.getLogicalDagGenerator().generate();
    }
}

