/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.job;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.core.job.AbstractJobEnvironment;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.parse.MultipleTableJobConfigParser;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class JobImmutableInformationEnv
extends AbstractJobEnvironment {
    private final Config seaTunnelJobConfig;
    private final NodeEngineImpl nodeEngine;
    private final Long jobId;

    public JobImmutableInformationEnv(JobConfig jobConfig, Config seaTunnelJobConfig, Node node, boolean isStartWithSavePoint, Long jobId) {
        super(jobConfig, isStartWithSavePoint);
        this.seaTunnelJobConfig = seaTunnelJobConfig;
        this.nodeEngine = node.getNodeEngine();
        this.jobConfig.setJobContext(new JobContext(isStartWithSavePoint ? jobId.longValue() : this.nodeEngine.getHazelcastInstance().getFlakeIdGenerator("SeaTunnelIdGenerator").newId()));
        this.jobId = Long.valueOf(jobConfig.getJobContext().getJobId());
    }

    public Long getJobId() {
        return this.jobId;
    }

    @Override
    protected MultipleTableJobConfigParser getJobConfigParser() {
        return new MultipleTableJobConfigParser(this.seaTunnelJobConfig, this.idGenerator, this.jobConfig, (List<URL>)this.commonPluginJars, this.isStartWithSavePoint);
    }

    public JobImmutableInformation build() {
        return new JobImmutableInformation(Long.parseLong(this.jobConfig.getJobContext().getJobId()), this.jobConfig.getName(), this.isStartWithSavePoint, (Data)this.nodeEngine.getSerializationService().toData(this.getLogicalDag()), this.jobConfig, (List<URL>)new ArrayList<URL>(this.jarUrls));
    }
}

