/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.services.MembershipServiceEvent;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.common.runtime.ExecutionMode;
import org.apache.seatunnel.engine.server.resourcemanager.NoEnoughResourceException;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceRequestHandler;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.ReleaseSlotOperation;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.ResetResourceOperation;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.SyncWorkerProfileOperation;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.resourcemanager.worker.WorkerProfile;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceManager
implements ResourceManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractResourceManager.class);
    private static final long DEFAULT_WORKER_CHECK_INTERVAL = 500L;
    protected final ConcurrentMap<Address, WorkerProfile> registerWorker;
    private final NodeEngine nodeEngine;
    private final ExecutionMode mode = ExecutionMode.LOCAL;
    private volatile boolean isRunning = true;

    public AbstractResourceManager(NodeEngine nodeEngine) {
        this.registerWorker = new ConcurrentHashMap<Address, WorkerProfile>();
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void init() {
        log.info("Init ResourceManager");
        this.initWorker();
    }

    private void initWorker() {
        log.info("initWorker... ");
        List aliveWorker = this.nodeEngine.getClusterService().getMembers().stream().map(Member::getAddress).collect(Collectors.toList());
        log.info("initWorker live nodes: " + aliveWorker);
        List<CompletableFuture> futures = aliveWorker.stream().map(worker -> this.sendToMember(new SyncWorkerProfileOperation(), (Address)worker).thenAccept(p -> this.registerWorker.put((Address)worker, (WorkerProfile)p))).collect(Collectors.toList());
        futures.forEach(CompletableFuture::join);
        log.info("registerWorker: " + this.registerWorker);
    }

    @Override
    public CompletableFuture<SlotProfile> applyResource(long jobId, ResourceProfile resourceProfile) throws NoEnoughResourceException {
        CompletableFuture<SlotProfile> completableFuture = new CompletableFuture<SlotProfile>();
        this.applyResources(jobId, Collections.singletonList(resourceProfile)).whenComplete((profile, error) -> {
            if (error != null) {
                completableFuture.completeExceptionally((Throwable)error);
            } else {
                completableFuture.complete((SlotProfile)profile.get(0));
            }
        });
        return completableFuture;
    }

    private void waitingWorkerRegister() {
        if (ExecutionMode.LOCAL.equals((Object)this.mode)) {
            try {
                while (this.registerWorker.isEmpty() && this.isRunning) {
                    log.info("waiting current worker register to resource manager...");
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        log.warn("Node heartbeat timeout, disconnected for resource manager. Node Address: " + event.getMember().getAddress());
        this.registerWorker.remove(event.getMember().getAddress());
    }

    @Override
    public CompletableFuture<List<SlotProfile>> applyResources(long jobId, List<ResourceProfile> resourceProfile) throws NoEnoughResourceException {
        this.waitingWorkerRegister();
        return new ResourceRequestHandler(jobId, resourceProfile, this.registerWorker, this).request();
    }

    protected boolean supportDynamicWorker() {
        return false;
    }

    protected void findNewWorker(List<ResourceProfile> resourceProfiles) {
        throw new UnsupportedOperationException("Unsupported operation to find new worker in " + this.getClass().getName());
    }

    @Override
    public void close() {
        this.isRunning = false;
    }

    protected <E> CompletableFuture<E> sendToMember(Operation operation, Address address) {
        return NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, operation, address);
    }

    @Override
    public CompletableFuture<Void> releaseResources(long jobId, List<SlotProfile> profiles) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (SlotProfile profile : profiles) {
            futures.add(this.releaseResource(jobId, profile));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((r, e) -> {
            if (e != null) {
                completableFuture.completeExceptionally((Throwable)e);
            } else {
                completableFuture.complete(null);
            }
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> releaseResource(long jobId, SlotProfile profile) {
        if (this.nodeEngine.getClusterService().getMember(profile.getWorker()) != null) {
            return this.sendToMember(new ReleaseSlotOperation(jobId, profile), profile.getWorker());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean slotActiveCheck(SlotProfile profile) {
        boolean active = false;
        if (this.registerWorker.containsKey(profile.getWorker())) {
            active = Arrays.stream(((WorkerProfile)this.registerWorker.get(profile.getWorker())).getAssignedSlots()).anyMatch(s2 -> s2.getSlotID() == profile.getSlotID() && s2.getSequence().equals(profile.getSequence()));
        }
        if (!active) {
            log.info("received slot active check failed, profile: " + profile);
        } else {
            log.info("received slot active check success, profile: " + profile);
        }
        return active;
    }

    @Override
    public void heartbeat(WorkerProfile workerProfile) {
        if (!this.registerWorker.containsKey(workerProfile.getAddress())) {
            log.debug("received new worker register: " + workerProfile.getAddress());
            this.sendToMember(new ResetResourceOperation(), workerProfile.getAddress()).join();
        } else {
            log.debug("received worker heartbeat from: " + workerProfile.getAddress());
        }
        this.registerWorker.put(workerProfile.getAddress(), workerProfile);
    }
}

