/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.console.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.console.sink.ConsoleSink;

@AutoService(value={Factory.class})
public class ConsoleSinkFactory
implements TableSinkFactory {
    public static final Option<Boolean> LOG_PRINT_DATA = Options.key((String)"log.print.data").booleanType().defaultValue((Object)true).withDescription("Flag to determine whether data should be printed in the logs.");
    public static final Option<Integer> LOG_PRINT_DELAY = Options.key((String)"log.print.delay.ms").intType().defaultValue((Object)0).withDescription("Delay in milliseconds between printing each data item to the logs.");

    public String factoryIdentifier() {
        return "Console";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        ReadonlyConfig options = context.getOptions();
        return () -> new ConsoleSink(context.getCatalogTable().getTableSchema().toPhysicalRowDataType(), options);
    }
}

