/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.wan.WanPublisher;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractWanPublisherConfig
implements IdentifiedDataSerializable {
    protected String publisherId = "";
    protected String className;
    protected WanPublisher implementation;
    protected Map<String, Comparable> properties = new HashMap<String, Comparable>();

    public String getPublisherId() {
        return this.publisherId;
    }

    public AbstractWanPublisherConfig setPublisherId(String publisherId) {
        this.publisherId = publisherId;
        return this;
    }

    @Nonnull
    public Map<String, Comparable> getProperties() {
        return this.properties;
    }

    public AbstractWanPublisherConfig setProperties(@Nonnull Map<String, Comparable> properties) {
        this.properties = Preconditions.checkNotNull(properties, "Properties must not be null");
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public AbstractWanPublisherConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Wan publisher class name must contain text!");
        this.implementation = null;
        return this;
    }

    public WanPublisher getImplementation() {
        return this.implementation;
    }

    public AbstractWanPublisherConfig setImplementation(@Nonnull WanPublisher implementation) {
        this.implementation = Preconditions.checkNotNull(implementation, "Wan publisher cannot be null!");
        this.className = null;
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int size = this.properties.size();
        out.writeInt(size);
        for (Map.Entry<String, Comparable> entry : this.properties.entrySet()) {
            out.writeString(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeString(this.className);
        out.writeObject(this.implementation);
        out.writeString(this.publisherId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.properties.put(in.readString(), (Comparable)in.readObject());
        }
        this.className = in.readString();
        this.implementation = (WanPublisher)in.readObject();
        this.publisherId = in.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractWanPublisherConfig that = (AbstractWanPublisherConfig)o;
        return this.publisherId.equals(that.publisherId) && Objects.equals(this.implementation, that.implementation) && Objects.equals(this.className, that.className) && this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.publisherId, this.className, this.implementation, this.properties);
    }
}

