/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.crdt.pncounter;

import com.hazelcast.cluster.impl.VectorClock;
import com.hazelcast.config.Config;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.crdt.MutationDisallowedException;
import com.hazelcast.internal.crdt.CRDTReplicationAwareService;
import com.hazelcast.internal.crdt.CRDTReplicationContainer;
import com.hazelcast.internal.crdt.pncounter.PNCounterImpl;
import com.hazelcast.internal.crdt.pncounter.PNCounterProxy;
import com.hazelcast.internal.crdt.pncounter.PNCounterReplicationOperation;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.ProviderHelper;
import com.hazelcast.internal.monitor.LocalPNCounterStats;
import com.hazelcast.internal.monitor.impl.LocalPNCounterStatsImpl;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.Memoizer;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PNCounterService
implements ManagedService,
RemoteService,
CRDTReplicationAwareService<PNCounterImpl>,
SplitBrainProtectionAwareService,
StatisticsAwareService<LocalPNCounterStats>,
DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:impl:PNCounterService";
    private final ConcurrentMap<String, PNCounterImpl> counters = new ConcurrentHashMap<String, PNCounterImpl>();
    private final ConstructorFunction<String, PNCounterImpl> counterConstructorFn = new ConstructorFunction<String, PNCounterImpl>(){

        @Override
        public PNCounterImpl createNew(String name) {
            if (PNCounterService.this.isShuttingDown) {
                throw new MutationDisallowedException("Cannot create a new PN counter named " + name + " because this instance is shutting down!");
            }
            return new PNCounterImpl(UuidUtil.newUnsecureUUID(), name);
        }
    };
    private final Memoizer<String, Object> splitBrainProtectionConfigCache = new Memoizer<String, Object>(new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            PNCounterConfig counterConfig = PNCounterService.this.nodeEngine.getConfig().findPNCounterConfig(name);
            String splitBrainProtectionName = counterConfig.getSplitBrainProtectionName();
            return splitBrainProtectionName == null ? Memoizer.NULL_OBJECT : splitBrainProtectionName;
        }
    });
    private final ConcurrentMap<String, LocalPNCounterStatsImpl> statsMap = new ConcurrentHashMap<String, LocalPNCounterStatsImpl>();
    private final Map<String, LocalPNCounterStats> unmodifiableStatsMap = Collections.unmodifiableMap(this.statsMap);
    private final ConstructorFunction<String, LocalPNCounterStatsImpl> statsConstructorFunction = name -> new LocalPNCounterStatsImpl();
    private final Object newCounterCreationMutex = new Object();
    private volatile boolean isShuttingDown;
    private NodeEngine nodeEngine;

    public PNCounterImpl getCounter(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.counters, name, this.newCounterCreationMutex, this.counterConstructorFn);
    }

    public boolean containsCounter(String name) {
        return this.counters.containsKey(name);
    }

    public LocalPNCounterStatsImpl getLocalPNCounterStats(String name) {
        if (!this.nodeEngine.getConfig().getPNCounterConfig(name).isStatisticsEnabled()) {
            return null;
        }
        return ConcurrencyUtil.getOrPutSynchronized(this.statsMap, name, this.statsMap, this.statsConstructorFunction);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        if (dsMetricsEnabled) {
            ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        this.counters.clear();
        this.statsMap.clear();
    }

    @Override
    public PNCounterProxy createDistributedObject(String objectName, UUID source, boolean local) {
        return new PNCounterProxy(objectName, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String objectName, boolean local) {
        this.counters.remove(objectName);
        this.statsMap.remove(objectName);
        this.splitBrainProtectionConfigCache.remove(objectName);
    }

    @Override
    public CRDTReplicationContainer prepareReplicationOperation(Map<String, VectorClock> previouslyReplicatedVectorClocks, int targetIndex) {
        HashMap<String, VectorClock> currentVectorClocks = new HashMap<String, VectorClock>();
        HashMap<String, PNCounterImpl> counters = new HashMap<String, PNCounterImpl>();
        Config config = this.nodeEngine.getConfig();
        for (Map.Entry counterEntry : this.counters.entrySet()) {
            String counterName = (String)counterEntry.getKey();
            PNCounterImpl counter2 = (PNCounterImpl)counterEntry.getValue();
            if (targetIndex >= config.findPNCounterConfig(counterName).getReplicaCount()) continue;
            VectorClock counterCurrentVectorClock = counter2.getCurrentVectorClock();
            VectorClock counterPreviousVectorClock = previouslyReplicatedVectorClocks.get(counterName);
            if (counterPreviousVectorClock == null || counterCurrentVectorClock.isAfter(counterPreviousVectorClock)) {
                counters.put(counterName, counter2);
            }
            currentVectorClocks.put(counterName, counterCurrentVectorClock);
        }
        return counters.isEmpty() ? null : new CRDTReplicationContainer(new PNCounterReplicationOperation((Map<String, PNCounterImpl>)counters), currentVectorClocks);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    public void merge(String name, PNCounterImpl value) {
        PNCounterImpl counter2 = this.getCounter(name);
        counter2.merge(value);
        long counterValue = counter2.get(null).getValue();
        this.getLocalPNCounterStats(name).setValue(counterValue);
    }

    @Override
    public CRDTReplicationContainer prepareMigrationOperation(int maxConfiguredReplicaCount) {
        HashMap<String, VectorClock> currentVectorClocks = new HashMap<String, VectorClock>();
        HashMap<String, PNCounterImpl> counters = new HashMap<String, PNCounterImpl>();
        Config config = this.nodeEngine.getConfig();
        for (Map.Entry counterEntry : this.counters.entrySet()) {
            String counterName = (String)counterEntry.getKey();
            PNCounterImpl counter2 = (PNCounterImpl)counterEntry.getValue();
            if (config.findPNCounterConfig(counterName).getReplicaCount() >= maxConfiguredReplicaCount) continue;
            counters.put(counterName, counter2);
            currentVectorClocks.put(counterName, counter2.getCurrentVectorClock());
        }
        return counters.isEmpty() ? null : new CRDTReplicationContainer(new PNCounterReplicationOperation((Map<String, PNCounterImpl>)counters), currentVectorClocks);
    }

    @Override
    public boolean clearCRDTState(Map<String, VectorClock> vectorClocks) {
        boolean allCleared = true;
        for (Map.Entry<String, VectorClock> vectorClockEntry : vectorClocks.entrySet()) {
            String counterName = vectorClockEntry.getKey();
            VectorClock vectorClock = vectorClockEntry.getValue();
            PNCounterImpl counter2 = (PNCounterImpl)this.counters.get(counterName);
            if (counter2 == null) continue;
            if (counter2.markMigrated(vectorClock)) {
                this.counters.remove(counterName);
                this.statsMap.remove(counterName);
                continue;
            }
            allCleared = false;
        }
        return allCleared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareToSafeShutdown() {
        Iterator iterator = this.newCounterCreationMutex;
        synchronized (iterator) {
            this.isShuttingDown = true;
        }
        for (PNCounterImpl counter2 : this.counters.values()) {
            counter2.markMigrated();
        }
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        return (String)this.splitBrainProtectionConfigCache.getOrCalculate(name);
    }

    @Override
    public Map<String, LocalPNCounterStats> getStats() {
        return this.unmodifiableStatsMap;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        ProviderHelper.provide(descriptor, context, "pnCounter", this.getStats());
    }
}

