/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.config.EndpointConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.AbstractChannelInitializer;
import com.hazelcast.internal.server.tcp.MemberProtocolEncoder;
import com.hazelcast.internal.server.tcp.SingleProtocolDecoder;
import com.hazelcast.internal.server.tcp.SingleProtocolEncoder;
import com.hazelcast.internal.server.tcp.TcpServerConnection;

public class MemberChannelInitializer
extends AbstractChannelInitializer {
    MemberChannelInitializer(ServerContext serverContext, EndpointConfig config) {
        super(serverContext, config);
    }

    @Override
    public void initChannel(Channel channel) {
        TcpServerConnection connection = (TcpServerConnection)channel.attributeMap().get(ServerConnection.class);
        OutboundHandler[] outboundHandlers = this.serverContext.createOutboundHandlers(EndpointQualifier.MEMBER, connection);
        InboundHandler[] inboundHandlers = this.serverContext.createInboundHandlers(EndpointQualifier.MEMBER, connection);
        SingleProtocolEncoder protocolEncoder = new SingleProtocolEncoder(new MemberProtocolEncoder(outboundHandlers));
        SingleProtocolDecoder protocolDecoder = new SingleProtocolDecoder(ProtocolType.MEMBER, inboundHandlers, protocolEncoder, true);
        channel.outboundPipeline().addLast(protocolEncoder);
        channel.inboundPipeline().addLast(protocolDecoder);
    }
}

