/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.impl.Networking;
import com.hazelcast.jet.impl.execution.DoneItem;
import com.hazelcast.jet.impl.execution.InboundEdgeStream;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ObjectWithPartitionId;
import com.hazelcast.jet.impl.util.ProgressState;
import com.hazelcast.jet.impl.util.ProgressTracker;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class SenderTasklet
implements Tasklet {
    private static final int BUFFER_SIZE = 32768;
    private final Connection connection;
    private final Queue<Object> inbox = new ArrayDeque<Object>();
    private final ProgressTracker progTracker = new ProgressTracker();
    private final InboundEdgeStream inboundEdgeStream;
    private final BufferObjectDataOutput outputBuffer;
    private final int bufPosPastHeader;
    private final int packetSizeLimit;
    private final String destinationAddressString;
    private final String sourceOrdinalString;
    private final String sourceVertexName;
    @Probe(name="distributedItemsOut")
    private final Counter itemsOutCounter = SwCounter.newSwCounter();
    @Probe(name="distributedBytesOut", unit=ProbeUnit.BYTES)
    private final Counter bytesOutCounter = SwCounter.newSwCounter();
    private boolean instreamExhausted;
    private long sentSeq;
    private volatile int sendSeqLimitCompressed;
    private final Predicate<Object> addToInboxFunction = this.inbox::add;

    public SenderTasklet(InboundEdgeStream inboundEdgeStream, NodeEngine nodeEngine, Address destinationAddress, Connection connection, int destinationVertexId, int packetSizeLimit, long executionId, String sourceVertexName, int sourceOrdinal, InternalSerializationService serializationService) {
        this.inboundEdgeStream = inboundEdgeStream;
        this.destinationAddressString = destinationAddress.toString();
        this.sourceVertexName = sourceVertexName;
        this.sourceOrdinalString = "" + sourceOrdinal;
        this.packetSizeLimit = packetSizeLimit;
        this.connection = connection;
        this.outputBuffer = serializationService.createObjectDataOutput(32768);
        Util.uncheckRun(() -> this.outputBuffer.write(Networking.createStreamPacketHeader(nodeEngine, executionId, destinationVertexId, inboundEdgeStream.ordinal())));
        this.bufPosPastHeader = this.outputBuffer.position();
    }

    @Override
    @Nonnull
    public ProgressState call() {
        this.progTracker.reset();
        this.tryFillInbox();
        if (this.progTracker.isDone()) {
            return this.progTracker.toProgressState();
        }
        if (this.tryFillOutputBuffer()) {
            this.progTracker.madeProgress();
            if (!this.connection.write(new Packet(this.outputBuffer.toByteArray()).setPacketType(Packet.Type.JET))) {
                throw new RestartableException("Connection write failed in " + this.toString());
            }
        }
        return this.progTracker.toProgressState();
    }

    private void tryFillInbox() {
        if (!this.inbox.isEmpty()) {
            this.progTracker.notDone();
            return;
        }
        if (this.instreamExhausted) {
            return;
        }
        this.progTracker.notDone();
        ProgressState result = this.inboundEdgeStream.drainTo(this.addToInboxFunction);
        this.progTracker.madeProgress(result.isMadeProgress());
        this.instreamExhausted = result.isDone();
        if (this.instreamExhausted) {
            this.inbox.add(new ObjectWithPartitionId(DoneItem.DONE_ITEM, -1));
        }
    }

    private boolean tryFillOutputBuffer() {
        try {
            Object item;
            this.outputBuffer.position(this.bufPosPastHeader + 4);
            int writtenCount = 0;
            while (this.outputBuffer.position() < this.packetSizeLimit && SenderTasklet.isWithinLimit(this.sentSeq, this.sendSeqLimitCompressed) && (item = this.inbox.poll()) != null) {
                ObjectWithPartitionId itemWithPId = item instanceof ObjectWithPartitionId ? (ObjectWithPartitionId)item : new ObjectWithPartitionId(item, -1);
                int mark = this.outputBuffer.position();
                this.outputBuffer.writeObject(itemWithPId.getItem());
                this.sentSeq += ReceiverTasklet.estimatedMemoryFootprint(this.outputBuffer.position() - mark);
                this.outputBuffer.writeInt(itemWithPId.getPartitionId());
                ++writtenCount;
            }
            this.outputBuffer.writeInt(this.bufPosPastHeader, writtenCount);
            this.bytesOutCounter.inc(this.outputBuffer.position());
            this.itemsOutCounter.inc(writtenCount);
            return writtenCount > 0;
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void setSendSeqLimitCompressed(int sendSeqLimitCompressed) {
        this.sendSeqLimitCompressed = sendSeqLimitCompressed;
    }

    public String toString() {
        return "SenderTasklet{ordinal=" + this.inboundEdgeStream.ordinal() + ", destinationAddress=" + this.destinationAddressString + ", sourceVertexName='" + this.sourceVertexName + '\'' + '}';
    }

    static boolean isWithinLimit(long sentSeq, int sendSeqLimitCompressed) {
        return ReceiverTasklet.compressSeq(sentSeq) - sendSeqLimitCompressed <= 0;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        descriptor = descriptor.withTag("vertex", this.sourceVertexName).withTag("ordinal", this.sourceOrdinalString).withTag("destinationAddress", this.destinationAddressString);
        context.collect(descriptor, this);
    }
}

