/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.master;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.api.sink.SaveModeExecuteLocation;
import org.apache.seatunnel.api.sink.SaveModeExecuteWrapper;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableSink;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;
import org.apache.seatunnel.engine.common.Constant;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.CheckpointStorageConfig;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobInfo;
import org.apache.seatunnel.engine.core.job.JobResult;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointManager;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointPlan;
import org.apache.seatunnel.engine.server.dag.DAGUtils;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalPlan;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.dag.physical.PlanUtils;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.master.JobHistoryService;
import org.apache.seatunnel.engine.server.metrics.JobMetricsUtil;
import org.apache.seatunnel.engine.server.metrics.SeaTunnelMetricsContext;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.task.operation.CleanTaskGroupContextOperation;
import org.apache.seatunnel.engine.server.task.operation.GetTaskGroupMetricsOperation;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;

public class JobMaster {
    private static final ILogger LOGGER = Logger.getLogger(JobMaster.class);
    private PhysicalPlan physicalPlan;
    private final Data jobImmutableInformationData;
    private final NodeEngine nodeEngine;
    private final ExecutorService executorService;
    private final FlakeIdGenerator flakeIdGenerator;
    private final ResourceManager resourceManager;
    private final JobHistoryService jobHistoryService;
    private CheckpointManager checkpointManager;
    private CompletableFuture<JobResult> jobMasterCompleteFuture;
    private JobImmutableInformation jobImmutableInformation;
    private LogicalDag logicalDag;
    private JobDAGInfo jobDAGInfo;
    private SeaTunnelServer seaTunnelServer;
    private final IMap<PipelineLocation, Map<TaskGroupLocation, SlotProfile>> ownedSlotProfilesIMap;
    private final IMap<Object, Object> runningJobStateIMap;
    private final IMap<Object, Object> runningJobStateTimestampsIMap;
    private boolean isPhysicalDAGIInfo = true;
    private final EngineConfig engineConfig;
    private boolean isRunning = true;
    private Map<Integer, CheckpointPlan> checkpointPlanMap;
    private final Map<Integer, List<SlotProfile>> releasedSlotWhenTaskGroupFinished;
    private final IMap<Long, JobInfo> runningJobInfoIMap;
    private final IMap<Long, HashMap<TaskLocation, SeaTunnelMetricsContext>> metricsImap;
    private volatile boolean needRestore = true;
    private CheckpointConfig jobCheckpointConfig;
    private String errorMessage;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public JobMaster(@NonNull Data jobImmutableInformationData, @NonNull NodeEngine nodeEngine, @NonNull ExecutorService executorService, @NonNull ResourceManager resourceManager, @NonNull JobHistoryService jobHistoryService, @NonNull IMap runningJobStateIMap, @NonNull IMap runningJobStateTimestampsIMap, @NonNull IMap ownedSlotProfilesIMap, @NonNull IMap<Long, JobInfo> runningJobInfoIMap, @NonNull IMap<Long, HashMap<TaskLocation, SeaTunnelMetricsContext>> metricsImap, EngineConfig engineConfig, SeaTunnelServer seaTunnelServer) {
        if (jobImmutableInformationData == null) {
            throw new NullPointerException("jobImmutableInformationData is marked non-null but is null");
        }
        if (nodeEngine == null) {
            throw new NullPointerException("nodeEngine is marked non-null but is null");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        if (jobHistoryService == null) {
            throw new NullPointerException("jobHistoryService is marked non-null but is null");
        }
        if (runningJobStateIMap == null) {
            throw new NullPointerException("runningJobStateIMap is marked non-null but is null");
        }
        if (runningJobStateTimestampsIMap == null) {
            throw new NullPointerException("runningJobStateTimestampsIMap is marked non-null but is null");
        }
        if (ownedSlotProfilesIMap == null) {
            throw new NullPointerException("ownedSlotProfilesIMap is marked non-null but is null");
        }
        if (runningJobInfoIMap == null) {
            throw new NullPointerException("runningJobInfoIMap is marked non-null but is null");
        }
        if (metricsImap == null) {
            throw new NullPointerException("metricsImap is marked non-null but is null");
        }
        this.jobImmutableInformationData = jobImmutableInformationData;
        this.nodeEngine = nodeEngine;
        this.executorService = executorService;
        this.flakeIdGenerator = this.nodeEngine.getHazelcastInstance().getFlakeIdGenerator("SeaTunnelIdGenerator");
        this.ownedSlotProfilesIMap = ownedSlotProfilesIMap;
        this.resourceManager = resourceManager;
        this.jobHistoryService = jobHistoryService;
        this.runningJobStateIMap = runningJobStateIMap;
        this.runningJobStateTimestampsIMap = runningJobStateTimestampsIMap;
        this.runningJobInfoIMap = runningJobInfoIMap;
        this.engineConfig = engineConfig;
        this.metricsImap = metricsImap;
        this.seaTunnelServer = seaTunnelServer;
        this.releasedSlotWhenTaskGroupFinished = new ConcurrentHashMap<Integer, List<SlotProfile>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(long initializationTimestamp, boolean restart) throws Exception {
        this.jobImmutableInformation = (JobImmutableInformation)this.nodeEngine.getSerializationService().toObject(this.jobImmutableInformationData);
        this.jobCheckpointConfig = this.createJobCheckpointConfig(this.engineConfig.getCheckpointConfig(), this.jobImmutableInformation.getJobConfig());
        LOGGER.info(String.format("Init JobMaster for Job %s (%s) ", this.jobImmutableInformation.getJobConfig().getName(), this.jobImmutableInformation.getJobId()));
        LOGGER.info(String.format("Job %s (%s) needed jar urls %s", this.jobImmutableInformation.getJobConfig().getName(), this.jobImmutableInformation.getJobId(), this.jobImmutableInformation.getPluginJarsUrls()));
        ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.seaTunnelServer.getClassLoaderService().getClassLoader(this.jobImmutableInformation.getJobId(), this.jobImmutableInformation.getPluginJarsUrls());
        this.logicalDag = (LogicalDag)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.nodeEngine.getSerializationService(), classLoader, this.jobImmutableInformation.getLogicalDag());
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            if (!restart && !this.logicalDag.isStartWithSavePoint() && ReadonlyConfig.fromMap(this.logicalDag.getJobConfig().getEnvOptions()).get(EnvCommonOptions.SAVEMODE_EXECUTE_LOCATION).equals((Object)SaveModeExecuteLocation.CLUSTER)) {
                this.logicalDag.getLogicalVertexMap().values().stream().map(LogicalVertex::getAction).filter(action -> action instanceof SinkAction).map(sink -> ((SinkAction)sink).getSink()).forEach(JobMaster::handleSaveMode);
            }
            Tuple2<PhysicalPlan, Map<Integer, CheckpointPlan>> planTuple = PlanUtils.fromLogicalDAG(this.logicalDag, this.nodeEngine, this.jobImmutableInformation, initializationTimestamp, this.executorService, this.flakeIdGenerator, this.runningJobStateIMap, this.runningJobStateTimestampsIMap, this.engineConfig.getQueueType(), this.engineConfig);
            this.physicalPlan = planTuple.f0();
            this.physicalPlan.setJobMaster(this);
            this.checkpointPlanMap = planTuple.f1();
        }
        finally {
            Thread.currentThread().setContextClassLoader(appClassLoader);
            this.seaTunnelServer.getClassLoaderService().releaseClassLoader(this.jobImmutableInformation.getJobId(), this.jobImmutableInformation.getPluginJarsUrls());
        }
        Exception initException = null;
        try {
            this.initCheckPointManager(restart);
        }
        catch (Exception e) {
            initException = e;
        }
        this.initStateFuture();
        if (initException != null) {
            if (restart) {
                this.cancelJob();
            }
            throw initException;
        }
    }

    public void initCheckPointManager(boolean restart) throws CheckpointStorageException {
        this.checkpointManager = new CheckpointManager(this.jobImmutableInformation.getJobId(), this.jobImmutableInformation.isStartWithSavePoint() || restart, this.nodeEngine, this, this.checkpointPlanMap, this.jobCheckpointConfig, this.executorService, this.runningJobStateIMap);
    }

    private CheckpointConfig createJobCheckpointConfig(CheckpointConfig defaultCheckpointConfig, JobConfig jobConfig) {
        Map<String, Object> jobEnv = jobConfig.getEnvOptions();
        CheckpointConfig jobCheckpointConfig = new CheckpointConfig();
        jobCheckpointConfig.setCheckpointTimeout(defaultCheckpointConfig.getCheckpointTimeout());
        jobCheckpointConfig.setCheckpointInterval(defaultCheckpointConfig.getCheckpointInterval());
        CheckpointStorageConfig jobCheckpointStorageConfig = new CheckpointStorageConfig();
        jobCheckpointStorageConfig.setStorage(defaultCheckpointConfig.getStorage().getStorage());
        jobCheckpointStorageConfig.setStoragePluginConfig(defaultCheckpointConfig.getStorage().getStoragePluginConfig());
        jobCheckpointStorageConfig.setMaxRetainedCheckpoints(defaultCheckpointConfig.getStorage().getMaxRetainedCheckpoints());
        jobCheckpointConfig.setStorage(jobCheckpointStorageConfig);
        if (jobEnv.containsKey(EnvCommonOptions.CHECKPOINT_INTERVAL.key())) {
            jobCheckpointConfig.setCheckpointInterval(Long.parseLong(jobEnv.get(EnvCommonOptions.CHECKPOINT_INTERVAL.key()).toString()));
        } else if (jobConfig.getJobContext().getJobMode() == JobMode.BATCH) {
            LOGGER.info("in batch mode, the 'checkpoint.interval' configuration of env is missing, so checkpoint will be disabled");
            jobCheckpointConfig.setCheckpointEnable(false);
        }
        if (jobEnv.containsKey(EnvCommonOptions.CHECKPOINT_TIMEOUT.key())) {
            jobCheckpointConfig.setCheckpointTimeout(Long.parseLong(jobEnv.get(EnvCommonOptions.CHECKPOINT_TIMEOUT.key()).toString()));
        }
        return jobCheckpointConfig;
    }

    public void initStateFuture() {
        this.jobMasterCompleteFuture = new CompletableFuture();
        PassiveCompletableFuture<JobResult> jobStatusFuture = this.physicalPlan.initStateFuture();
        jobStatusFuture.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(LOGGER, (v, t) -> {
            this.errorMessage = v.getError();
            JobResult jobResult = new JobResult(this.physicalPlan.getJobStatus(), v.getError());
            this.cleanJob();
            this.jobMasterCompleteFuture.complete(jobResult);
        }));
    }

    public void run() {
        try {
            this.physicalPlan.startJob();
        }
        catch (Throwable e) {
            LOGGER.severe(String.format("Job %s (%s) run error with: %s", this.physicalPlan.getJobImmutableInformation().getJobConfig().getName(), this.physicalPlan.getJobImmutableInformation().getJobId(), ExceptionUtils.getMessage(e)));
        }
        finally {
            this.jobMasterCompleteFuture.join();
            if (this.engineConfig.getConnectorJarStorageConfig().getEnable().booleanValue()) {
                List<ConnectorJarIdentifier> pluginJarIdentifiers = this.jobImmutableInformation.getPluginJarIdentifiers();
                this.seaTunnelServer.getConnectorPackageService().cleanUpWhenJobFinished(this.jobImmutableInformation.getJobId(), pluginJarIdentifiers);
            }
        }
    }

    public static void handleSaveMode(SeaTunnelSink sink) {
        if (sink instanceof SupportSaveMode) {
            Optional<SaveModeHandler> saveModeHandler = ((SupportSaveMode)((Object)sink)).getSaveModeHandler();
            if (saveModeHandler.isPresent()) {
                try (SaveModeHandler handler = saveModeHandler.get();){
                    new SaveModeExecuteWrapper(handler).execute();
                }
                catch (Exception e) {
                    throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.HANDLE_SAVE_MODE_FAILED, (Throwable)e);
                }
            }
        } else if (sink instanceof MultiTableSink) {
            Map<String, SeaTunnelSink> sinks = ((MultiTableSink)sink).getSinks();
            for (SeaTunnelSink seaTunnelSink : sinks.values()) {
                JobMaster.handleSaveMode(seaTunnelSink);
            }
        }
    }

    public void handleCheckpointError(long pipelineId, boolean neverRestore) {
        if (neverRestore) {
            this.neverNeedRestore();
        }
        this.physicalPlan.getPipelineList().forEach(pipeline -> {
            if ((long)pipeline.getPipelineLocation().getPipelineId() == pipelineId) {
                pipeline.handleCheckpointError();
            }
        });
    }

    private void removeJobIMap() {
        Long jobId = this.getJobImmutableInformation().getJobId();
        this.runningJobStateTimestampsIMap.remove(jobId);
        this.getPhysicalPlan().getPipelineList().forEach(pipeline -> {
            this.runningJobStateIMap.remove(pipeline.getPipelineLocation());
            this.runningJobStateTimestampsIMap.remove(pipeline.getPipelineLocation());
            pipeline.getCoordinatorVertexList().forEach(coordinator -> {
                this.runningJobStateIMap.remove(coordinator.getTaskGroupLocation());
                this.runningJobStateTimestampsIMap.remove(coordinator.getTaskGroupLocation());
            });
            pipeline.getPhysicalVertexList().forEach(task -> {
                this.runningJobStateIMap.remove(task.getTaskGroupLocation());
                this.runningJobStateTimestampsIMap.remove(task.getTaskGroupLocation());
            });
        });
        this.runningJobStateIMap.remove(jobId);
        this.runningJobInfoIMap.remove(jobId);
    }

    public JobDAGInfo getJobDAGInfo() {
        if (this.jobDAGInfo == null) {
            this.jobDAGInfo = DAGUtils.getJobDAGInfo(this.logicalDag, this.jobImmutableInformation, this.engineConfig, this.isPhysicalDAGIInfo);
        }
        return this.jobDAGInfo;
    }

    public void releaseTaskGroupResource(PipelineLocation pipelineLocation, TaskGroupLocation taskGroupLocation) {
        Map<TaskGroupLocation, SlotProfile> taskGroupLocationSlotProfileMap = this.ownedSlotProfilesIMap.get(pipelineLocation);
        if (taskGroupLocationSlotProfileMap == null) {
            return;
        }
        SlotProfile taskGroupSlotProfile = taskGroupLocationSlotProfileMap.get(taskGroupLocation);
        if (taskGroupSlotProfile == null) {
            return;
        }
        try {
            RetryUtils.retryWithException(() -> {
                LOGGER.info(String.format("release the task group resource %s", taskGroupLocation));
                this.resourceManager.releaseResources(this.jobImmutableInformation.getJobId(), Collections.singletonList(taskGroupSlotProfile)).join();
                this.releasedSlotWhenTaskGroupFinished.computeIfAbsent(pipelineLocation.getPipelineId(), k -> new CopyOnWriteArrayList()).add(taskGroupSlotProfile);
                return null;
            }, new RetryUtils.RetryMaterial(30, true, org.apache.seatunnel.engine.common.utils.ExceptionUtil::isOperationNeedRetryException, 2000L));
        }
        catch (Exception e) {
            LOGGER.warning(String.format("release the task group resource failed %s, with exception: %s ", taskGroupLocation, ExceptionUtils.getMessage(e)));
        }
    }

    public void releasePipelineResource(SubPlan subPlan) {
        try {
            Map<TaskGroupLocation, SlotProfile> taskGroupLocationSlotProfileMap = this.ownedSlotProfilesIMap.get(subPlan.getPipelineLocation());
            if (taskGroupLocationSlotProfileMap == null) {
                return;
            }
            ArrayList alreadyReleased = new ArrayList();
            if (this.releasedSlotWhenTaskGroupFinished.containsKey(subPlan.getPipelineId())) {
                alreadyReleased.addAll(this.releasedSlotWhenTaskGroupFinished.get(subPlan.getPipelineId()));
            }
            RetryUtils.retryWithException(() -> {
                LOGGER.info(String.format("release the pipeline %s resource", subPlan.getPipelineFullName()));
                this.resourceManager.releaseResources(this.jobImmutableInformation.getJobId(), taskGroupLocationSlotProfileMap.values().stream().filter(p -> !alreadyReleased.contains(p)).collect(Collectors.toList())).join();
                this.ownedSlotProfilesIMap.remove(subPlan.getPipelineLocation());
                this.releasedSlotWhenTaskGroupFinished.remove(subPlan.getPipelineId());
                return null;
            }, new RetryUtils.RetryMaterial(30, true, exception -> org.apache.seatunnel.engine.common.utils.ExceptionUtil.isOperationNeedRetryException(exception), 2000L));
        }
        catch (Exception e) {
            LOGGER.warning(String.format("release the pipeline %s resource failed, with exception: %s ", subPlan.getPipelineFullName(), ExceptionUtils.getMessage(e)));
        }
    }

    public void cleanJob() {
        this.checkpointManager.clearCheckpointIfNeed(this.physicalPlan.getJobStatus());
        this.jobHistoryService.storeJobInfo(this.jobImmutableInformation.getJobId(), this.getJobDAGInfo());
        this.jobHistoryService.storeFinishedJobState(this);
        this.removeJobIMap();
    }

    public Address queryTaskGroupAddress(TaskGroupLocation taskGroupLocation) {
        SlotProfile slotProfile;
        PipelineLocation pipelineLocation = new PipelineLocation(taskGroupLocation.getJobId(), taskGroupLocation.getPipelineId());
        Map<TaskGroupLocation, SlotProfile> taskGroupLocationSlotProfileMap = this.ownedSlotProfilesIMap.get(pipelineLocation);
        if (null != taskGroupLocationSlotProfileMap && null != (slotProfile = taskGroupLocationSlotProfileMap.get(taskGroupLocation))) {
            return slotProfile.getWorker();
        }
        throw new IllegalArgumentException("can't find task group address from taskGroupLocation: " + taskGroupLocation);
    }

    public synchronized void cancelJob() {
        this.physicalPlan.cancelJob();
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public CheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    public PassiveCompletableFuture<JobResult> getJobMasterCompleteFuture() {
        return new PassiveCompletableFuture<JobResult>(this.jobMasterCompleteFuture);
    }

    public JobImmutableInformation getJobImmutableInformation() {
        return this.jobImmutableInformation;
    }

    public JobStatus getJobStatus() {
        return this.physicalPlan.getJobStatus();
    }

    public List<RawJobMetrics> getCurrJobMetrics() {
        HashMap<TaskGroupLocation, Address> taskGroupLocationSlotProfileMap = new HashMap<TaskGroupLocation, Address>();
        this.ownedSlotProfilesIMap.forEach((pipelineLocation, map) -> {
            if (pipelineLocation.getJobId() == this.getJobImmutableInformation().getJobId()) {
                map.forEach((taskGroupLocation, slotProfile) -> {
                    if (taskGroupLocation.getJobId() == this.getJobImmutableInformation().getJobId()) {
                        taskGroupLocationSlotProfileMap.put((TaskGroupLocation)taskGroupLocation, slotProfile.getWorker());
                    }
                });
            }
        });
        return this.getCurrJobMetrics(taskGroupLocationSlotProfileMap);
    }

    public List<RawJobMetrics> getCurrJobMetrics(List<PipelineLocation> pipelineLocations) {
        HashMap<TaskGroupLocation, Address> taskGroupLocationSlotProfileMap = new HashMap<TaskGroupLocation, Address>();
        this.ownedSlotProfilesIMap.forEach((pipelineLocation, map) -> {
            if (pipelineLocations.contains(pipelineLocation)) {
                map.forEach((taskGroupLocation, slotProfile) -> {
                    if (taskGroupLocation.getJobId() == this.getJobImmutableInformation().getJobId()) {
                        taskGroupLocationSlotProfileMap.put((TaskGroupLocation)taskGroupLocation, slotProfile.getWorker());
                    }
                });
            }
        });
        return this.getCurrJobMetrics(taskGroupLocationSlotProfileMap);
    }

    public List<RawJobMetrics> getCurrJobMetrics(Map<TaskGroupLocation, Address> taskGroupLocationSlotProfileMap) {
        HashMap<Address, List> taskGroupLocationMap = new HashMap<Address, List>();
        for (Map.Entry<TaskGroupLocation, Address> entry : taskGroupLocationSlotProfileMap.entrySet()) {
            taskGroupLocationMap.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        ArrayList<RawJobMetrics> metrics = new ArrayList<RawJobMetrics>();
        taskGroupLocationMap.forEach((address, taskGroupLocations) -> {
            try {
                if (this.nodeEngine.getClusterService().getMember((Address)address) != null) {
                    RawJobMetrics rawJobMetrics = (RawJobMetrics)NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, new GetTaskGroupMetricsOperation((List<TaskGroupLocation>)taskGroupLocations), address).get();
                    metrics.add(rawJobMetrics);
                }
            }
            catch (HazelcastInstanceNotActiveException e) {
                LOGGER.warning(String.format("%s get current job metrics with exception: %s.", Arrays.toString(taskGroupLocations.toArray()), ExceptionUtils.getMessage(e)));
            }
            catch (Exception e) {
                throw new SeaTunnelEngineException(ExceptionUtils.getMessage(e));
            }
        });
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePipelineMetricsToHistory(PipelineLocation pipelineLocation) {
        List<RawJobMetrics> currJobMetrics = this.getCurrJobMetrics(Collections.singletonList(pipelineLocation));
        JobMetrics jobMetrics = JobMetricsUtil.toJobMetrics(currJobMetrics);
        long jobId = this.getJobImmutableInformation().getJobId();
        JobMaster jobMaster = this;
        synchronized (jobMaster) {
            this.jobHistoryService.storeFinishedPipelineMetrics(jobId, jobMetrics);
        }
        this.cleanTaskGroupContext(pipelineLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetricsContext(PipelineLocation pipelineLocation, PipelineStatus pipelineStatus) {
        if (pipelineStatus.equals((Object)PipelineStatus.FINISHED) && !this.checkpointManager.isPipelineSavePointEnd(pipelineLocation) || pipelineStatus.equals((Object)PipelineStatus.CANCELED)) {
            try {
                this.metricsImap.lock(Constant.IMAP_RUNNING_JOB_METRICS_KEY);
                HashMap<TaskLocation, SeaTunnelMetricsContext> centralMap = this.metricsImap.get(Constant.IMAP_RUNNING_JOB_METRICS_KEY);
                if (centralMap != null) {
                    List<TaskLocation> collect = centralMap.keySet().stream().filter(taskLocation -> taskLocation.getTaskGroupLocation().getPipelineLocation().equals(pipelineLocation)).collect(Collectors.toList());
                    collect.forEach(centralMap::remove);
                    this.metricsImap.put(Constant.IMAP_RUNNING_JOB_METRICS_KEY, centralMap);
                }
            }
            finally {
                this.metricsImap.unlock(Constant.IMAP_RUNNING_JOB_METRICS_KEY);
            }
        }
    }

    private void cleanTaskGroupContext(PipelineLocation pipelineLocation) {
        Map<TaskGroupLocation, SlotProfile> slotProfileMap = this.ownedSlotProfilesIMap.get(pipelineLocation);
        if (slotProfileMap == null) {
            return;
        }
        slotProfileMap.forEach((taskGroupLocation, slotProfile) -> {
            try {
                if (this.nodeEngine.getClusterService().getMember(slotProfile.getWorker()) != null) {
                    NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, new CleanTaskGroupContextOperation((TaskGroupLocation)taskGroupLocation), slotProfile.getWorker()).get();
                }
            }
            catch (HazelcastInstanceNotActiveException e) {
                LOGGER.warning(String.format("%s clean TaskGroupContext with exception: %s.", taskGroupLocation, ExceptionUtils.getMessage(e)));
            }
            catch (Exception e) {
                throw new SeaTunnelException(e.getMessage());
            }
        });
    }

    public PhysicalPlan getPhysicalPlan() {
        return this.physicalPlan;
    }

    public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        this.physicalPlan.getPipelineList().forEach(pipeline -> {
            if (pipeline.getPipelineLocation().getPipelineId() != taskExecutionState.getTaskGroupLocation().getPipelineId()) {
                return;
            }
            pipeline.getCoordinatorVertexList().forEach(task -> {
                if (!task.getTaskGroupLocation().equals(taskExecutionState.getTaskGroupLocation())) {
                    return;
                }
                task.updateStateByExecutionService(taskExecutionState);
            });
            pipeline.getPhysicalVertexList().forEach(task -> {
                if (!task.getTaskGroupLocation().equals(taskExecutionState.getTaskGroupLocation())) {
                    return;
                }
                task.updateStateByExecutionService(taskExecutionState);
                if (taskExecutionState.getExecutionState().isEndState()) {
                    this.releaseTaskGroupResource(pipeline.getPipelineLocation(), task.getTaskGroupLocation());
                }
            });
        });
    }

    public CompletableFuture<Boolean> savePoint() {
        LOGGER.info(String.format("Begin do save point for Job %s (%s) ", this.jobImmutableInformation.getJobConfig().getName(), this.jobImmutableInformation.getJobId()));
        this.physicalPlan.savepointJob();
        PassiveCompletableFuture[] passiveCompletableFutures = this.checkpointManager.triggerSavePoints();
        return CompletableFuture.supplyAsync(() -> Arrays.stream(passiveCompletableFutures).allMatch(future -> {
            try {
                return future.get() != null;
            }
            catch (Exception e) {
                throw new SeaTunnelEngineException(e);
            }
        }));
    }

    public void setOwnedSlotProfiles(@NonNull PipelineLocation pipelineLocation, @NonNull Map<TaskGroupLocation, SlotProfile> pipelineOwnedSlotProfiles) {
        if (pipelineLocation == null) {
            throw new NullPointerException("pipelineLocation is marked non-null but is null");
        }
        if (pipelineOwnedSlotProfiles == null) {
            throw new NullPointerException("pipelineOwnedSlotProfiles is marked non-null but is null");
        }
        this.ownedSlotProfilesIMap.put(pipelineLocation, pipelineOwnedSlotProfiles);
        try {
            RetryUtils.retryWithException(() -> pipelineOwnedSlotProfiles.equals(this.ownedSlotProfilesIMap.get(pipelineLocation)), new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof NullPointerException && this.isRunning, 2000L));
        }
        catch (Exception e) {
            throw new SeaTunnelEngineException("Can not sync pipeline owned slot profiles with IMap", e);
        }
    }

    public SlotProfile getOwnedSlotProfiles(@NonNull TaskGroupLocation taskGroupLocation) {
        if (taskGroupLocation == null) {
            throw new NullPointerException("taskGroupLocation is marked non-null but is null");
        }
        Map<TaskGroupLocation, SlotProfile> taskGroupLocationSlotProfileMap = this.ownedSlotProfilesIMap.get(new PipelineLocation(taskGroupLocation.getJobId(), taskGroupLocation.getPipelineId()));
        if (taskGroupLocationSlotProfileMap == null) {
            return null;
        }
        return taskGroupLocationSlotProfileMap.get(taskGroupLocation);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void interrupt() {
        this.isRunning = false;
        this.jobMasterCompleteFuture.completeExceptionally(new InterruptedException());
    }

    public void neverNeedRestore() {
        this.needRestore = false;
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public boolean isNeedRestore() {
        return this.needRestore;
    }
}

