/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.metrics.Counter;
import org.apache.seatunnel.api.common.metrics.Meter;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.event.handler.DataTypeChangeEventDispatcher;
import org.apache.seatunnel.api.table.event.handler.DataTypeChangeEventHandler;
import org.apache.seatunnel.api.table.type.MultipleRowType;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.core.starter.flowcontrol.FlowControlGate;
import org.apache.seatunnel.core.starter.flowcontrol.FlowControlStrategy;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelSourceCollector<T>
implements Collector<T> {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelSourceCollector.class);
    private final Object checkpointLock;
    private final List<OneInputFlowLifeCycle<Record<?>>> outputs;
    private final MetricsContext metricsContext;
    private final AtomicBoolean schemaChangeBeforeCheckpointSignal = new AtomicBoolean(false);
    private final AtomicBoolean schemaChangeAfterCheckpointSignal = new AtomicBoolean(false);
    private final Counter sourceReceivedCount;
    private final Map<String, Counter> sourceReceivedCountPerTable = new ConcurrentHashMap<String, Counter>();
    private final Meter sourceReceivedQPS;
    private final Counter sourceReceivedBytes;
    private final Meter sourceReceivedBytesPerSeconds;
    private volatile boolean emptyThisPollNext;
    private final DataTypeChangeEventHandler dataTypeChangeEventHandler = new DataTypeChangeEventDispatcher();
    private Map<String, SeaTunnelRowType> rowTypeMap = new HashMap<String, SeaTunnelRowType>();
    private SeaTunnelDataType rowType;
    private FlowControlGate flowControlGate;

    public SeaTunnelSourceCollector(Object checkpointLock, List<OneInputFlowLifeCycle<Record<?>>> outputs, MetricsContext metricsContext, FlowControlStrategy flowControlStrategy, SeaTunnelDataType rowType, List<TablePath> tablePaths) {
        this.checkpointLock = checkpointLock;
        this.outputs = outputs;
        this.rowType = rowType;
        this.metricsContext = metricsContext;
        if (rowType instanceof MultipleRowType) {
            ((MultipleRowType)rowType).iterator().forEachRemaining(type -> this.rowTypeMap.put((String)type.getKey(), (SeaTunnelRowType)type.getValue()));
        }
        if (CollectionUtils.isNotEmpty(tablePaths)) {
            tablePaths.forEach(tablePath -> this.sourceReceivedCountPerTable.put(this.getFullName((TablePath)tablePath), metricsContext.counter("SourceReceivedCount#" + this.getFullName((TablePath)tablePath))));
        }
        this.sourceReceivedCount = metricsContext.counter("SourceReceivedCount");
        this.sourceReceivedQPS = metricsContext.meter("SourceReceivedQPS");
        this.sourceReceivedBytes = metricsContext.counter("SourceReceivedBytes");
        this.sourceReceivedBytesPerSeconds = metricsContext.meter("SourceReceivedBytesPerSeconds");
        this.flowControlGate = FlowControlGate.create(flowControlStrategy);
    }

    @Override
    public void collect(T row) {
        try {
            if (row instanceof SeaTunnelRow) {
                int size;
                String tableId = ((SeaTunnelRow)row).getTableId();
                if (this.rowType instanceof SeaTunnelRowType) {
                    size = ((SeaTunnelRow)row).getBytesSize((SeaTunnelRowType)this.rowType);
                } else if (this.rowType instanceof MultipleRowType) {
                    size = ((SeaTunnelRow)row).getBytesSize(this.rowTypeMap.get(tableId));
                } else {
                    throw new SeaTunnelEngineException("Unsupported row type: " + this.rowType.getClass().getName());
                }
                this.sourceReceivedBytes.inc(size);
                this.sourceReceivedBytesPerSeconds.markEvent(size);
                this.flowControlGate.audit((SeaTunnelRow)row);
                if (StringUtils.isNotEmpty(tableId)) {
                    String tableName = this.getFullName(TablePath.of(tableId));
                    Counter sourceTableCounter = this.sourceReceivedCountPerTable.get(tableName);
                    if (Objects.nonNull(sourceTableCounter)) {
                        sourceTableCounter.inc();
                    } else {
                        Counter counter2 = this.metricsContext.counter("SourceReceivedCount#" + tableName);
                        counter2.inc();
                        this.sourceReceivedCountPerTable.put(tableName, counter2);
                    }
                }
            }
            this.sendRecordToNext(new Record<T>(row));
            this.emptyThisPollNext = false;
            this.sourceReceivedCount.inc();
            this.sourceReceivedQPS.markEvent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void collect(SchemaChangeEvent event) {
        try {
            if (this.rowType instanceof SeaTunnelRowType) {
                this.rowType = this.dataTypeChangeEventHandler.reset((SeaTunnelRowType)this.rowType).apply(event);
            } else if (this.rowType instanceof MultipleRowType) {
                String tableId = event.tablePath().toString();
                this.rowTypeMap.put(tableId, this.dataTypeChangeEventHandler.reset(this.rowTypeMap.get(tableId)).apply(event));
            } else {
                throw new SeaTunnelEngineException("Unsupported row type: " + this.rowType.getClass().getName());
            }
            this.sendRecordToNext(new Record<SchemaChangeEvent>(event));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void markSchemaChangeBeforeCheckpoint() {
        if (this.schemaChangeAfterCheckpointSignal.get()) {
            throw new IllegalStateException("schema-change-after checkpoint already marked.");
        }
        if (!this.schemaChangeBeforeCheckpointSignal.compareAndSet(false, true)) {
            throw new IllegalStateException("schema-change-before checkpoint already marked.");
        }
        log.info("mark schema-change-before checkpoint signal.");
    }

    @Override
    public void markSchemaChangeAfterCheckpoint() {
        if (this.schemaChangeBeforeCheckpointSignal.get()) {
            throw new IllegalStateException("schema-change-before checkpoint already marked.");
        }
        if (!this.schemaChangeAfterCheckpointSignal.compareAndSet(false, true)) {
            throw new IllegalStateException("schema-change-after checkpoint already marked.");
        }
        log.info("mark schema-change-after checkpoint signal.");
    }

    public boolean captureSchemaChangeBeforeCheckpointSignal() {
        if (this.schemaChangeBeforeCheckpointSignal.get()) {
            log.info("capture schema-change-before checkpoint signal.");
            return this.schemaChangeBeforeCheckpointSignal.getAndSet(false);
        }
        return false;
    }

    public boolean captureSchemaChangeAfterCheckpointSignal() {
        if (this.schemaChangeAfterCheckpointSignal.get()) {
            log.info("capture schema-change-after checkpoint signal.");
            return this.schemaChangeAfterCheckpointSignal.getAndSet(false);
        }
        return false;
    }

    @Override
    public Object getCheckpointLock() {
        return this.checkpointLock;
    }

    @Override
    public boolean isEmptyThisPollNext() {
        return this.emptyThisPollNext;
    }

    @Override
    public void resetEmptyThisPollNext() {
        this.emptyThisPollNext = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRecordToNext(Record<?> record) throws IOException {
        Object object = this.checkpointLock;
        synchronized (object) {
            for (OneInputFlowLifeCycle<Record<?>> output : this.outputs) {
                output.received(record);
            }
        }
    }

    private String getFullName(TablePath tablePath) {
        if (StringUtils.isBlank(tablePath.getTableName())) {
            tablePath = TablePath.of(tablePath.getDatabaseName(), tablePath.getSchemaName(), "default");
        }
        return tablePath.getFullName();
    }
}

